<h3>What Does This Do?</h3>
<p>This module is designed as a hub to allow other modules to send notification messages via various mechanisms, given a notification &quot;profile&quot; which specifies which notification mechanisms to use given a priority and a current time.  It is useful, for example to send facebook or twitter posts when a user earns a badge, or to send an email to a user when something in the website changed.  This module is a work in progress.</p>
<h3>Features</h3>
  <ul>
    <li>Uses &quot;profiles&quot; that indicate how notifications should be delivered.</li>
    <li>Supports a default notification profile for the admin.</li>
    <li>FrontEnd users can have a notification profile.</li>
    <li>Provides a built in Email notification mechanism.</li>
    <li>Supports notification mechanisms provided by third party modules, such as CGTweet, CGSMS, or CGFBApp</li>
  </ul>
<h3>How do I Use it?</h3>
  <ol>
    <li>Install the module, and install and configure and some additional provider modules, such as CGTWeet or CGSMS.</li>
    <li>Setup a default profile to control how notifications to administrators should be handled.</li>
    <li>Provide a mechanism whereby users can control notifications.
       <p><code>{CGNotifier}</code></p>
       <p>The default action provides a form to allow logged in frontend users to createo a notification profile.  The included form uses
          JQuery and fancybox which must be included in the page or page template before the module is called.</p>
    </li>
   <li>Modules that send notification messages <em>(such as CGSocialApp)</em> can then send notifications to, or on behalf of that user using the built in API.</li>
  </ol>
<h3>Programming:</h3>
<p>To send notification messages using CGNotifier, modules must follow these three steps:</p>
<ul>
<li>1.  Create and fill out a notification_message object.  Be sure to include a subject, body, and priority.</li>
<li>2.  Get the CGNotifier module object reference.</li>
<li>3.  Call the CGNotifier notify method with the notification_message object created above.</li>
</ul>
<h4>Example:</h4>
<pre><code>$msg = new notification_message();
$msg-&gt;module = 'My Modules Name';
$msg-&gt;subject = 'Test Notification';
$msg-&gt;body = 'Hello World';
$msg-&gt;priority = notification_message::PRIORITY_NORMAL;
$module = cms_utils::get_module('CGNotifier');
$module->notify($msg);</code></pre>
<h4>notification_message class.</h4>
<p>This class is actually hosted in the CGExtensions module as it is used by a few other modules.</p>
<h5>Constants:</h5>
<ul>
  <li>PRIORITY_HIGH</li>
  <li>PRIORITY_NORMAL <em>(default)</em></li>
  <li>PRIORITY_LOW</li>
</ul>
<h5>Public Members:</h5>
<p>Note though there are many member variables, the sender module is responsible for taking the information in the module and dispatching it as it sees fit.  i.e:  the CGFBApp module may use the subject,link,linkname,description,and caption members and supports messages of 60000+ characters.  The CGTweet module ignores those fields, and supports a message body of only up to 140 characters.  However, it supports URL shortening where the CGFBApp module does not (AT this time).</p>
<ul>
  <li>subject <strong>required</strong> <em>(text)</em> - The message subject
    <p>Some sender methods may not require or use a subject, however you should still fill it in as you do not know what the users profile will require.</p>
  </li>
  <li>body <strong>required</strong> <em>(text)</em> - The message body
    <p>Some sender methods may limit the number of characters in the message. i.e: twitter has a limit of 140 chars.</p>
  </li>
  <li>module <em>(string)</em> - The sending module.</li>
  <li>to <strong>required</strong> <em>(integer)</em> - the UID to send to.  A negative value assumes an admin UID, a positive value assumes an FEU uid.</li>
  <li>lat <em>(float)</em> - The latitude to attach to the post.</li>
  <li>long <em>(float)</em> - The latitude to attach to the post.</li>
  <li>html <em>(boolean)</em> - Flag indicating that the body contains html code.</li>
  <li>link <em>(string)</em> - Some sending methods allow specifying a link to include with the message.</li>
  <li>linkname <em>(string)</em> - A name for the optional link.</li>
  <li>caption <em>(string)</em> - A caption for the optional link.</li>
  <li>description <em>(string)</em> - A description for the optional link.</li>
  <li>picture <em>(string)</em> - An optional picture URL.</li>
  <li>shorten <em>(boolean)</em> - Flag indicating that URLS should be shortened if possible before sending.  This is particularly useful for Twitter.  See the CGTiny module.</li>
</ul>
<h5>Methods:</h5>
  <ul>
<li>valid_key(string)
  <p>Test if the key provided is valid.</p>
  <p>returns: boolean</p>
  </ul>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2012, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>