<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGNotifier (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# An addon module for CMSMS to allow sending notifications in various forms.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

$handlers = $this->GetModulesWithCapability('cg_messaging_client');
if( is_array($handlers) && count($handlers) > 0 ) {
  $handlers2 = array();
  foreach( $handlers as $one ) {
    $mod = cms_utils::get_module($one);
    if( !$mod ) continue;
    $handlers2[$one] = $mod->get_transport_name();
  }
  $smarty->assign('handlers',$handlers2);

  $myprofile = array();
  $tmp = get_preference(get_userid(),$this->GetName().'_profile');
  if( $tmp ) $myprofile = unserialize($tmp);

  $smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_savemyprofile',$returnid));
  $smarty->assign('formend',$this->CreateFormEnd());
  $smarty->assign('profile',$myprofile);
  $smarty->assign('profile_name','MY PROFILE');

  $priorities = array();
  $priorities[-1] = $this->Lang('any');
  $priorities[notification_message::PRIORITY_LOW] = $this->Lang('low');
  $priorities[notification_message::PRIORITY_NORMAL] = $this->Lang('normal');
  $priorities[notification_message::PRIORITY_HIGH] = $this->Lang('high');
  $smarty->assign('priorities',$priorities);

  $tmp = ModuleOperations::get_instance()->GetInstalledModules();
  // this will return the module names not the friendly names... because would need to instantiate
  // each module in order to generate the list with friendly names.
  $modules = array();
  $modules[-1] = $this->Lang('any');
  foreach( $tmp as $one ) {
    $modules[$one] = $one;
  }

  $smarty->assign('modules',$modules);
}

echo $this->ProcessTemplate('admin_myprofile_tab.tpl');

#
# EOF
#
?>