<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGNotifier (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# An addon module for CMSMS to allow sending notifications in various forms.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->VisibleToAdminUser() ) exit;

echo $this->StartTabHeaders();
if( $this->CheckPermission('Manage My Notifications') ) {
  echo $this->SetTabHeader('myprofile',$this->Lang('myprofile'));
}
if( $this->CheckPermission('Modify Site Preferences') ) {
  echo $this->SetTabHeader('dfltprofile',$this->Lang('dfltprofile'));
  echo $this->SetTabHeader('test',$this->Lang('test'));
  echo $this->SetTabHeader('settings',$this->Lang('settings'));
}

if( $this->CheckPermission('Modify Templates') ) {
  echo $this->SetTabHeader('editformtpl',$this->Lang('editformtpl'));
  echo $this->SetTabHeader('defaulttemplates',$this->Lang('defaulttemplates'));
}
echo $this->EndTabHeaders();

echo $this->StartTabContent();
if( $this->CheckPermission('Manage My Notifications') ) {
  echo $this->StartTab('myprofile');
  include(__DIR__.'/function.admin_myprofile_tab.php');
  echo $this->EndTab();
}
if( $this->CheckPermission('Modify Site Preferences') ) {
  echo $this->StartTab('dfltprofile');
  include(dirname(__FILE__).'/function.admin_dfltprofile_tab.php');
  echo $this->EndTab();

  echo $this->StartTab('test');
  include(dirname(__FILE__).'/function.admin_test_tab.php');
  echo $this->EndTab();

  echo $this->StartTab('settings');
  include(dirname(__FILE__).'/function.admin_settings_tab.php');
  echo $this->EndTab();
}

if( $this->CheckPermission('Modify Templates') ) {
  echo $this->StartTab('editformtpl');
  include(dirname(__FILE__).'/function.admin_editformtpl_tab.php');
  echo $this->EndTab();
  
  echo $this->StartTab('defaulttemplates');
  include(dirname(__FILE__).'/function.admin_defaulttemplates_tab.php');
  echo $this->EndTab();
}
echo $this->EndTabContent();

#
# EOF
#
?>