<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGNotifier (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# An addon module for CMSMS to allow sending notifications in various forms.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$feu = cms_utils::get_module(MOD_FRONTENDUSERS);
$uid = $feu->LoggedInId();
if( $uid < 1 ) return;

$tpl = $this->GetPreference($this::CURDFLT_EDITFORM_NAME);
if( isset($params['template']) ) $tpl = trim($params['template']);

$profile = null;
$tmp = $feu->GetUserPropertyFull($this::FEU_PROPNAME,$uid);
if( $tmp ) {
  $profile = unserialize($tmp);
}
if( !is_object($profile) ) $profile = new notification_profile;

if( isset($params['cgn_save']) ) {
  $profile = new notification_profile();
  $keys = array('priority:priority','module:module','start_time:start_time','end_time:end_time','send_method:send_method');
  for( $i = 0; $i < count($params['cgn_send_method']); $i++ ) {
    $item = new notification_profile_item;
    foreach( $keys as $key ) {
      list($a,$b) = explode(':',$key,2);
      $key2 = 'cgn_'.$b;
      $v = $params[$key2][$i];
      $item->$a = $v;
    }
    $profile->add_item($item);
  }

  try {
    $profile->validate();
    $feu->SetUserPropertyFull($this::FEU_PROPNAME,serialize($profile),$uid);
    $smarty->assign('message',$this->Lang('profile_saved'));
  }
  catch( Exception $e ) {
    $smarty->assign('error',$e->GetMessage());
  }
}

$handlers = $this->GetModulesWithCapability('cg_messaging_client');
if( !is_array($handlers) || count($handlers) == 0 ) return;
$handlers2 = array();
foreach( $handlers as $one ) {
  $mod = cms_utils::get_module($one);
  if( !$mod ) continue;
  $handlers2[$one] = $mod->get_transport_name();
}
$smarty->assign('send_methods',$handlers2);

$smarty->assign('profile',$profile);
$smarty->assign('formstart',$this->CGCreateFormStart($id,'default',$returnid));
$smarty->assign('formend',$this->CreateFormEnd());

$priorities = array();
$priorities[-1] = $this->Lang('any');
$priorities[notification_message::PRIORITY_LOW] = $this->Lang('low');
$priorities[notification_message::PRIORITY_NORMAL] = $this->Lang('normal');
$priorities[notification_message::PRIORITY_HIGH] = $this->Lang('high');
$smarty->assign('priorities',$priorities);

$tmp = ModuleOperations::get_instance()->GetInstalledModules();
// this will return the module names not the friendly names... because would need to instantiate
// each module in order to generate the list with friendly names.
$modules = array();
$modules[-1] = $this->Lang('any');
foreach( $tmp as $one ) {
  $modules[$one] = $one;
}
$smarty->assign('modules',$modules);

$smarty->assign('edititem_img',$this->DisplayImage('edit_item.png',$this->Lang('edit_profile_entry'),'icon vertcenter edititem',32,32));
$smarty->assign('additem_img',$this->DisplayImage('add_item.png',$this->Lang('add_profile_entry'),'icon vertcenter additem',32,32));
$smarty->assign('deleteitem_img',$this->DisplayImage('delete_item.png',$this->Lang('delete_profile_entry'),'icon vertcenter delitem',32,32));
$smarty->assign('timezone',date_default_timezone_get());
$smarty->assign('helpicon',$this->DisplayImage('help.gif','','icon'));
echo $this->ProcessTemplateFromDatabase('editform_'.$tpl);

#
# EOF
#
?>