<?php

class cgtweetcommand
{
  private $_consumer_key;
  private $_consumer_secret;
  private $_user_key;
  private $_user_secret;

  public function __construct($consumer_key,$consumer_secret)
  {
    if( !$consumer_key || !$consumer_secret ) {
      throw new Exception('Invalid consumer key or consumer secret');
    }
    $this->_consumer_key = $consumer_key;
    $this->_consumer_secret = $consumer_secret;

    require_once(dirname(__FILE__).'/twitteroauth/twitteroauth.php');
  }

  public function set_user_token($user_key,$user_secret)
  {
    if( !$user_key || !$user_secret ) {
      throw new Exception('Invalid consumer key or consumer secret');
    }
    $this->_user_key = $user_key;
    $this->_user_secret = $user_secret;
  }

  private function &_get_connection()
  {
    $obj = new TwitterOAuth($this->_consumer_key,$this->_consumer_secret,
			    $this->_user_key,$this->_user_secret);
    return $obj;
  }

  public function post_update(notification_message $msg)
  {
    if( !$msg->body ) {
      throw new Exception('Nothing to send');
    }

    // process the message
    $body = substr(strip_tags($msg->body),0,140);

    // and send it.
    $connection = $this->_get_connection();
    $parms = array();
    $parms['status'] = $body;
    if( $msg->lat && $msg->long ) {
      $parms['lat'] = $msg->lat;
      $parms['long'] = $msg->long;
    }
    $res = $connection->post('statuses/update',$parms);
    if( !is_object($res) ) {
      throw new Exception('Error tweet failed, result not an object');
    }
    if( isset($res->error) ) {
      throw new Exception($res->error);
    }
    return $res;
  }
} // end of class

?>