<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSendTwitter (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow conversion of postal codes
#  from the geoname service.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

if( !class_exists('CGExtensions') ) {
  $cgextensions = cms_join_path($gCms->config['root_path'],'modules','CGExtensions','CGExtensions.module.php');
  if( !is_readable( $cgextensions ) ) {
    echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
    return;
  }
  require_once($cgextensions);
}

define('CGTWEET_AUTHTEMPLATE_DFLTNAME','cgtweet_authtemplate_dfltname');
define('CGTWEET_AUTHTEMPLATE_SYSDFLT','cgtweet_authtemplate_sysdflt');
define('CGTWEET_TIMELINE_DFLTNAME','cgtweet_timeline_dfltname');
define('CGTWEET_TIMELINE_SYSDFLT','cgtweet_timeline_sysdflt');

class CGTweet extends CGExtensions
{
  public function GetName() { return 'CGTweet'; }
  public function GetVersion() { return '1.1.1'; }
  public function GetAuthor() { return 'calguy1000'; }
  public function GetAuthorEmail() { return 'calguy1000@cmsmadesimple.org'; }
  public function IsPluginModule() { return true; }
  public function HasAdmin() { return true; }
  public function GetAdminSection() { return 'extensions'; }
  public function GetAdminDescription() { return $this->Lang('moddescription'); }
  public function MinimumCMSVersion() { return '1.11.7'; }
  public function LazyLoadAdmin() { return TRUE; }
  public function LazyLoadFrontend() { return TRUE; }

  public function GetDependencies() 
  { 
    return array('CGExtensions'=>'1.37.2','FrontEndUsers'=>'1.19.1','CGSimpleSmarty'=>'1.7'); 
  }

  public function VisibleToAdminUser() 
  {
    return $this->CheckPermission('Modify Site Preferences') || $this->CheckPermission('Modify Templates');
  }

  public function GetFriendlyName() 
  {
    $t = $this->GetPreference('friendlyname');
    if( !$t ) $t = $this->Lang('friendlyname');
    return $t;
  }

  public function GetHelp()
  {
    return @file_get_contents(dirname(__FILE__).'/help.inc');
  }

  public function GetChangeLog()
  {
    return @file_get_contents(dirname(__FILE__).'/changelog.inc');
  }

  public function InitializeFrontend()
  {
    $this->RestrictUnknownParams();
    $this->RegisterModulePlugin();
    $this->SetParameterType('authtemplate',CLEAN_STRING);
    $this->SetParameterType('inline',CLEAN_INT);
    $this->SetParameterType('authstep',CLEAN_INT);
    $this->SetParameterType('count',CLEAN_INT);
    $this->SetParameterType('cache',CLEAN_INT);
    $this->SetParameterType('deep',CLEAN_INT);
    $this->SetParameterType('noreplies',CLEAN_INT);
    $this->SetParameterType('retweets',CLEAN_INT);
    $this->SetParameterType('timelinetemplate',CLEAN_STRING);
  }

  public function InitializeAdmin()
  {
    $this->CreateParameter('action','',$this->Lang('help_action'));
    $this->CreateParameter('authtemplate','',$this->Lang('help_authtemplate'));
    $this->CreateParameter('inline','',$this->Lang('help_inline'));
    $this->CreateParameter('count','',$this->Lang('help_count'));
    $this->CreateParameter('deep','',$this->Lang('help_deep')); 
    $this->CreateParameter('noreplies','',$this->Lang('help_noreplies')); 
    $this->CreateParameter('retweets','',$this->Lang('help_retweets')); 
    $this->CreateParameter('timelinetemplate','',$this->Lang('help_timelinetemplate'));
  }

  public function InstallPostMessage() { return $this->Lang('postinstall'); }
  public function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  public function UninstallPreMessage() { return $this->Lang('really_uninstall'); }

  public function HasCapability($capability, $params = array())
  {
    if( $capability == 'cg_messaging_client' ) return TRUE;
    if( $capability == 'cg_socialblast_sender' ) return TRUE;
    return FALSE;
  }

  function get_transport_name() { return 'Twitter'; }

  public function get_user_key($uid)
  {
    $feu = cms_utils::get_module('FrontEndUsers');
    if( !is_object($feu) ) throw new CmsException($this->Lang('error_nofeu'));
    if( $uid < 1 ) throw new CmsInvalidDataException($this->Lang('error_invaliduid',$uid));
    $data = $feu->GetUserProperty('__'.$this->GetName().'__');
    if( $data ) {
      $rawprop = cgtweet_utils::decrypt($data);
      $prop = unserialize($rawprop);
      if( is_array($prop) && isset($prop['token']) && isset($prop['secret']) ) return $prop;
    }
  }

  public function set_user_key($uid,$auth_token,$auth_secret)
  {
    $feu = cms_utils::get_module('FrontEndUsers');
    if( !is_object($feu) ) throw new CmsException($this->Lang('error_nofeu'));
    if( $uid < 1 ) throw new CmsInvalidDataException($this->Lang('error_invaliduid',$uid));
    if( $auth_token == '' || $auth_secret == '' ) throw new CmsInvalidDataException($this->Lang('error_access_settings'));
    $data = cgtweet_utils::encrypt(serialize(array('token'=>$auth_token,'secret'=>$auth_secret)));
    $feu->SetUserPropertyFull('__'.$this->GetName().'__',$data,$uid);
  }

  public function send_message(notification_message $msg)
  {
    if( !$msg->body ) {
      audit('',$this->GetName(),'Attempt to send an invalid message');
      throw new CmsInvalidDataException($this->Lang('error_invalidmessage'));
    }

    $creds = new cgtweet_credentials;
    $creds->consumer_key = cgtweet_utils::decrypt($this->GetPreference('consumer_key'));
    $creds->consumer_secret = cgtweet_utils::decrypt($this->GetPreference('consumer_secret'));

    // see if we can get credentials for this user
    $access_token = $access_token_secret = '';
    if( $msg->to ) {
      if( $msg->to < 0 ) {
	// get creds from admin account
	die('not done yet');
	$data = get_preference($msg->to*-1,$this->GetName().'_token');
      }
      else {
	// get creds from feu for THI user
	$feu = cms_utils::get_module('FrontEndUsers');
	if( $feu ) {
	  $prop = $this->get_user_key($feu->LoggedInId());
	  if( is_array($prop) 
	      && isset($prop['token']) 
	      && isset($prop['secret']) ) {
	    $creds->user_key = $prop['token'];
	    $creds->user_secret = $prop['secret'];
	  }
	}
      }
    }
    else {
      // use default creds.
      $creds->user_key = cgtweet_utils::decrypt($this->GetPreference('access_token'));
      $creds->user_secret = cgtweet_utils::decrypt($this->GetPreference('access_token_secret'));
    }

    if( !$creds->is_valid() ) {
      audit('',$this->GetName().'Attempt to send message but no valid access tokens found');
      throw new CmsInvalidDataException($this->Lang('error_credentials'));
    }

    try {
      // shorten any urls in the message maybe?
      $shorten = FALSE;
      $tmp = $this->GetModulesWithCapability('shorten_url');
      if( is_array($tmp) && count($tmp) && $this->GetPreference('shorten_urls',0) ) $shorten = TRUE;
      if( isset($msg->shorten) && !$msg->shorten ) $shorten = FALSE;

      $body = cgtweet_utils::html_to_tweet($msg->body,$shorten);

      $parms = array('status'=>$body);
      if( $msg->lat && $msg->long ) {
	$parms['lat'] = $msg->lat;
	$parms['long'] = $msg->long;
      }
      cgtweet_utils::post($creds,'statuses/update',$parms);
      audit('',$this->GetName(),'Sent twitter status update');
    }
    catch( Exception $e ) {
      audit('',$this->GetName(),$e->GetMessage());
      throw $e;
    }
  }

  public function &get_sender_info()
  {
    $res = new sb_sender_info($this->GetName(),'Twitter',140,0);
    $res['info_message'] = $this->Lang('info_sender_twitter');
    return $res;
  }
} // class

?>
