<?php
#-------------------------------------------------------------------------
#
# Oliver Seddon, <oliver@threefold.co.uk>
# Web: www.threefold.co.uk
#
# Tapio Lytty, <tapsa@orange-media.fi>
# Web: www.orange-media.fi
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class listit2fd_AmazonS3 extends ListIt2FielddefBase
{
	private $_s3;

	public function __construct(&$db_info) 
	{	
		parent::__construct($db_info);
		
		$this->SetFriendlyType($this->ModLang('fielddef_'.$this->GetType()));
	}
	
	public function GetS3()
	{
		if(isset($this->_s3))
			return $this->_s3;

		$accesskey = $this->GetOptionValue('accesskey');
		$accesssecret = $this->GetOptionValue('accesssecret');
			
		$this->_s3 = new S3($accesskey, $accesssecret);
		
		return $this->GetS3();	
	}

	public function GetFiles()
	{	
		$bucket = $this->GetOptionValue('bucket');
		$contents = @$this->GetS3()->getBucket($bucket);

		if(!$contents)
			return FALSE;
		
		$output = array();
		foreach($contents as $file) {
		
			$fname = $file['name'];
			$output[trim($fname)] = trim($fname);
		}
		
		return $output;
	}
	
	public function GetURLValue()
	{
		$bucket = $this->GetOptionValue('bucket');
		
		return "http://". $bucket . "." . S3::$endpoint . "/". $this->GetValue();
	}

} // end of class
?>