<?php
#-------------------------------------------------------------------------
#
# Oliver Seddon, <oliver@threefold.co.uk>
# Web: www.threefold.co.uk
#
# Tapio Lytty, <tapsa@orange-media.fi>
# Web: www.orange-media.fi
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class listit2eh_AmazonS3 extends ListIt2EventHandlerBase
{
	#---------------------
	# Variables
	#---------------------	

	private $_data;

	#---------------------
	# Magic methods
	#---------------------		
	
	public function __construct(ListIt2FielddefBase &$field)
	{
		parent::__construct($field);
	}
	
	#---------------------
	# Overwritable events
	#---------------------	

	public function ItemSavePreProcess(&$errors, &$params) 
	{			
		// Fill _data from $_FILES
		$files = self::_diverse_array($_FILES['m1_customfield']); // <- $id is statically part of key, not ideal.
		if(isset($files[$this->GetId()]))
			$this->_data = $files[$this->GetId()]; // <- My assumption is that $_FILES contains correct structure and there fore array is complete. Am i wrong? 1 + 1 = 2!

		// Check that _data is valid
		if(isset($this->_data) && $this->_data['error'] === 0) {				

			$bucket = $this->GetOptionValue('bucket');
			
			//create a new bucket
			$this->GetS3()->putBucket($bucket, S3::ACL_PUBLIC_READ);
				
			//move the file
			if (!$this->GetS3()->putObjectFile($this->_data['tmp_name'], $bucket, $this->_data['name'], S3::ACL_PUBLIC_READ)) {
				
				$errors[] = $this->ModLang('error_failed_to_upload') . ' (' . $this->GetName() . ')';
			}			
			
			// Set Value from _data
			if(empty($errors)) {
				
				$this->SetValue($this->_data['name']);
			}			
		}
	
		parent::ItemSavePreProcess($errors, $params);
	}	

	#---------------------
	# Private methods
	#---------------------	
	
	private static function _diverse_array($vector) {
		
		$result = array();
		foreach($vector as $key1 => $value1) {
		
			foreach($value1 as $key2 => $value2) {
		
				$result[$key2][$key1] = $value2;
			}
		}
		
		return $result;
	} 	
	
} // end of class

?>	