<?php
$lang['friendlyname'] = 'Sections';
$lang['postinstall'] = 'Module "Sections" successfully installed!';
$lang['postuninstall'] = 'Module "Sections" successfully uninstalled!';
$lang['really_uninstall'] = 'Are you sure you want to uninstall module "Sections"?';
$lang['uninstalled'] = 'Module "Sections" uninstalled.';
$lang['installed'] = 'Module "Sections" - version %s installed.';
$lang['moddescription'] = 'Sections - are blocks of content that you can place in your templates and pages by using the \'tags\'';
$lang['help'] = '
<p>From author: Sorry for my English!</p>
<h3>What is this module?</h3>
<p>This module allows you to create a section in which you can put any content, whether it\'s just a text or js-code.</p>
<p>You can insert the tag of the module into the template and editing the section tab "Display conditions", select pages on which this section will be visible.</p>
<p>This can be useful if you want to show in the same place on the page different content, but do not want to make this in the content area of​the page.</p>
<p>You can also set a start date of the show and the end date of the show. Setting these options will mean that the section will only show in a given period of time and you do not have to worry about turning off of certain sections on specific days.</p>
<h3>How to use it?</h3>
<p>After creating a section insert placeholder {Sections name = \'internal_name\'} in a template or in a page or anywhere else.</p>
<h4>Display conditions</h4>
<h5>The selection of the date for the show</h5>
<p>You can select the start date and end date of the show. If both numbers are selected, the section will only appear in a given period of dates.</p>
<h5>Selecting pages to display</h5>
<p>If you insert a section into the template, then by default it will appear on all the pages in which this template is selected. However, if you edit the section in the "Display conditions" tab you select the pages on which you would like to see a section, it will only appear on selected pages.</p>
<p>Also, for convenience, you can choose the pages on which the section should not be displayed.</p>
<h3>Parsing tags (placeholders) in the section content</h3>
<p>In the Content section, you can use all tags without any restrictions.</p>
<h3>JavaScript</h3>
<p>Use the section in JavaScript is very simple. For this you need to do just a few steps.</p>
<ol>
<li>Create a template in which only put the tag {content}. For example, you can call it "_system_".</li>
<li>Create a section, put it in the content that is required to get through JavaScript.</li>
<li>Create your page and apply for it a template _system_. As a content specify the section like {Sections name = \'internal_name\' format = \'json\'}. \'Format\' parameter specifies the form in which to return data. If you specify a json, then the content section will be returned in json format, if you specify the default, then the content section will be returned in normal html format.</li>
</ol>
<p>Now you can get the content of the section through ajax.</p>
';

#Permissions Descriptions
$lang['PermissionShowSectionsModule'] = 'Module "Sections": Show module';

#Params Help
$lang['ParamHelpName'] = '"Internal name" of section';
$lang['ParamHelpFormat'] = 'The data format. Possible formats: default, json';

#Module texts
$lang["SectionsList"] = 'Sections list';
$lang["Settings"] = 'Settings';
$lang["AddSection"] = 'Add section';
$lang["EditSection"] = 'Edit section';
$lang["DeleteSection"] = 'Delete section';
$lang["Placeholder"] = 'Tag for use';
$lang["Name"] = 'Name';
$lang["Description"] = 'Description';
$lang["InternalName"] = 'Internal name';
$lang["InternalNameFormat"] = 'Can only containt latin letters, numbers and underlines. This is a unique section name, which is used in the placeholder.';
$lang["IsActive"] = 'Active';
$lang["SetActive"] = 'Set active';
$lang["SetInactive"] = 'Set inactive';
$lang["Pages"] = 'Pages';
$lang["DisplayConditions"] = 'Display conditions';
$lang["Properties"] = 'Properties';
$lang["Content"] = 'Content';
$lang["FromDate"] = 'From date';
$lang["ToDate"] = 'To date';
$lang["Save"] = 'Save';
$lang["SaveAndExit"] = 'Save and exit';
$lang["Cancel"] = 'Cancel';
$lang["SectionDateRange"] = 'Active in period';
$lang["from"] = 'from';
$lang["to"] = 'to';
$lang["NoWysiwyg"] = 'Turn off visual editor in this section';
$lang["ShowOnPages"] = 'Show on the following pages';
$lang["NotToShowOnPages"] = 'Do not show on the following pages';
$lang["ShowOn"] = 'Show only on';
$lang["NotToShowOn"] = 'Don\'t show only on';

#Confirms
$lang["ConfirmSectionEditCancel"] = 'Are you sure you want to cancel editing section and exit?\n\nWARNING: All unsaved data will be lost.';
$lang["ConfirmSectionDelete"] = 'Are you sure you want to delete this section?';

#Errors
$lang["ErrInternalNameEmpty"] = 'The internal name can not be empty!';
$lang["ErrInternalNameInvalid"] = 'Internal name is not valid. Only the following characters can be used: a-z, 0-9 and underscore \'_\' !';
$lang["ErrWrongDateFormat"] = 'Wrong date or date format!';
$lang["ErrSectionNameExists"] = 'This section internal name is already in use!';

#Messages
$lang["MsgSectionSaved"] = 'Section sucessfully saved!';
$lang["MsgSectionDeleted"] = 'Section sucessfully removed!';

#Admin log
$lang['AuditSectionAdded'] = 'New section "%s" added.';
$lang['AuditSectionUpdated'] = 'Updated section "%s".';
$lang['AuditSectionSetActive'] = 'Section "%s" is set active.';
$lang['AuditSectionSetInactive'] = 'Section "%s" is set inactive.';

#Datepicker
$lang["Previous"] = 'Previous';
$lang["Next"] = 'Next';
$lang["January"] = 'January';
$lang["February"] = 'February';  
$lang["March"] = 'March';  
$lang["April"] = 'April';  
$lang["May"] = 'May';  
$lang["June"] = 'June';  
$lang["July"] = 'July';  
$lang["August"] = 'August';  
$lang["September"] = 'September';  
$lang["October"] = 'October';  
$lang["November"] = 'November';  
$lang["December"] = 'December';
$lang["JanuaryMin"] = 'Jan';  
$lang["FebruaryMin"] = 'Feb';  
$lang["MarchMin"] = 'Mar';  
$lang["AprilMin"] = 'Apr';  
$lang["MayMin"] = 'May';  
$lang["JuneMin"] = 'Jun';  
$lang["JulyMin"] = 'Jul';  
$lang["AugustMin"] = 'Aug';  
$lang["SeptemberMin"] = 'Sep';  
$lang["OctoberMin"] = 'Oct';  
$lang["NovemberMin"] = 'Nov';  
$lang["DecemberMin"] = 'Dec';
$lang["MondayMin"] = 'Mo';  
$lang["TuesdayMin"] = 'Tu';  
$lang["WednesdayMin"] = 'We';  
$lang["ThursdayMin"] = 'Tu';  
$lang["FridayMin"] = 'Fr';  
$lang["SaturdayMin"] = 'Sa';  
$lang["SundayMin"] = 'Su';
$lang["Monday"] = 'Monday';  
$lang["Tuesday"] = 'Tuesday';  
$lang["Wednesday"] = 'Wednesday';  
$lang["Thursday"] = 'Thursday';  
$lang["Friday"] = 'Friday';  
$lang["Saturday"] = 'Saturday';  
$lang["Sunday"] = 'Sunday';
?>
