<?php
#CMS - CMS Made Simple
#(c)2004 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://cmsmadesimple.sf.net
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class tweetfeed {
	var $twitterAccount;
	var $consumerKey;
	var $consumerSecret;
	var $userToken;
	var $userSecret;
	var $tweetCount;
	var $tweetClass;
	var $showDate = 'false';
	var $dateLast = 'false';
	var $tweetDateClass;
	var $tweetDatePretty;
	var $showIcon = 'false';
	var $tweetIcon;
	var $tweetIconClass;
	var $tweetWrapper;
	
	var $rss;
	  
	function __constructor($twitterAccount = '', $consumerKey = '', $consumerSecret = '', $userToken = '', $userSecret = '',   $tweetCount = '10', $tweetClass = '', $showDate = 'false', $dateLast = 'false', $dateFormat = 'd/m/Y - H:i', $tweetDateClass = '', $tweetDatePretty = '', $showIcon = 'false', $tweetIcon = '', $tweetIconClass = '', $tweetWrapper = ''){	
		
		
		
		$this->tweetfeed($twitterAccount, $consumerKey, $consumerSecret, $userToken, $userSecret, $tweetCount, $tweetClass, $showDate, $dateLast, $dateFormat, $tweetDateClass, $tweetDatePretty, $showIcon, $tweetIcon, $tweetIconClass, $tweetWrapper);
	}
	 
	function tweetfeed($twitterAccount, $consumerKey, $consumerSecret, $userToken, $userSecret, $tweetCount, $tweetClass, $showDate, $dateLast, $dateFormat, $tweetDateClass, $tweetDatePretty, $showIcon, $tweetIcon, $tweetIconClass, $tweetWrapper) {
		$this->twitterAccount = $twitterAccount;
		$this->consumerKey = $consumerKey;
		$this->consumerSecret = $consumerSecret;
		$this->userToken = $userToken;
		$this->userSecret = $userSecret;
		$this->tweetCount = $tweetCount;
		$this->tweetClass = $tweetClass;
		$this->showDate = $showDate;
		$this->dateLast = $dateLast;
		$this->dateFormat = $dateFormat;
		$this->tweetDateClass = $tweetDateClass;
		$this->tweetDatePretty = $tweetDatePretty;
		$this->showIcon = $showIcon;
		$this->tweetIcon = $tweetIcon;
		$this->tweetIconClass = $tweetIconClass;
		$this->tweetWrapper = $tweetWrapper;
	
		if(strlen($twitterAccount) == '0') {
			// account not specified
			$this->showError(1);
			return false;
		}
		else {			

			require 'tmhOAuth-master/tmhOAuth.php';
		
			require 'tmhOAuth-master/tmhUtilities.php';
		
			$tmhOAuth = new tmhOAuth(array(
		
			  'consumer_key'    => $this->consumerKey,
		
			  'consumer_secret' => $this->consumerSecret,
		
			  'user_token'      => $this->userToken,
		
			  'user_secret'     => $this->userSecret,
		
			));
				
				//$method 
				$method = "https://api.twitter.com/1.1/statuses/user_timeline.json";
				$params = array(
				  // parameters go here
				  'screen_name' => $this->twitterAccount,
				  'count' => $this->tweetCount
				);
				$tmhOAuth->request('GET', $method, $params, 'my_streaming_callback', false);
				$response = $tmhOAuth->response['response'];
				$responseArr = json_decode($response);
				//var_dump($responseArr); //get the response array.

				$i = 0;

				if($this->tweetWrapper == '' || $this->tweetWrapper == 'ul') {
					echo "<ul";
					if($this->tweetClass != '') {
						echo " class=\"$this->tweetClass\">\n";
					} else {
						echo ">\n";
					}
				}elseif($this->tweetWrapper == 'p') {
					echo "<div";
					if($this->tweetClass != '') {
						echo " class=\"$this->tweetClass\">\n";
					} else {
						echo ">\n";
					}
				}
				
				foreach ($responseArr as $item) {
					if($i < $this->tweetCount) {
						// Description: Remove the account name
						$tweetContent = str_replace($this->twitterAccount.": ", "", $item->text);
							// LINKS are now clickable
						$tweetContent = preg_replace('#(http|https)(://[A-Za-z0-9-_àäâéèëêïîôöùüûç]+)(\.[a-z]{2,5})([A-Za-z0-9_/\+\?\.-]*)#s', '<a href="$1$2$3$4" target="_blank">$1$2$3$4</a>', $tweetContent);
							// #LINKS are now clickable
						$tweetContent = preg_replace('/#([A-Za-z0-9_-àäâéèëêïîôöùüûç]+)/s', ' <a href="http://twitter.com/search?q=%23$1" target="_blank">#$1</a>', $tweetContent);	
							// @LINKS are now clickable
						$tweetContent = preg_replace('#@([A-Za-z0-9_-àäâéèëêïîôöùüûç]+)#s', ' <a href="http://twitter.com/$1" target="_blank">@$1</a>', $tweetContent);
						$tweetDate = strtotime($item->created_at);
						if ($tweetDatePretty == 'true') {
							$nowDateMin = date('m');
							$nowDateHour = date('H');
							$nowDateDay = date('d');
							$nowDateMonth = date('m');
							$nowDateYear = date('Y');
							$tweetDateMin = date('m', $tweetDate);
							$tweetDateHour = date('H', $tweetDate);
							$tweetDateDay = date('d', $tweetDate);
							$tweetDateMonth = date('m', $tweetDate);
							$tweetDateYear = date('Y', $tweetDate);
							if($tweetDateYear < $nowDateYear) {
								$tweetDateDiff = $nowDateYear - $tweetDateYear;
								if($tweetDateDiff == '1') {
									$tweetDate = 'About 1 year ago';
								} else {
									$tweetDate = 'About '. $tweetDateDiff .' years ago';
								}
							} else if($tweetDateMonth < $nowDateMonth) {
								$tweetDateDiff = $nowDateMonth - $tweetDateMonth;
								if($tweetDateDiff == '1') {
									$tweetDate = 'About 1 month ago';
								} else {
									$tweetDate = 'About '. $tweetDateDiff .' months ago';
								}
							} else if($tweetDateDay < $nowDateDay) {
								$tweetDateDiff = $nowDateDay - $tweetDateDay;
								if($tweetDateDiff == '1') {
									$tweetDate = 'About 1 day ago';
								} else {
									$tweetDate = 'About '. $tweetDateDiff .' days ago';
								}
							} else if($tweetDateHour < $nowDateHour) {
								$timeDiff = $nowDateHour - $tweetDateHour;
								if($timeDiff == '1') {
									$tweetDate = 'About 1 hour ago';
								} else {
									$tweetDate = 'About '. $timeDiff .' hours ago';
								}
							} else {
								$timeDiff = $nowDateMin - $tweetDateMin;
								if($timeDiff < '1') {
									$tweetDate = 'Less than a minute ago';
								} else if($timeDiff == '1') {
									$tweetDate = 'About 1 minute ago';
								} else {
									$tweetDate = 'About '. $timeDiff .' minutes ago';
								}
							}
						} else {
							$tweetDate = date($this->dateFormat, $tweetDate);
						}
						$this->displayTweet($tweetContent, $tweetDate, $i);
						
						$i++;
					}
					else {
						break;
					}
				}
				if($this->tweetWrapper == '' || $this->tweetWrapper == 'ul') {
					echo "\n</ul>";
				}elseif($this->tweetWrapper == 'p') {
					echo "\n</div>";
				}

		}
	}
	
	function my_streaming_callback($data, $length, $metrics) {
	  echo $data .PHP_EOL;
	  return file_exists(dirname(__FILE__) . '/STOP');
	}

	function displayTweet($tweetContent, $tweetDate, $i) {
		
		if($this->tweetWrapper == '' || $this->tweetWrapper == 'ul') {
			echo "<li>\n";
		}elseif($this->tweetWrapper == 'p') {
			echo "<p>\n";
		}
		if($this->showIcon == 'true') {
			list($width, $height, $type, $attr) = getimagesize($this->tweetIcon);
			echo "<span";
			if($this->tweetIconClass != '') {
				echo " class=\"$this->tweetIconClass\"><img src=\"$this->tweetIcon\" $attr alt=\"Tweet icon\" /></span>";
			} else {	
				echo "><img src=\"$this->tweetIcon\" $attr alt=\"Tweet icon\" /></span>";
			}
		}
		if($this->showDate == 'true' && $this->dateLast == 'false') {
			echo "<span";
			if($this->tweetDateClass != '') {
				echo " class=\"$this->tweetDateClass\">$tweetDate&nbsp;</span>";
			} else {
				echo ">$tweetDate&nbsp;</span>";
			}
		}
		echo "$tweetContent";

		if($this->showDate == 'true' && $this->dateLast == 'true') {
			echo "<span";
			if($this->tweetDateClass != '') {
				echo " class=\"$this->tweetDateClass\">$tweetDate&nbsp;</span>";
			} else {
				echo ">$tweetDate&nbsp;</span>";
			}
		}
		if($this->tweetWrapper == '' || $this->tweetWrapper == 'ul') {
			echo "</li>\n";
		}elseif($this->tweetWrapper == 'p') {
			echo "</p>\n";
		}
	}
	
	function showError($errorId) {
		// @params: (int) $erroId
		//	- 1: Account error OR rss unavailable
		//	- 2: Params missing: twitterAccount
		
		$msg = '';
		
		switch($errorId) {
		case 1:
			$msg = "A Twitter account name has not been specified or cannot be found";
			break;
		case 2:
			$msg = "There was an error retrieving your Tweets.";
			break;
		default:
			break;
		}
		
		echo "<p style=\"color: red;\"><strong>" . $msg . "</strong></p>\n";
	}
	
	function showDebugInfo() {
		echo "<ul><li><strong>twitterAccount:</strong> $this->twitterAccount</li>\n";
		echo "<li><strong>tweetClass:</strong> $this->tweetClass</li>\n";
		echo "<li><strong>tweetCount:</strong> $this->tweetCount</li>\n";
		echo "<li><strong>RSS:</strong> $this->rss</li>\n";
		echo "<li><strong>showDate:</strong> $this->showDate</li>\n";
		echo "<li><strong>dateLast:</strong> $this->dateLast</li>\n";
		echo "<li><strong>dateFormat:</strong> $this->dateFormat</li>\n";
		echo "<li><strong>tweetDateClass:</strong> $this->tweetDateClass</li>\n";
		echo "<li><strong>tweetDatePretty:</strong> $this->tweetDatePretty</li>\n";
		echo "<li><strong>showIcon:</strong> $this->showIcon</li>\n";
		echo "<li><strong>tweetIcon:</strong> $this->tweetIcon</li>\n";
		echo "<li><strong>tweetIconClass:</strong> $this->tweetIconClass</li>\n";
		echo "<li><strong>consumerKey:</strong>	$this->consumerKey</li>\n";
		echo "<li><strong>consumerSecret:</strong> $this->consumerSecret</li>\n";
		echo "<li><strong>userToken:</strong> $this->userToken</li>\n";
		echo "<li><strong>userSecret:</strong> $this->userSecret</li>\n";
		echo "<li><strong>tweetWrapper:</strong> $this->tweetWrapper</li>\n";

		echo "</ul>\n";
	}
}



function smarty_cms_function_tweetfeed($params, &$smarty) {
	$gCms = cmsms();
	$config =& $gCms->GetConfig();
	
	$debug = isset($params['debug']) ? $params['debug']:'false';
	$twitterAccount = isset($params['twitterAccount']) ? $params['twitterAccount']:'';
	$consumerKey = isset($params['consumerKey']) ? $params['consumerKey']:'';
	$consumerSecret = isset($params['consumerSecret']) ? $params['consumerSecret']:'';
	$userToken = isset($params['userToken']) ? $params['userToken']:'';
	$userSecret = isset($params['userSecret']) ? $params['userSecret']:'';
	$tweetCount = isset($params['tweetCount']) ? $params['tweetCount']:'10';
	$tweetClass = isset($params['tweetClass']) ? $params['tweetClass']:'';
	$showDate = isset($params['showDate']) ? $params['showDate']:'false';
	$dateLast = isset($params['dateLast']) ? $params['dateLast']:'false';
	$dateFormat = isset($params['dateFormat']) ? $params['dateFormat']:'d/m/Y - H:i';
	$tweetDateClass = isset($params['tweetDateClass']) ? $params['tweetDateClass']:'';
	$tweetDatePretty = isset($params['tweetDatePretty']) ? $params['tweetDatePretty']:'';
	$showIcon = isset($params['showIcon']) ? $params['showIcon']:'false';
	$tweetIcon = isset($params['tweetIcon']) ? $params['tweetIcon']:'';
	$tweetIconClass = isset($params['tweetIconClass']) ? $params['tweetIconClass']:'';
	$tweetWrapper = isset($params['tweetWrapper']) ? $params['tweetWrapper']:'';
	
	$tweetfeed = new tweetfeed($twitterAccount, $consumerKey, $consumerSecret, $userToken, $userSecret, $tweetCount, $tweetClass, $showDate, $dateLast, $dateFormat, $tweetDateClass, $tweetDatePretty, $showIcon, $tweetIcon, $tweetIconClass, $tweetWrapper);
	
	if($debug != 'false') {
		$tweetfeed->showDebuginfo();
	}
}


function smarty_cms_help_function_tweetfeed() {
?>
<h3>What does this do?</h3>
<p>This plugin has been updated to use the Twitter v1.1 API and requires the additinal OAuth folder adding to the plugins folder too.</p>
<p>This is a reworking of the Tweets plugin. Display tweets from a specified Twitter account.</p>
<h3>How do I use it?</h3>
<p>Just insert the tag into your template/page like <code>{tweetfeed twitterAccount='cmsms' consumerKey='UYIYUIYIYIU' consumerSecret='FGFGFGFGFFG' userToken='YUYUYUYU' userSecret='HJHJHJHHJ'}</code>.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><tt>twitterAccount='twitter_account_here'</tt> - Name of Twiter account to display feeds from.</li>
<li><tt>consumerKey:</tt>	- Your Consumer Key. View this in your Application under <a href="https://dev.twitter.com/apps/new" target="_blank">https://dev.twitter.com/apps/new</a></li>
<li><tt>consumerSecret:</tt> - Your Consumer Secret. View this in your Application under <a href="https://dev.twitter.com/apps/new" target="_blank">https://dev.twitter.com/apps/new</a></li>
<li><tt>userToken:</tt> - Your Access Token. View this in your Application under <a href="https://dev.twitter.com/apps/new" target="_blank">https://dev.twitter.com/apps/new</a></li>
<li><tt>userSecret:</tt> - Your Access Secret. View this in your Application under <a href="https://dev.twitter.com/apps/new" target="_blank">https://dev.twitter.com/apps/new</a></li>
<li><em>(optional)</em> <tt>tweetCount='10'</tt> - How many tweets to display. Default is 10.</li>
<li><em>(optional)</em> <tt>debug='false'</tt> - Enable debug mode. Default is false.</li>
<li><em>(optional)</em> <tt>tweetClass='twitter_class'</tt> - Specify a class to be added to the UL wrapping the tweets. Default is none.</li>
<li><em>(optional)</em> <tt>showDate='false'</tt> - Show date in feed. Default is false.</li>
<li><em>(optional)</em> <tt>dateLast='false'</tt> - Show date at the end of the feed. Default is false.</li>
<li><em>(optional)</em> <tt>dateFormat='d/m/Y - H:i'</tt> - What format the date should appear as if used. See php date function for possible options <a href="http://www.php.net/manual/function.date.php" target="_blank">date()</a>.</li>
<li><em>(optional)</em> <tt>tweetDateClass='twitter_date_class'</tt> - Specify a class to be added to the span wrapping the date. Default is none.</li>
<li><em>(optional)</em> <tt>tweetDatePretty='true'</tt> - Specify if the date time difference should be shown as text, i.e About 4 days ago. Default is false.</li>
<li><em>(optional)</em> <tt>showIcon='false'</tt> - Show an icon with your tweets. This needs to be used in conjunction with the tweetIcon parameter. Default is none.</li>
<li><em>(optional)</em> <tt>tweetIcon='PATH/TO/ICON'</tt> - If showIcon is set to false you need to specify the icons url with the tweetIcon parameter.</li>
<li><em>(optional)</em> <tt>tweetIconClass='twitter__icon_class'</tt> - Specify a class to be added to the span wrapping the icon. Default is none.</li>
<li><em>(optional)</em> <tt>tweetWrapper='p'</tt> - Specify what html tag you want your Tweets wrapped in, p and ul available. Default is ul.</li>
</ul>
<p>&lt;ul class="twitter_class"&gt;<br />&lt;li&gt;<br />&nbsp;&nbsp;&nbsp;&lt;span class="twitter__icon_class"&gt;tweetIcon&lt;/span&gt;<br />&nbsp;&nbsp;&nbsp;&lt;span class="twitter_date_class"&gt;tweetDate&lt;/span&gt;<br />&nbsp;&nbsp;&nbsp;tweetContent<br />&lt;/li&gt;<br />&lt;/ul&gt;</p>

<?php
}

function smarty_cms_about_function_tweetfeed() {
?>
	<p><strong>Author:</strong> Oliver Seddon <a href=\"mailto:oliver@threefold.co.uk\">oliver@threefold.co.uk</a> Thanks to: Alexandre COURTOIS for the original tweets plugin and Dave Pratt for the v1.1 API update.<br /><br /></p>
    <p>Version 2.2<br /><br /></p>
    <p>Change History:<br />
    1.0 - Alpha version released.<br />
    1.1 - Bug fixes including #8683 where a class would not be attributed to the wrapping UL element.<br />
    2.0 - Updated to work with Twitter API v1.1.<br />
    2.1 - Bug fix #9321 plus others.<br />
    2.2 - Minor bug fixes plus solution for bug #9318.<br />
    2.3 - dateLast and tweetDatePretty params added.<br />
    2.4 - tweetDatePretty param added enabling output like 'About 3 days ago' or 'About 1 hour ago'.</p>
<?php
}
?>