<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgfb_wallpost
{
  private static $_keys = array('to','message','picture','link',
				'name','caption','description','source','icon',
				'actions','privacy','type','place','as_app');
  private $_data = array();

  public function __construct()
  {
    $config = cmsms()->GetConfig();
    $mod = cms_utils::get_module(MOD_CGFBAPP);
    $this->_data['to'] = 'me';

    $icon = $mod->GetPreference('post_icon');
    if( $icon && is_file(cms_join_path($config['uploads_path'],$icon)) ) {
      $icon = $config['uploads_url'].'/'.$icon;
      $this->_data['icon'] = $icon;
    }
    $link = $mod->GetPreference('post_link');
    if( $link ) {
      $this->_data['link'] = $link;
      $this->_data['caption'] = $mod->GetPreference('post_linkcaption');
      $this->_data['description'] = $mod->GetPreference('post_linkdesc');
    }
  }

  public function __get($k)
  {
    if( !in_array($k,self::$_keys) ) throw new Exception('Invalid key '.$k.' for '.__CLASS__);
    if( isset($this->_data[$k]) ) return $this->_data[$k];
  }

  public function __set($k,$v)
  {
    if( !in_array($k,self::$_keys) ) throw new Exception('Invalid key '.$k.' for '.__CLASS__);

    switch( $k ) {
    case 'message':
      $this->_data[$k] = strip_tags($v);
      break;

    default:
      $this->_data[$k] = $v;
      break;
    }
  }

  private function to_array()
  {
    $tmp = $this->_data;
    unset($tmp['to']);
    unset($tmp['as_app']);
    return $this->_data;
  }

  public function send()
  {
    if( $this->to == '' || $this->message == '' ) 
      throw new Exception('Cannot send wallpost, insufficient information');

    $url = "/".$this->to.'/feed';
    if( $this->as_app ) {
      // post it as the app.
      $res = cgfb::app_api($url,'POST',$this->to_array());
    }
    else {
      $res = cgfb::api($url,'POST',$this->to_array());
    }
  }
} // EOF

#
# EOF
#
?>