<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgfb_utils
{
  private function __construct() {}

  public static function find_uid($feu_uid)
  {
    // if FB is setup for secondary authentication
    // the username will be the $feu_uid with a prefix.
    $feu = cms_utils::get_module(MOD_FRONTENDUSERS);
    if( !$feu ) return;

    $username = $feu->GetUsername($feu_uid);
    if( $username && startswith($username,'cgfb_') ) {
      return substr($username,5);
    }

    // otherwise, the fb uid may be in a property.
    $val = $feu->GetPropertyValue('__CGFBApp__');
    if( $val ) return $val;
  }

  public static function get_logout_display($id,$returnid,$params)
  {
    $mod = cms_utils::get_module(MOD_CGFBAPP);
    $smarty = cmsms()->GetSmarty();
    $url = $mod->CreateURL('cntnt01','logoutform',$returnid,array('dologout'=>1));
    $url = str_replace('&amp;','&',$url);
    $smarty->assign('fb_logout_url',cgfb::get_logout_url(array('next'=>$url)));
    $smarty->assign('fb_logout_image',$mod->GetModuleURLPath().'/images/fb_logout.gif');

    $res = $mod->ProcessTemplateFromDatabase('logout_'.$mod->GetPreference(CGFBApp::PREF_LOGOUT_TEMPLATE));
    return $res;
  }

  public static function has_perm($permname)
  {
    $mod = cms_utils::get_module(MOD_CGFBAPP);
    $tmp = $mod->GetPreference('fb_perms');
    if( $tmp ) $tmp = explode(',',$tmp);
    if( in_array($permname,$tmp) ) return TRUE;
    return FALSE;
  }
} // end of class

#
# EOF
#
?>