<?php

class cgfb_feu_consumer extends feu_pure_consumer
{
  private $_dofeuauth = 'unset';

  private function _dofeuauth()
  {
    if( $this->_dofeuauth == 'unset' ) {
      $cgfbapp = cms_utils::get_module(MOD_CGFBAPP);
      $this->_dofeuauth = (int)$cgfbapp->GetPreference('dofeuauth');
    }
    if( !$this->_dofeuauth ) {
      throw new Exception('Not setup to do FEU authentication');
    }
  }

  public function get_capabilities()
  {
    $res = array();
    $res[] = self::CAPABILITY_ALTLOGIN;
    //$res[] = self::CAPABILITY_LOGIN;
    //$res[] = self::CAPABILITY_LOGOUT;
    $res[] = self::CAPABILITY_LISTPROPS;
    $res[] = self::CAPABILITY_EDITPROPS;
    $res[] = self::CAPABILITY_USERNAME;
    //$res[] = self::CAPABILITY_GROUPMEMBERSHIP;
    $res[] = self::CAPABILITY_USESTDCHANGESETTINGS;
    $res[] = self::CAPABILITY_USESTDGROUPS;
    $res[] = self::CAPABILITY_DEFAULTGROUPS;
    return $res;
  }

  public function is_authenticated()
  {
    $this->_dofeuauth();
    $me = cgfb::me();
    $x = cgfb::uid();
    if( $x ) return TRUE;
    return FALSE;
  }

  public function get_login_display($id,$returnid,$params)
  {
    $this->_dofeuauth();
    if( !cgfb::uid() ) {
      $mod = cms_utils::get_module(MOD_CGFBAPP);
      return $mod->DoAction('loginform',$id,$params,$returnid);
    }
  }

  public function get_logout_display($id,$returnid,$params)
  {
    $this->_dofeuauth();
    if( cgfb::uid() ) {
      $mod = cms_utils::get_module(MOD_CGFBAPP);
      return $mod->DoAction('logoutform',$id,$params,$returnid);
    }
    //if( cgfb::uid() ) return cgfb_utils::get_logout_display($id,$returnid,$params);
  }

  public function get_changesettings_display($id,$returnid,$params)
  {
    stack_trace();
    die('not implemented');
  }

  public function get_user_info()
  {
    stack_trace();
    die('not implemented');
  }

  public function get_connecting_property_name()
  {
    $this->_dofeuauth();
    return feu_auth_consumer::PROPERTY_USERNAME;
  }

  public function get_unique_identifier()
  {
    $this->_dofeuauth();
    return cgfb::uid();
  }

  public function get_username($identifier = '')
  {
    if( !$identifier ) $identifier = $this->get_unique_identifier();
    return 'cgfb_'.$identifier;
  }

  public function get_default_groups()
  {
    $mod = cms_utils::get_module(MOD_CGFBAPP);
    $mg = $mod->GetPreference('membergroup');
    if( $mg > 0 ) return array((int)$mg);
  }

  public function get_group_membership($uid)
  {
    $feu = cms_utils::get_module(MOD_FRONTENDUSERS);
    $username = $feu->GetUsername($uid);
    if( !startswith($username,'cgfb_') ) {
      return parent::get_group_membership($uid);
    }

    $ret = array();
    $mod = cms_utils::get_module(MOD_CGFBAPP);
    $n = (int)$mod->GetPreference('membergroup',-1);
    if( $n > 0 ) $ret[] = $n;
    return $ret;
  }
} // end class

?>