<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * A convenience class for interacting wihh facebook
 *
 * @see CGFacebook
 * @author Robert Campbell
 */
class cgfb 
{
  private static $_fb;
  private static $_fbuid;
  private static $_fbme;

  public function __construct() {}

  private static function init()
  {
    if( is_object(self::$_fb) ) return;
    
    $mod = cge_utils::get_module(MOD_CGFBAPP);
    $appid = $mod->GetPreference('fb_appid');
    $appsecret = $mod->GetPreference('fb_appsecret');

    self::$_fb = new CGFacebook(array('appId'=>$appid,'secret'=>$appsecret,'cookie'=>true));
  }


  /**
   * Return the facebook application id
   */
  public static function appid()
  {
    $mod = cge_utils::get_module(MOD_CGFBAPP);
    $appid = $mod->GetPreference('fb_appid');
    return $appid;
  }


  /**
   * Return the currently logged in facebook userid
   */
  public static function uid()
  {
    self::init();

    if( is_null(self::$_fbuid) ) {
      try {
	self::$_fbuid = self::$_fb->getUser();
      }
      catch( FacebookApiException $e ) {
	// nothing here, yet
      }
    }

    return self::$_fbuid;
  }


  /**
   * Get a login url for the facebook user
   * This function accepts a special associative array of parameters
   * scope: comma delimited list of facebook extended permissions.  If not specified, module preferences will be used
   * client_id: The app id.  if not specified, the module preference will be used.
   * redirect_url: the URL to redirect to after login is complete.  If not specified, the current url will be used.
   * extra_params: Extra parameters to add to the redirect url.
   *
   * @params associative array.
   */
  public static function get_login_url($parms = null)
  {
    if( self::uid() ) return;
    $mod = cge_utils::get_module(MOD_CGFBAPP);
    $perms = $mod->GetPreference('fb_perms');
    if( !is_array($parms) ) $parms = array();
    if( $perms ) $parms['scope'] = $perms;
    return self::$_fb->getLoginUrl($parms);
  }


  /**
   * Get a logout url for the facebook user
   */
  public static function get_logout_url($params = array())
  {
    if( !self::uid() ) return;
    return self::$_fb->getLogOutUrl($params);
  }


  /**
   * Destroy session information
   */
  public static function destroy_session()
  {
    if( !self::uid() ) return;
    return self::$_fb->destroySession();
  }

  /**
   * Perform a facebook API request using the user access token.
   */
  public static function api($call, $method = 'GET', $params = array())
  {
    if( !self::uid() ) return;
    if( !$call ) return;
    if( !is_string($call) ) return;

    $res = self::$_fb->api($call,$method,$params);
    if( is_array($res) && count(array_keys($res)) == 1 && isset($res['data']) ) {
      $res = $res['data'];
    }
    return $res;
  }


  /**
   * Perform a facebook REST call
   */
  public static function rest($data)
  {
    if( !self::uid() ) return;
    if( !is_array($data) ) return;

    try {
      $res = self::$_fb->api($data);
      return $res;
    }
    catch( FacebookApiException $e ) {
      // nothing here, yet
    }
  }
  
  /**
   * Perform a facebook API request using the application access token.
   */
  public static function app_api($call,$method = 'GET', $params = array())
  {
    if( !$call ) return;
    if( !is_string($call) ) return;
    self::init();

    self::$_fb->enableAppToken();
    $res = self::$_fb->api($call,$method,$params);
    self::$_fb->enableAppToken(FALSE);
    return $res;
  }


  /**
   * Retrieve information about the currently logged in facebook user
   */
  public static function me()
  {
    self::init();

    if( is_null(self::$_fbme) ) self::$_fbme = self::api('/me');
    return self::$_fbme;
  }


  public static function fql($query)
  {
    if( !$query ) return;

    $tmp = array('method'=>'fql.query','query'=>$query);
    $res = self::rest($tmp);
    
    return $res;
  }


  public static function fql_multi(/* variable arguments */)
  {
    // get the args, and check for too many... only 5 queries
    $args = func_get_args();
    if( is_array($args[0]) && count($args) > 1 ) return;
    if( is_array($args[0]) ) {
      $args = $args[0];
    }
    if( count($args) > 5 ) return;

    // okay, maximum of 5 queries.. aint that nice.
    $q = array();
    for( $i = 0; $i < count($args); $i++ ) {
      $q[] = '"'.$k.'":"'.$v.'"';
    }
    $tmp = array('method'=>'fql.multiquery','queries'=>$q);
    $res = self::rest($tmp);

    return $res;
  }

  public static function getExtendedAccessToken()
  {
    self::$_fb->setExtendedAccessToken();
    return self::$_fb->getAccessToken();
  }
} // end of class

#
# EOF
#
?>