<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

////////////////////////////////////////////////////////////
$cgextensions = cms_join_path(cmsms()->config['root_path'],'modules','CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);
////////////////////////////////////////////////////////////

final class CGFBApp extends CGExtensions
{
  const PREF_INVITE_TEMPLATE = 'dflt_invite_template';
  const TPL_SYSDFLT_INVITE = 'sysdflt_invite_template';
  const PREF_LOGIN_TEMPLATE = 'dflt_login_template';
  const TPL_SYSDFLT_LOGIN = 'sysdflt_login_template';
  const PREF_LOGOUT_TEMPLATE = 'dflt_logout_template';
  const TPL_SYSDFLT_LOGOUT = 'sysdflt_logout_template';
  const FEU_ACCESSKEY_PROPNAME = '__CGFBApp__';

  function InitializeFrontend()
  {
    cgfb_smarty::init();
    cgfb_og_smarty::init();
    cgfbuserdata::init();

    $this->SetParameterType('dologout',CLEAN_INT);
  }

  function GetName() { return get_class($this); }
  function GetFriendlyName() { return $this->Lang('friendlyname'); }
  function GetVersion() { return '1.0.9'; }
  function GetHelp() { return @file_get_contents(__DIR__.'/help.inc'); }
  function GetAuthor() { return 'calguy1000'; }
  function GetAuthorEmail() { return 'calguy1000@cmsmadesimple.org'; }
  function GetChangeLog() { return @file_get_contents(dirname(__FILE__).'/changelog.inc'); }
  function IsPluginModule() { return true; }
  function HasAdmin() { return true; }
  function LazyLoadAdmin() { return TRUE; }
  function GetAdminSection() { return 'extensions'; }
  function GetAdminDescription() { return $this->Lang('moddescription'); }
  function VisibleToAdminUser() { return $this->CheckPermission('Modify Site Preferences') || $this->CheckPermission('Modify Templates'); }
  function GetDependencies() { return array('CGExtensions'=>'1.37.2'); }
  function MinimumCMSVersion() { return '1.11.7'; }
  function InstallPostMessage() { return $this->Lang('postinstall'); }
  function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  function UninstallPreMessage() { return $this->Lang('preuninstall'); }
  function AllowAutoInstall() { return FALSE; }
  function AllowAutoUpgrade() { return FALSE; }
  public function GetFEUAuthConsumer() { return new cgfb_feu_consumer; }

  public function HasCapability($capability, $params = array())
  {
    if( $capability == 'cg_messaging_client' ) return TRUE;
    return FALSE;
  }

  function get_transport_name() { return 'Facebook Status'; }

  public function get_user_key($uid)
  {
    $feu = cms_utils::get_module(MOD_FRONTENDUSERS);
    if( !is_object($feu) ) throw new CmsException('Could not get FEU module to set cgtweet user key');
    if( $uid < 1 ) throw new CmsInvalidDataException('Invalid User ID '.$uid);
    $data = $feu->GetUserProperty(CGFBApp::FEU_ACCESSKEY_PROPNAME);
    if( $data ) return $data;
  }

  public function set_user_key($uid,$auth_token,$auth_secret)
  {
    $feu = cms_utils::get_module(MOD_FRONTENDUSERS);
    if( !is_object($feu) ) throw new CmsException('Could not get FEU module to set cgtweet user key');
    if( $uid < 1 ) throw new CmsInvalidDataException('Invalid User ID '.$uid);
    if( $auth_token == '' || $auth_secret == '' ) throw new CmsInvalidDataException('Invalid authorization data');
    $data = $auth_token;
    debug_to_log('CGFBApp set access token to '.$auth_token);
    $feu->SetUserProperty(CGFBApp::FEU_ACCESSKEY_PROPNAME,$data);
  }

  public function send_message(notification_message $msg)
  {
    if( !$msg->body ) return FALSE;
    if( !$msg->to ) return FALSE;
    if( !cgfb_utils::has_perm('offline_access') ) return TRUE;

    try {
      $post = new cgfb_wallpost;
      $post->as_app = 1; // use the app access token

      if( strlen($msg->to) < 5 && (int)$msg->to > 0 ) {
	// assume it's an FEU uid
	$fb_uid = cgfb_utils::find_uid($msg->to);
	$post->to = $msg->to;
      }
      else {
	// assume it's a FB UID
	$post->to = $msg->to;
      }

      if( $msg->body ) $post->message = $msg->body;
      if( $msg->picture ) $post->picture = $msg->picture;
      if( $msg->link ) {
	$post->link = $msg->link;
	$post->caption = '';
	$post->description = '';
      }

      $res = $post->send();
      return $res;
    }
    catch( Exception $e ) {
      audit('',$this->GetName(),'Facebook notification message to '.$post->to.' failed '.$e->GetMessage());
      return FALSE;
    }
  }

} // class

?>