<?php

class notification_message 
{
  const PRIORITY_HIGH = 1;
  const PRIORITY_NORMAL = 2;
  const PRIORITY_LOW = 3;

  private static $_keys = array('subject','body','priority',
				'originator','sender','lat','long');
  private $_data = array();

  public function __get($key)
  {
    $key = strtolower($key);
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to retrieve invalid key from message object');
    }
    if( isset($this->_data[$key]) ) return $this->_data[$key];
  }

  public function __set($key,$value)
  {
    $key = strtolower($key);
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to store invalid data into message object');
    }
    $this->_data[$key] = $value;
  }

  public function validate()
  {
    // sendto can be empty (indicating use default module profile)
    //  otherwise, must be an integer FEU uid
    // subject can be empty
    // lat/long are optional

    if( $this->body == '' ) {
      throw new Exception('Invalid notification message: empty body');
    }
    if( $this->originator == '' ) {
      throw new Exception('Invalid notification message: empty originator');
      // must match a module name or  'core'
    }
    if( $this->priority > self::PRIORITY_LOW || $this->priority < self::PRIORITY_HIGH ) {
      throw new Exception('Invalid notification message: invalid priority');
    }
  }
} // end of class
