<?php

class cgtweet_utils
{
  private function __construct() {}

  public static function &get_default_credentials()
  {
    $mod = cms_utils::get_module('CGTweet');
    $creds = new cgtweet_credentials;
    $creds->consumer_key = self::decrypt($mod->GetPreference('consumer_key'));
    $creds->consumer_secret = self::decrypt($mod->GetPreference('consumer_secret'));
    $creds->user_key = self::decrypt($mod->GetPreference('access_token'));
    $creds->user_secret = self::decrypt($mod->GetPreference('access_token_secret'));

    if( !$creds->is_valid() ) throw new CmsInvalidDataException($mod->Lang('error_accesstokens'));
    return $creds;
  }

  public static function get(cgtweet_credentials& $data_obj,$cmd,$params = array())
  {
    if( !$data_obj->is_valid() ) {
      $mod = cms_utils::get_moduel(MOD_CGTWEET);
      throw new CmsInvalidDataException($mod->Lang('error_credentials2'));
    }

    require_once(dirname(__FILE__).'/twitteroauth/twitteroauth.php');
    $connection = new TwitterOauth($data_obj->consumer_key,$data_obj->consumer_secret,
				   $data_obj->user_key,$data_obj->user_secret);
    $res =  $connection->get($cmd,$params);
    if( is_object($res) && isset($res->error) ) {
      throw new CmsException($res->error);
    }
    return $res;
  }

  public static function post(cgtweet_credentials& $data_obj,$cmd,$params = array())
  {
    $mod = cms_utils::get_module(MOD_CGTWEET);
    if( !$data_obj->is_valid() ) throw new CmsException($mod->Lang('error_credentials2'));

    require_once(dirname(__FILE__).'/twitteroauth/twitteroauth.php');
    $connection = new TwitterOauth($data_obj->consumer_key,$data_obj->consumer_secret,
				   $data_obj->user_key,$data_obj->user_secret);
    $res = $connection->post($cmd,$params);
    if( is_object($res) && isset($res->errors) ) {
      foreach( $res->errors as $error ) {
	throw new CmsException($error->message);
      }
    }
    return $res;
  }

  private static function _get_encryption_key()
  {
    $mod = cms_utils::get_module('CGTweet');
    $key = $mod->GetPreference('encryption_key');
    if( !$key ) {
      $config = cms_utils::get_config();
      $str = $config['root_url'].$config['root_path'].time();
      $key = md5(str_shuffle($str));
      $mod->SetPreference('encryption_key',$key);
    }
    return $key;
  }

  public static function encrypt($str)
  {
    if( !$str ) return;
    $key = self::_get_encryption_key();
    $ret = base64_encode(cge_encrypt::encrypt($key,$str));
    return $ret;
  }

  public static function decrypt($str)
  {
    if( !$str ) return;
    $key = self::_get_encryption_key();
    $ret = rtrim(cge_encrypt::decrypt($key,base64_decode($str)));
    return $ret;
  }

  public static function tweet_to_html($text,$blanktarget = FALSE)
  {
    $target = '';
    if( $blanktarget ) $target=' target="blank"';

    $text = htmlspecialchars($text);
    $text = preg_replace('%(http://([a-z0-9_.+&!#~/,\-]+))%i','<a href="http://$2"'.$target.'>$1</a>',$text);
    $text = preg_replace('/@([a-z0-9_]+)/i','<a href="http://twitter.com/$1"'.$target.'>@$1</a>',$text);
    return $text;
  }

  public static function html_to_tweet($html,$shorten_urls = TRUE)
  {
    $text = strip_tags($html);

    if( $shorten_urls ) {
      $fn = function($matches) {
	$tmp = ModuleOperations::get_modules_with_capability('shorten_url');
	foreach( $tmp as $name ) {
	  $mod = cms_utils::get_module($name);
	  if( !$mod ) continue;
	  $a = $mod->shorten_url($matches[0]);
	  return $a;
	}
	return $matches[0];
      };

      $regex ='@((https?://)([-\w]+\.[-\w\.]+)+\w(:\d+)?(/([-\w/_\.\,]*(\?\S+)?)?)*)@';
      $text = preg_replace_callback($regex,$fn,$text);
    }
    $text = substr($text,0,140);
    return $text;
  }
} // end of class

#
# EOF
#
?>
