<?php

class cgtweet_credentials
{
  private static $_keys = array('consumer_key','consumer_secret','user_key','user_secret');
  private $_data = array();

  public function __get($key)
  {
    if( !in_array($key,self::$_keys) ) throw new Exception('Get invalid key in cgtweet_credentials_object');
    if( isset($this->_data[$key]) ) {
      return $this->_data[$key];
    }
  }

  public function __set($key,$value)
  {
    if( !is_string($value) ) throw new Exception('Invalid value in cgtweet_credentials object for '.$key);
    if( !in_array($key,self::$_keys) ) throw new Exception('Set invalid key in cgtweet_credentials_object');

    $this->_data[$key] = $value;
  }

  public function is_valid()
  {
    foreach( self::$_keys as $k ) {
      if( !isset($this->_data[$k]) || $this->_data[$k] == '' ) return FALSE;
    }
    return TRUE;
  }
} // end of class

#
# EOF
#
?>