<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGTweet (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow interacting with twitter.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

try {
  $cache = 3600;
  $parms = array('count'=>20,'include_entities'=>false,'exclude_replies'=>false,
		 'exclude_rts'=>false);
  foreach( $params as $key => $val ) {
    switch( $key ) {
    case 'count':
      $parms['count'] = (int)$val;
      break;

    case 'cache':
      $cache = min(3600*12,max(30,$val));
      break;

    case 'deep':
      if( $val ) {
	$parms['include_entities'] = true;
      }
      else {
	$parms['include_entities'] = false;
      }
      break;

    case 'noreplies':
      if( $val ) {
	$parms['exclude_replies'] = true;
      }
      else {
	$parms['exclude_replies'] = false;
      }
      break;

    case 'retweets':
      if( $val ) {
	$parms['exclude_rts'] = false;
      }
      else {
	$parms['exclude_rts'] = true;
      }
      break;
    }
  }

  $signature = 'm'.md5('statuses/home_timeline'.serialize($parms));
  $handler = new cge_smartcache_handler(array('lifetime'=>$cache,'group'=>$this->GetName()));
  $data = '';
  if( $handler->exists($signature) ) $data = $handler->get($signature);
  if( !$data ) {
    $creds = cgtweet_utils::get_default_credentials();
    $data = cgtweet_utils::get($creds,'statuses/home_timeline',$parms);
    if( is_array($data) && count($data) > 0 ) {
      // now translate the data
      for( $i = 0; $i < count($data); $i++ ) {
	$data[$i]->html = cgtweet_utils::tweet_to_html($data[$i]->text);
      }
      $handler->set($signature,$data);
    }
  }

  $smarty->assign('timeline',$data);

  $thetemplate = $this->GetPreference(CGTWEET_TIMELINE_DFLTNAME);
  if( isset($params['timelinetemplate']) ) {
    $thetemplate = trim($params['timelinetemplate']);
  }
  echo $this->ProcessTemplateFromDatabase('timeline_'.$thetemplate);
  // now we're gonna display something

}
catch( Exception $e ) {
  debug_display($e->GetMessage());
  return; // do nothing
}
// params: cache, count, deep
#
# EOF
#
?>