<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGTweet (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow interacting with twitter.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$inline = 0;
$authstep = 1;
$feu = cms_utils::get_module('FrontEndUsers');
$uid = $feu->LoggedInId();
if( $uid <= 0 ) {
  // user is not logged in ... nothing we can do.
  audit('',$this->GetName(),'authorize action on page '.$returnid.': user not logged in');
  return;
}
$feu->SetEncryptionKey($uid);
if( isset($params['authstep']) ) {
  $authstep = (int)$params['authstep'];
}
if( isset($params['inline']) ) {
  $inline = (int)$inline;
}
$consumer_key = cgtweet_utils::decrypt($this->GetPreference('consumer_key'));
$consumer_secret = cgtweet_utils::decrypt($this->GetPreference('consumer_secret'));
if( $consumer_key == '' || $consumer_secret == '' ) {
  audit('',$this->GetName(),'authorize action on page '.$returnid.': consumer key and secret not set');
  return;
}

$smarty->assign('authstep',$authstep);
switch( $authstep ) {
 case 1:
   {
     $prop = null;
     $rawprop = $feu->GetUserProperty('__'.$this->GetName().'__');
     if( $rawprop ) {
       $rawprop = cgtweet_utils::decrypt($rawprop);
       $prop = unserialize($rawprop);
       if( !is_array($prop) 
	   || !isset($prop['oauth_token']) 
	   || !isset($prop['oauth_token_secret']) ) {
	 $prop = null;
       }
     }

     if( !$prop ) {
       // we have no auth info ... 
       $parms = $params;
       $parms['authstep'] = 2;
       $url = $this->create_url($id,'authorize',$returnid,$parms,$inline);
       $smarty->assign('url_authorize',$url);
     }
     else {
       if( isset($prop['screen_name']) ) {
	 $smarty->assign('screen_name',$prop['screen_name']);
       }
       $smarty->assign('message',$this->Lang('msg_auth_known'));
     }
   }
   break;

 case 2:
   {
     // redirect to twitter for authorization.
     require_once(dirname(__FILE__).'/lib/twitteroauth/twitteroauth.php');
     $connection = new TwitterOAuth($consumer_key,$consumer_secret);
     $parms = $params;
     $parms['authstep'] = 3;
     $url = $this->create_url($id,'authorize',$returnid,$parms,$inline);
     $url = str_replace('&amp;','&',$url);
     $request_token = $connection->getRequestToken($url);
     if( is_array($request_token) ) {
       $sess = new cge_session($this->GetName());
       $token = $request_token['oauth_token'];
       $sess->put('request_token',$request_token);
     }

     switch($connection->http_code) {
     case 200:
       $url = $connection->getAuthorizeURL($token);
       redirect($url);
       break;

     default:
       $smarty->assign('error',$this->Lang('error_connect'));
       break;
     }
   }
   break;

 case 3:
   // back from twitter.
   require_once(dirname(__FILE__).'/lib/twitteroauth/twitteroauth.php');
   $sess = new cge_session($this->GetName());
   $request_token = $sess->get('request_token');
   $sess->clear();
   if( !is_array($request_token) ) {
     $smarty->assign('error',$this->Lang('error_oldtoken'));
   }
   else if( isset($_REQUEST['oauth_token']) && 
	    $_REQUEST['oauth_token'] != $request_token['oauth_token'] ) {
     $smarty->assign('error',$this->Lang('error_oldtoken'));
   }
   else {
     $connection = new TwitterOAuth($consumer_key,$consumer_secret,
				    $request_token['oauth_token'],
				    $request_token['oauth_token_secret']);
     $access_token = $connection->getAccessToken();
     if( $connection->http_code == 200 ) {
       $data = cgtweet_utils::encrypt(serialize($access_token));
       $feu->SetUserPropertyFull('__'.$this->GetName().'__',$data,$uid);
       $smarty->assign('message',$this->Lang('msg_auth_success'));
     }
     else {
       $smarty->assign('error',$this->Lang('error_accesstokens'));
     }
   }
   break;
 } // switch

$thetemplate = $this->GetPreference(CGTWEET_AUTHTEMPLATE_DFLTNAME);
if( isset($params['authtemplate']) ) {
  $thetemplate = trim($params['authtemplate']);
}
echo $this->ProcessTemplateFromDatabase('auth_'.$thetemplate);

#
# EOF
#
?>