<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSendTwitter (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow conversion of postal codes
#  from the geoname service.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

require_once(dirname(__FILE__).'/lib/twitteroauth/twitteroauth.php');

$this->SetCurrentTab('settings');

$consumer_key = cgtweet_utils::decrypt($this->GetPreference('consumer_key'));
$consumer_secret = cgtweet_utils::decrypt($this->GetPreference('consumer_secret'));
if( $consumer_key == '' || $consumer_secret == '' ) {
  $this->SetCurrentTab('settings');
  $this->SetError($this->Lang('error_consumer_settings'));
  $this->RedirectToTab($id);
}

$sess = new cge_session($this->GetName());
if( isset($_REQUEST['oauth_token']) && $sess->get('oauth_token') !== $_REQUEST['oauth_token'] ) {
  $sess->clear();
  $this->SetCurrentTab('settings');
  $this->SetError($this->Lang('error_oldtoken'));
  $this->RedirectToTab($id);
}

$connection = new TwitterOAuth($consumer_key,$consumer_secret,
			       $sess->get('oauth_token'),
			       $sess->get('oauth_token_secret'));
$access_token = $connection->getAccessToken($_REQUEST['oauth_verifier']);
$sess->clear();

if( $connection->http_code == 200 ) {
  // save the access token to the module prefs.
  $this->SetPreference('access_token',cgtweet_utils::encrypt($access_token['oauth_token']));
  $this->SetPreference('access_token_secret',cgtweet_utils::encrypt($access_token['oauth_token_secret']));
  $this->SetMessage($this->Lang('msg_accesstokens_good'));
}
else {
  $this->SetError($this->Lang('error_accesstokens'));
}
$this->RedirectToTab($id);


#
# EOF
#
?>