<?php
if (!isset($gCms)) exit;

$db = $gCms->GetDb();
$prfx = cms_db_prefix();

$dict = NewDataDictionary( $db );

#Create Tables
$table_name = "{$prfx}module_sections";
$fields = "id                   I NOTNULL KEY AUTO,
           group_id             I,
           internal_name        C(250) NOTNULL,
           name                 C(250),
           no_wysiwyg           C(1) NOTNULL,
           description          X,
           restriction_mode     C(1) NONULL,
           content              X,            
           from_date            D,
           to_date              D,
           active               C(1) NOTNULL DEFAULT 1,
           creation_date        DT,
           last_modified        DT";
			
$sqlarray = $dict->CreateTableSQL( $table_name, $fields, $table_options);
$dict->ExecuteSQLArray($sqlarray);

/* -------------- */
$table_name = "{$prfx}module_sections_pages";
$fields = "section_id           I NOTNULL,
           page_id              I NOTNULL";

$sqlarray = $dict->CreateTableSQL( $table_name, $fields, $table_options);
$dict->ExecuteSQLArray($sqlarray);
/* -------------- */
/*
$table_name = "{$prfx}module_sections_groups";
$fields = "id           I NOTNULL KEY AUTO,
           group_name   C(250) NOTNULL";

$sqlarray = $dict->CreateTableSQL( $table_name, $fields, $table_options);
$dict->ExecuteSQLArray($sqlarray);
*/
/* -------------- */

#Create Indexes
$sqlarray = $dict->CreateIndexSQL("{$prfx}from_date", "{$prfx}module_sections", 'from_date');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}to_date", "{$prfx}module_sections", 'to_date');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}creation_date", "{$prfx}module_sections", 'creation_date');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}last_modified", "{$prfx}module_sections", 'last_modified');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}section_id", "{$prfx}module_sections_pages", 'section_id');
$dict->ExecuteSQLArray($sqlarray);

$sqlarray = $dict->CreateIndexSQL("{$prfx}page_id", "{$prfx}module_sections_pages", 'page_id');
$dict->ExecuteSQLArray($sqlarray);

#Permissions
$this->CreatePermission('Show Sections Module', $this->Lang('PermissionShowSectionsModule'));

#Events Handler
$this->AddEventHandler( 'Core', 'ContentDeletePre', false);

// put mention into the admin log
$this->Audit( 0, 
	      $this->Lang('friendlyname'), 
	      $this->Lang('installed', $this->GetVersion()) );

	      
?>