<?php
class Sections extends CMSModule
{
  function GetName()
  {
    return 'Sections';
  }
  
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }
  
  function GetVersion()
  {
    return '1.0.0';
  }  
  
  function GetHelp()
  {
    return $this->Lang('help');
  }
  
  function GetAuthor()
  {
    return 'Mikhail Sazonov';
  }
  
  function GetAuthorEmail()
  {
    return 'wursta@gmail.com';
  }
  
  function GetChangeLog()
  {
    return file_get_contents(dirname(__FILE__).'/changelog.inc');
  }
  
  function IsPluginModule()
  {
    return true;
  }
  
  function HasAdmin()
  {
    return true;
  }
  
  function GetAdminSection()
  {
    return 'content';
  }
  
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }
  
  function VisibleToAdminUser()
  {    
    return $this->CheckPermission('Show Sections Module');
  }
  
  function GetDashboardOutput() 
  {        
    return '';
  }
  
  function GetNotificationOutput($priority=2) 
  {       
    /*  
    if ($priority < 4)
      {
        $ret = new stdClass;
        $ret->priority = 2;
        $ret->html= "Notification";
        return $ret;
      }
    */
    return '';
  }
  
  function GetDependencies()
  {
    return array();
  }
  
  function MinimumCMSVersion()
  {
    return "1.11.7";
  }
  
  function MaximumCMSVersion()
  {
    return "1.11.7";
  }
  
  function SetParameters()
  {
    $this->RegisterModulePlugin();
    
    $this->RestrictUnknownParams();
    
    $this->CreateParameter('name', 'internal_name', $this->Lang('ParamHelpName'), false);
    $this->SetParameterType('name',CLEAN_STRING);
    
    $this->CreateParameter('format', 'default', $this->Lang('ParamHelpFormat'), true);
    $this->SetParameterType('format',CLEAN_STRING);
  }
  
  function GetEventDescription ( $eventname )
  {
    return $this->Lang('EventInfo_'.$eventname );
  }
  
  function GetEventHelp ( $eventname )
  {
    return $this->Lang('EventHelp_'.$eventname );
  }
  
  function DoEvent( $originator, $eventname, &$params )
  {
    if ($originator == 'Core' && $eventname == 'ContentDeletePre')
    {                  
      $db = $this->GetDb();
      $prfx = cms_db_prefix();
      
      $content_obj = $params["content"];      
      $content_id = $content_obj->Id();
      
      $page_id = $db->qstr($content_id);
      $query = "DELETE FROM {$prfx}module_sections_pages WHERE page_id = $page_id";
      
      $db->Execute($query);
    }
  }
  
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }
  
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }
  
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }
  
  function DoAction($action, $id, &$params, $returnid=-1)
  {
    global $smarty;
    global $db;
    global $gCms;
    $admintheme = &$gCms->variables['admintheme'];
    
    #Common vars
    $smarty->assign('startTabHeaders', $this->StartTabHeaders());
    $smarty->assign('endTabHeaders', $this->EndTabHeaders());                
    $smarty->assign('startTabContent', $this->StartTabContent());
    $smarty->assign('endTabContent', $this->EndTabContent());
    $smarty->assign('endTab', $this->EndTab());    
    $smarty->assign('SectionName', $this->Lang('Name'));    
    $smarty->assign('SectionContent', $this->Lang('Content'));    
    $smarty->assign('SectionDescription', $this->Lang('Description'));    
    $smarty->assign('SectionInternalName', $this->Lang('InternalName'));    
    $smarty->assign('SectionTag', $this->Lang('Placeholder'));    
    $smarty->assign('InternalNameFormat', $this->Lang('InternalNameFormat'));    
    $smarty->assign('SectionPages', $this->Lang('Pages'));            
    $smarty->assign('DisplayConditions', $this->Lang('DisplayConditions'));            
    $smarty->assign('FromDate', $this->Lang('FromDate'));            
    $smarty->assign('ToDate', $this->Lang('ToDate'));            
    $smarty->assign('Active', $this->Lang('IsActive'));            
    
    //datepicker texts
    $smarty->assign('Previous', $this->Lang('Previous'));        
    $smarty->assign('Next', $this->Lang('Next'));        
    $smarty->assign('January', $this->Lang('January'));        
    $smarty->assign('February', $this->Lang('February'));        
    $smarty->assign('March', $this->Lang('March'));        
    $smarty->assign('April', $this->Lang('April'));        
    $smarty->assign('May', $this->Lang('May'));        
    $smarty->assign('June', $this->Lang('June'));        
    $smarty->assign('July', $this->Lang('July'));        
    $smarty->assign('August', $this->Lang('August'));        
    $smarty->assign('September', $this->Lang('September'));        
    $smarty->assign('October', $this->Lang('October'));        
    $smarty->assign('November', $this->Lang('November'));        
    $smarty->assign('December', $this->Lang('December'));        
    $smarty->assign('JanuaryMin', $this->Lang('JanuaryMin'));        
    $smarty->assign('FebruaryMin', $this->Lang('FebruaryMin'));        
    $smarty->assign('MarchMin', $this->Lang('MarchMin'));        
    $smarty->assign('AprilMin', $this->Lang('AprilMin'));        
    $smarty->assign('MayMin', $this->Lang('MayMin'));        
    $smarty->assign('JuneMin', $this->Lang('JuneMin'));        
    $smarty->assign('JulyMin', $this->Lang('JulyMin'));        
    $smarty->assign('AugustMin', $this->Lang('AugustMin'));        
    $smarty->assign('SeptemberMin', $this->Lang('SeptemberMin'));        
    $smarty->assign('OctoberMin', $this->Lang('OctoberMin'));        
    $smarty->assign('NovemberMin', $this->Lang('NovemberMin'));        
    $smarty->assign('DecemberMin', $this->Lang('DecemberMin'));        
    $smarty->assign('Monday', $this->Lang('Monday'));        
    $smarty->assign('Tuesday', $this->Lang('Tuesday'));        
    $smarty->assign('Wednesday', $this->Lang('Wednesday'));        
    $smarty->assign('Thursday', $this->Lang('Thursday'));        
    $smarty->assign('Friday', $this->Lang('Friday'));        
    $smarty->assign('Saturday', $this->Lang('Saturday'));        
    $smarty->assign('Sunday', $this->Lang('Sunday'));        
    $smarty->assign('MondayMin', $this->Lang('MondayMin'));        
    $smarty->assign('TuesdayMin', $this->Lang('TuesdayMin'));        
    $smarty->assign('WednesdayMin', $this->Lang('WednesdayMin'));        
    $smarty->assign('ThursdayMin', $this->Lang('ThursdayMin'));        
    $smarty->assign('FridayMin', $this->Lang('FridayMin'));        
    $smarty->assign('SaturdayMin', $this->Lang('SaturdayMin'));        
    $smarty->assign('SundayMin', $this->Lang('SundayMin'));            
    
    switch ($action) 
    {
      case 'default':
      {                      
        $cache_id = '|ns'.md5(serialize($params));
        $complile_id = '';
        
        if(!$smarty->isCached($this->GetFileResource($action.".tpl"), $cache_id, $compile_id)) 
        {
          $contentops = $gCms->GetContentOperations();
          $content_obj = $contentops->getContentObject();
                          
          $page_id = $content_obj->Id();
          
          #check section display conditions
          if($this->checkDisplayConditions($params["name"], $page_id))
            $section_data = $this->fetchSectionFrontendData($params["name"]);
          else
            $section_data = '';
          /*
          if(preg_match("/{Sections name=[\"|']?([a-z0-9_]+)[\"|']?}/", $section_data, $matches) != 0)
          {
            $this->ProcessSec($matches[1], $page_id, $section_data);
          }
          */
          if(!empty($params["format"]) && strtolower($params["format"]) == 'json')          
            $section_data = json_encode(array("content" => $section_data));                                
          
          $smarty->assign("sec_content", $section_data);
        }
        
        $this->DeleteTemplate($action.".tpl");
        $this->SetTemplate($action.".tpl", $section_data);
    
        echo $this->ProcessTemplateFromDatabase($action.".tpl");        
        break;
      }
      case 'defaultadmin':
      {                                                
        if(!empty($params["act"]) && $params["act"] == "delete" && !empty($params["sec_id"]))
        {
          $this->DeleteSection($params["sec_id"]);          
        }
        
        if(!empty($params["act"]) && $params["act"] == "set_active" && !empty($params["sec_id"]))
        {
          $this->SetActive($params["sec_id"]);
        }
        
        if(!empty($params["act"]) && $params["act"] == "set_inactive" && !empty($params["sec_id"]))
        {
          $this->SetInactive($params["sec_id"]);
        }
        
        $active_tab = 'sections';
        
        if(isset($params['active_tab']))
          $active_tab = $params['active_tab'];                
        
        $page = 1;
        if(!empty($params["page"]))
          $page = $params["page"];
        $sections_list = $this->fetchSectionsList($page);
        
        $totalSections = $this->GetSectionsCount();                
        
        $smarty->assign('pagination', "<p class=\"pageshowrows\">".$this->Pagination($id, $reutrnid, $page, $totalSections, 20)."</p>");
        $smarty->assign('SectionsListTabHeader', $this->SetTabHeader('sections_list', $this->Lang('SectionsList'), ($active_tab == 'sections') ? true : false));
        $smarty->assign('SettingsTabHeader', $this->SetTabHeader('settings', $this->Lang('Settings'), ($active_tab == 'settings') ? true : false));
        
        $smarty->assign('StartSectionsListTabContent', $this->StartTab('sections_list', $params));
        $smarty->assign('addSectionButton', $this->CreateLink($id, 'edit_section', $returnid, $admintheme->DisplayImage('icons/system/newobject.gif', $this->Lang('AddSection'), '', '', 'systemicon').' '.$this->Lang('AddSection')));                        
        $smarty->assign('trueIcon', $admintheme->DisplayImage('icons/system/true.gif', $this->Lang('SetInactive'), '', '', 'systemicon'));
        $smarty->assign('falseIcon', $admintheme->DisplayImage('icons/system/false.gif', $this->Lang('SetActive'), '', '', 'systemicon'));
        $smarty->assign('editIcon', $admintheme->DisplayImage('icons/system/edit.gif', $this->Lang('EditSection'), '', '', 'systemicon'));
        $smarty->assign('deleteIcon', $admintheme->DisplayImage('icons/system/delete.gif', $this->Lang('DeleteSection'), '', '', 'systemicon'));
        
        $smarty->assign('ShowOn', $this->Lang('ShowOn'));            
        $smarty->assign('NotToShowOn', $this->Lang('NotToShowOn'));            
        
        foreach($sections_list as &$section)
        {          
          $section["edit_link"] = $this->CreateLink($id, 'edit_section', $return_id, 'Edit', array("sec_id" => $section["id"]), '', true);
          $section["delete_link"] = $this->CreateLink($id, 'defaultadmin', $return_id, 'Delete', array("act" => "delete", "sec_id" => $section["id"]), '', true);
          $section["set_active_link"] = $this->CreateLink($id, 'defaultadmin', $return_id, 'Set active', array("act" => "set_active", "sec_id" => $section["id"]), '', true);
          $section["set_inactive_link"] = $this->CreateLink($id, 'defaultadmin', $return_id, 'Set inactive', array("act" => "set_inactive", "sec_id" => $section["id"]), '', true);
        }        
                
        
        $smarty->assign('sections_list', $sections_list);                
        
        echo $smarty->fetch($this->GetFileResource($action.".tpl"));
        break;
      }
      
      case 'edit_section':
      {
        if(!empty($params["sec_id"]))
        {
          $params["section_data"]["sec_id"] = $params["sec_id"];
          $this->fetchSectionData($params["section_data"]["sec_id"], $params["section_data"]);
        }
        
        //process requests
        if(!empty($params["cancel"]))
        {
          $this->Redirect($id, 'defaultadmin', $returnid);
          return true;
        }
        
        if(!empty($params["save"]) || !empty($params["save_exit"]))
        {
          $sec_id = $this->saveSection($params["section_data"], (empty($params["section_data"]["sec_id"])));
          
          if(!empty($params["save_exit"]))
            $this->Redirect($id, 'defaultadmin', $returnid);
          
          if($sec_id !== false)
          {
            $params["section_data"]["sec_id"] = $sec_id;
            $this->ShowMessage($this->Lang("MsgSectionSaved"));            
          }
        }
        
        //init data
        $wysiwyg = (!empty($params["section_data"]["no_wysiwyg"]) && $params["section_data"]["no_wysiwyg"] == 1) ? false : true;        
        
        $skipped_pages = array();
        
        if(!empty($params["section_data"]["selected_pages_list"]))
          $skipped_pages = $params["section_data"]["selected_pages_list"];
        
        $pages_list = $this->fetchPagesList($skipped_pages);
        
        $params["section_data"]["pages_list"] = array();
        foreach($pages_list as $page)
        {
          $params["section_data"]["pages_list"][] = $page["CONTENT_ID"];
        }
        
        //get selected pages info if exists
        if(!empty($params["section_data"]["selected_pages_list"]))        
        {          
          $skipped_pages = $this->fetchPagesList($params["section_data"]["pages_list"]);          
        }
        
        $items = array();
        foreach($pages_list as $value)
        {
          $items[$value["MENU_TEXT"]." (".$value["CONTENT_ALIAS"].")"] = $value["CONTENT_ID"];
        }
        $smarty->assign('pages_list_select', $this->CreateInputDropdown($id, 'section_data[pages_list][]', $items, '', '', 'multiple="multiple" id="all_pages" ondblclick="moveSelectedItems(this.form.elements[\'all_pages\'], this.form.elements[\'selected_pages\']);"'));        
        
        $items = array();
        foreach($skipped_pages as $value)
        {
          $items[$value["MENU_TEXT"]." (".$value["CONTENT_ALIAS"].")"] = $value["CONTENT_ID"];
        }
        $smarty->assign('selected_pages_list_select', $this->CreateInputDropdown($id, 'section_data[selected_pages_list][]', $items, '', '', 'multiple="multiple" id="selected_pages" ondblclick="moveSelectedItems(this.form.elements[\'selected_pages\'], this.form.elements[\'all_pages\']);"'));
        
        $items = array($this->Lang("ShowOnPages") => 'show', $this->Lang("NotToShowOnPages") => 'not_to_show');
        $smarty->assign('restriction_dropdown', $this->CreateInputDropdown($id, "section_data[restriction_mode]", $items, (($params["section_data"]["restriction_mode"] == 'not_to_show') ? 1 : 0)));
        
        $smarty->assign('id', $id);
        $smarty->assign("sec_id", $this->CreateInputHidden($id, "section_data[sec_id]", $params["section_data"]["sec_id"]));
        $smarty->assign('startForm', $this->CreateFormStart($id, 'edit_section', $returnid));
        $smarty->assign('endForm', $this->CreateFormEnd());
        $smarty->assign('SaveButton', $this->CreateInputSubmit($id, 'save', $this->Lang('Save'), 'onclick="select_items_for_submit();"', ''));
        $smarty->assign('SaveAndExitButton', $this->CreateInputSubmit($id, 'save_exit', $this->Lang('SaveAndExit'), 'onclick="select_items_for_submit();"', ''));
        $smarty->assign('CancelButton', $this->CreateInputSubmit($id, 'cancel', $this->Lang("Cancel"), '', '', $this->Lang("ConfirmSectionEditCancel")));
        
        $active_tab = 'properties';
        if(!empty($params["section_data"]["sec_id"]))
          $active_tab = 'content';
        
        $smarty->assign('SectionPropertiesHeader', $this->SetTabHeader('properties', $this->Lang('Properties'), ($active_tab == 'properties') ? true : false));
        $smarty->assign('SectionPagesHeader', $this->SetTabHeader('pages', $this->Lang('DisplayConditions'), false));
        $smarty->assign('SectionContentHeader', $this->SetTabHeader('content', $this->Lang('Content'), ($active_tab == 'content') ? true : false));
        
        $smarty->assign('StartSectionPropertiesTabContent', $this->StartTab('properties', $params));
        $smarty->assign('StartSectionPagesTabContent', $this->StartTab('pages', $params));
        $smarty->assign('StartSectionContentTabContent', $this->StartTab('content', $params));                
        
        $smarty->assign('InternalNameInput', $this->CreateInputText($id, 'section_data[internal_name]', $params["section_data"]["internal_name"], 30));
        
        $smarty->assign('NameInput', $this->CreateInputText($id, 'section_data[name]', $params["section_data"]["name"], 62));
        $smarty->assign('DescriptionInput', $this->CreateTextArea(false, $id, $params["section_data"]["description"], "section_data[description]", "pageextrasmalltextarea"));
        
        $smarty->assign('SectionDateRange', $this->Lang('SectionDateRange'));
        $smarty->assign('fromText', $this->Lang('from'));
        $smarty->assign('toText', $this->Lang('to'));
        
        $smarty->assign('FromDateInput', $this->CreateInputDate($id, 'section_data[from_date]', $params["section_data"]["from_date"]));
        $smarty->assign('ToDateInput', $this->CreateInputDate($id, 'section_data[to_date]', $params["section_data"]["to_date"]));        
        
        $checkbox_selected = (isset($params["section_data"]["active"]) && empty($params["section_data"]["active"])) ? 0 : 1;
        $smarty->assign('SectionActiveCheckbox', $this->CreateInputCheckbox($id, "section_data[active]", "1", $checkbox_selected));
        
        $checkbox_selected = (empty($params["section_data"]["no_wysiwyg"])) ? 0 : 1;
        $smarty->assign('WysiwygCheckbox', $this->CreateInputCheckbox($id, "section_data[no_wysiwyg]", "1", $checkbox_selected, 'id="'.$id.'no_wysiwyg" onchange="toggleWysiwyg();"'));
        
        $smarty->assign('WysiwygCheckboxLabel', $this->CreateLabelForInput($id, "no_wysiwyg", $this->Lang("NoWysiwyg")));
        $smarty->assign('ContentInput', $this->CreateTextArea($wysiwyg, $id, $params["section_data"]["content"], "section_data[content]", "wysiwyg", "wysiwyg", 'utf-8', ''));
        
        $smarty->assign("params", "<pre>".print_r($params, true)."</pre>");
        
        echo $smarty->fetch($this->GetFileResource($action.".tpl"));
        break;
      }
    }            
  }
  
  #Module Functions
  function fetchPagesList($skippedPages)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $query = "SELECT CONTENT_ID, CONTENT_NAME, MENU_TEXT, CONTENT_ALIAS FROM {$prfx}content 
              WHERE TYPE = 'content'
              ORDER BY ITEM_ORDER";    
            
    $result = $db->GetArray($query);
    
    $pages_list = array();
        
    foreach($result as $column_name => $data)
    {                  
      if(in_array($data["CONTENT_ID"], $skippedPages))
        continue;
      
      $pages_list[$data["CONTENT_ID"]] = $data;
    }        
    
    return $pages_list;
  }
  
  function saveSection(&$section_data, $new_section)
  {
    global $gCms;
        
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
                
    #validate data
    if(empty($section_data["internal_name"]))
    {      
      $this->ShowErrors($this->Lang("ErrInternalNameEmpty"));
      return false;
    }
    
    if(!$this->validateInternalName($section_data["internal_name"]))
    {
      $this->ShowErrors($this->Lang("ErrInternalNameInvalid"));
      return false;
    }
    
    if((!empty($section_data["from_date"]) && empty($section_data["to_date"])) ||
        (empty($section_data["from_date"]) && !empty($section_data["to_date"])))
    {
      $this->ShowErrors($this->Lang("ErrWrongDateFormat"));
      return false;
    }
    
    if(!$this->validateDates($section_data["from_date"], $section_data["to_date"]))
    {
      $this->ShowErrors($this->Lang("ErrWrongDateFormat"));
      return false;
    }      
    
    if(strtotime($section_data["from_date"]) >= strtotime($section_data["to_date"]))
    {
      $begin_date = $section_data["to_date"];
      $end_date = $section_data["from_date"];
      
      $section_data["from_date"] = $begin_date;
      $section_data["to_date"] = $end_date;
    }        
    
    #check unique            
    $internal_name = $db->qstr($section_data["internal_name"], get_magic_quotes_gpc());
    
    if($new_section)
      $query = "SELECT COUNT(*) AS CNT FROM {$prfx}module_sections WHERE internal_name = $internal_name";
    else
      $query = "SELECT COUNT(*) AS CNT FROM {$prfx}module_sections WHERE internal_name = $internal_name AND id <> $section_data[sec_id]";
    
    $result = $db->GetArray($query);
    
    if($result[0]["CNT"] != 0)
    {
      $this->ShowErrors($this->Lang("ErrSectionNameExists"));
      return false;
    }
    
    #prepare_data
    $now = date("Y-m-d", time());
        
    $internal_name = $db->qstr($section_data["internal_name"], get_magic_quotes_gpc());
    $from_date = $db->DBDate($section_data["from_date"]);
    $to_date = $db->DBDate($section_data["to_date"]);
    $creation_date = $db->DBDate($now);    
    $last_modified = $db->DBDate($now);
    $name = $db->qstr($section_data["name"], get_magic_quotes_gpc());
    $description = $db->qstr($section_data["description"], get_magic_quotes_gpc());
    $restriction_mode = ($section_data["restriction_mode"] == 'show') ? 0 : 1;
    $no_wysiwyg = (!empty($section_data["no_wysiwyg"])) ? 1 : 0;
    $content = $db->qstr($section_data["content"], get_magic_quotes_gpc());        
    $active = (!empty($section_data["active"])) ? 1 : 0;
    
    #save section data
    if($new_section)
    {
      $query = "INSERT INTO {$prfx}module_sections 
                (internal_name, 
                 name,
                 no_wysiwyg,
                 description,
                 restriction_mode,
                 content,
                 from_date,
                 to_date,
                 active,
                 creation_date,
                 last_modified)
                VALUES
                ($internal_name,
                 $name,
                 $no_wysiwyg,
                 $description,
                 $restriction_mode,
                 $content,
                 $from_date,
                 $to_date,
                 $active,
                 $creation_date,
                 $last_modified
                )";            
    }
    else
    {
      $sec_id = $section_data["sec_id"];
      
      $id = $db->qstr($section_data["sec_id"], get_magic_quotes_gpc());
      $query = "UPDATE {$prfx}module_sections
                SET
                internal_name = $internal_name,
                name = $name,
                no_wysiwyg = $no_wysiwyg,
                description = $description,
                restriction_mode = $restriction_mode,
                content = $content,
                from_date = $from_date,
                to_date = $to_date,
                active = $active,
                last_modified = $last_modified
                WHERE id = $id";
    }
        
    $db->Execute($query);
    
    if($new_section)
      $sec_id = $db->Insert_ID();
    
    #save pages restrictions          
    $id = $db->qstr($sec_id, get_magic_quotes_gpc());
    
    $query = "DELETE FROM {$prfx}module_sections_pages WHERE section_id = $id";
    
    $db->Execute($query);
    
    if(count($section_data["selected_pages_list"]) != 0)
    {
      foreach($section_data["selected_pages_list"] as $page_id)
      {
        $pid = $db->qstr($page_id, get_magic_quotes_gpc());
        
        $query = "INSERT INTO {$prfx}module_sections_pages 
                  (section_id, page_id)
                  VALUES
                  ($id, $pid)";
        
        $db->Execute($query);
      }
    }
    
    if($new_section)
      $text = $this->Lang('AuditSectionAdded', $section_data["internal_name"]);
    else
      $text = $this->Lang('AuditSectionUpdated', $section_data["internal_name"]);
    
    $this->Audit( $sec_id, $this->Lang('friendlyname'), $text );
    
    return $sec_id;
  }
  
  function validateInternalName($str)
  {    
    return (preg_match("/[^a-z0-9_]/i", $str) == 0);
  }
  
  function validateDates($from_date, $to_date)
  {
    $begin_date = $this->isoDate($from_date, "Y-m-d");
    
    if($begin_date == "error")
      return false;
      
    $end_date = $this->isoDate($to_date, "Y-m-d");
    
    if($end_date == "error")
      return false;        
    
    return true;
  }
  
  function isoDate($date, $format, $empty_on_error = false)
  {
    if(empty($date)) return "";

    $err_status = "error";
    if($empty_on_error) $err_status = "";

    $pattern = preg_replace(array("/Y/", "/m/", "/d/", "/H/", "/i/", "/s/"), array("([0-9]{4})", "([0-9]{1,2})", "([0-9]{1,2})", "([0-9]{1,2})", "([0-9]{1,2})", "([0-9]{1,2})"), preg_quote($format));

    $units = array();

    if(!preg_match("/" . $pattern . "/", $date, $units)) return $err_status;
    array_shift($units);    
    
    $order = preg_replace("/[^YmdHis]/", "", $format);

    $date_part = "";
    $result = "";
    $pos_Y = strpos($order, "Y");
    $pos_m = strpos($order, "m");
    $pos_d = strpos($order, "d");
    if(!($pos_Y === false || $pos_m === false || $pos_d === false))
    {
      if(!checkdate($units[$pos_m], $units[$pos_d], $units[$pos_Y])) return $err_status;

      $date_part = $units[$pos_Y] . "-" . $units[$pos_m] . "-" . $units[$pos_d];
    }

    $time_part = "";
    $pos_H = strpos($order, "H");
    $pos_i = strpos($order, "i");
    $pos_s = strpos($order, "s");
    if(!($pos_H === false || $pos_i === false))
    {
      if(!is_numeric($units[$pos_H]) || $units[$pos_H] < 0 || $units[$pos_H] > 23) return $err_status;
      if(!is_numeric($units[$pos_i]) || $units[$pos_i] < 0 || $units[$pos_i] > 59) return $err_status;

      $time_part = $units[$pos_H] . ":" . $units[$pos_i];

      if(!($pos_s === false))
      {
        if(!is_numeric($units[$pos_s]) || $units[$pos_s] < 0 || $units[$pos_s] > 59) return $err_status;
        $time_part .= ":" . $units[$pos_s];
      }
    }

    return trim($date_part . " " . $time_part);
  }
  
  function fetchSectionsList($page = 1)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $sections_list = array();
    
    $rows_num = 20;
    
    $offset = $page*$rows_num - $rows_num;
    
    $query = "SELECT id, internal_name, name, description, content_alias, from_date, to_date, restriction_mode, {$prfx}module_sections.active
              FROM {$prfx}module_sections
              LEFT JOIN {$prfx}module_sections_pages ON (id = section_id)
              LEFT JOIN {$prfx}content ON (content_id = page_id)
              ORDER BY internal_name";         
    
    $dbresult = $db->SelectLimit($query, $rows_num, $offset);
    
    while ($dbresult && $data = $dbresult->FetchRow())
    {
      $sections_list[$data["id"]]["id"] = $data["id"];
      $sections_list[$data["id"]]["internal_name"] = $data["internal_name"];
      $sections_list[$data["id"]]["name"] = $data["name"];
      $sections_list[$data["id"]]["restriction_mode"] = $data["restriction_mode"];
      $sections_list[$data["id"]]["description"] = $data["description"];      
      $sections_list[$data["id"]]["from_date"] = $data["from_date"];      
      $sections_list[$data["id"]]["to_date"] = $data["to_date"];      
      $sections_list[$data["id"]]["active"] = $data["active"];      
      if(!empty($data["content_alias"]))
        $sections_list[$data["id"]]["pages"][] = $data["content_alias"];
    }
        
    return $sections_list;
  }
  
  function fetchSectionData($sec_id, &$section_data)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $id = $db->qstr($sec_id);
    
    $query = "SELECT id, internal_name, name, description, content_id, restriction_mode, from_date, to_date, no_wysiwyg, {$prfx}module_sections.content, {$prfx}module_sections.active
              FROM {$prfx}module_sections
              LEFT JOIN {$prfx}module_sections_pages ON (id = section_id)
              LEFT JOIN {$prfx}content ON (content_id = page_id)
              WHERE id = $id";                  
    
    $result = $db->GetArray($query);
    
    foreach($result as $col_name => $data)
    {      
      $section_data["internal_name"] = $data["internal_name"];
      $section_data["name"] = $data["name"];
      $section_data["description"] = $data["description"];      
      $section_data["no_wysiwyg"] = $data["no_wysiwyg"];      
      $section_data["content"] = $data["content"];      
      $section_data["from_date"] = $data["from_date"];      
      $section_data["to_date"] = $data["to_date"];            
      $section_data["active"] = $data["active"];            
      $section_data["restriction_mode"] = ($data["restriction_mode"] == 0) ? 'show' : 'not_to_show';
      $section_data["selected_pages_list"][] = $data["content_id"];
    }    
  }
  
  function DeleteSection($sec_id)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $id = $db->qstr($sec_id);
    
    $query = "DELETE FROM {$prfx}module_sections WHERE id = $id";
    
    $db->Execute($query);
    
    $query = "DELETE FROM {$prfx}module_sections_pages WHERE section_id = $id";
    
    $db->Execute($query);
    
    $this->ShowMessage($this->Lang("MsgSectionDeleted"));
  }
  
  function fetchSectionFrontendData($internal_name)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $internal_name = $db->qstr($internal_name);
    
    $query = "SELECT content FROM {$prfx}module_sections WHERE internal_name = $internal_name";        
    
    $result = $db->GetArray($query);    
    
    return $result[0]["content"];    
  }
  
  function checkDisplayConditions($name, $page_id)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $sec_name = $db->qstr($name);    
    
    $query = "SELECT restriction_mode, page_id, from_date, to_date, active
              FROM {$prfx}module_sections
              LEFT JOIN {$prfx}module_sections_pages ON (id = section_id)
              WHERE internal_name = $sec_name";
    
    $result = $db->GetArray($query);
        
    if(count($result) != 0)
    {
      $pages = array();      
      foreach($result as $data)
      {
        if(!empty($data["active"]))
          $active = $data["active"];
        if(!empty($data["from_date"]))
          $from_date = strtotime($data["from_date"]);
        if(!empty($data["to_date"]))
          $to_date = strtotime($data["to_date"]);
        $restriction_mode = $data["restriction_mode"];
        if(!empty($data["page_id"]))
          $pages[] = $data["page_id"];
      }
      
      if(!isset($active))
        return false;
      
      if(isset($from_date) && isset($to_date))
      {
        $now = time();      
        if($now < $from_date)
          return false;
        
        if($now > $to_date)
          return false;
      }
      
      if(count($pages) != 0)      
      {
        switch($restriction_mode)
        {
          case 0:
          {
            if(!in_array($page_id, $pages))
              return false;
            
            break;
          }
          
          case 1:
          {
            if(in_array($page_id, $pages))
              return false;
          }
        }
      }
    }
    else
    {
      return false;
    }
    
    return true;        
  }
  
  function GetSectionsCount()
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $query = "SELECT COUNT(*) AS CNT FROM {$prfx}module_sections";
    
    $result = $db->GetArray($query);
    
    return $result[0]["CNT"];
  }
  
  function Pagination($id, $reutrnid, $page, $totalrows, $limit)
  {    
    $link = $this->CreateLink($id, 'defaultadmin', $returnid, '', '', '', true);
    $page_string = "";
    $from = ($page * $limit) - $limit;
    $numofpages = (int)($totalrows / $limit);
    if( ($totalrows % $limit) != 0 ) ++$numofpages;
    if ($numofpages > 1)
    {
      if($page != 1)
      {
        $pageprev = $page-1;
        $page_string .= '<a href="'.$this->CreateLink($id, 'defaultadmin', $returnid, '', array("page" => 1), '', true).'">'.lang('first').'</a>&nbsp;';
        $page_string .= "<a href=\"".$this->CreateLink($id, 'defaultadmin', $returnid, '', array("page" => $pageprev), '', true)."\">".lang('previous')."</a>&nbsp;";
      }
      else
      {
        $page_string .= lang('first')." ";
        $page_string .= lang('previous')." ";
      }

      $page_string .= '&nbsp;'.lang('page')."&nbsp;$page&nbsp;".lang('of')."&nbsp;$numofpages&nbsp;";

      if(($totalrows - ($limit * $page)) > 0)
      {
        $pagenext = $page+1;
        $page_string .= "<a href=\"".$this->CreateLink($id, 'defaultadmin', $returnid, '', array("page" => $pagenext), '', true)."\">".lang('next')."</a>&nbsp;";
        $page_string .= '<a href="'.$this->CreateLink($id, 'defaultadmin', $returnid, '', array("page" => $numofpages), '', true).'">'.lang('last').'</a>';
      }
      else
      {
        $page_string .= lang('next')." ";
        $page_string .= lang('last')." ";
      }
    }
    return $page_string;
  }
  
  function SetActive($sec_id)
  {    
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $id = $db->qstr($sec_id);
    
    $query = "SELECT COUNT(*) AS CNT, internal_name FROM {$prfx}module_sections WHERE id = $id";
    
    $result = $db->GetArray($query);
    
    $count = $result[0]["CNT"];
    $internal_name = $result[0]["internal_name"];
    
    if($count == 0)
      return false;
    
    $query = "UPDATE {$prfx}module_sections SET ACTIVE = 1 WHERE id = $id";
    
    $db->Execute($query);        
    
    $this->Audit( $sec_id, $this->Lang('friendlyname'), $this->Lang('AuditSectionSetActive', $internal_name) );
    
    return true;
  }
  
  function SetInactive($sec_id)
  {
    $db = $this->GetDb();
    $prfx = cms_db_prefix();
    
    $id = $db->qstr($sec_id);
    
    $query = "SELECT COUNT(*) AS CNT, internal_name FROM {$prfx}module_sections WHERE id = $id";
    
    $result = $db->GetArray($query);
    
    $count = $result[0]["CNT"];
    $internal_name = $result[0]["internal_name"];
    
    if($count == 0)
      return false;
    
    $query = "UPDATE {$prfx}module_sections SET ACTIVE = 0 WHERE id = $id";
    
    $db->Execute($query);
    
    $this->Audit( $sec_id, $this->Lang('friendlyname'), $this->Lang('AuditSectionSetInactive', $internal_name) );
    
    return true;
  }
  
  function ProcessSec($sec_name, $page_id, &$section_data)
  {    
    #check section display conditions
    if($this->checkDisplayConditions($sec_name, $page_id))
      $section_data = preg_replace("/{Sections name=[\"|']?{$sec_name}[\"|']?}/", $this->fetchSectionFrontendData($sec_name), $section_data);
    else
      $section_data = preg_replace("/{Sections name=[\"|']?{$sec_name}[\"|']?}/", "", $section_data);
      
    if(preg_match("/{Sections name=[\"|']?([a-z0-9_]+)[\"|']?}/", $section_data, $matches) != 0)
    {
      $this->ProcessSec($matches[1], $page_id, $section_data);
    }             
  }    
}
?>
