<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------


$gbooks = Gbook_utils::GetGbooks('', false);
$gbook_id = empty($params['gbookid']) ? $this->GetPreference('defaultgbook') : $params['gbookid'];

if ( count($gbooks) > 1 )
{
	// create gbook dropdownfield
	foreach ( $gbooks as $gbook ) 
	{
		$label = $gbook['name'] . ' (' . $gbook['entries'] . ')';
		$gbooklist[$label] = $gbook['gbook_id'];
		if ( $gbook_id == $gbook['gbook_id'] ) $entries = $gbook['entries'];
	}
	$smarty->assign('gbookselect', $this->CreateInputDropdown($id, 'gbookselect', $gbooklist, -1, $gbook_id, 'id="' . $id . 'gbookselect"'));
	$smarty->assign('gbookselectjs', '
	<script type="text/javascript">
		$(function() {
			$(\'#' . $id . 'gbookselect\').change( function() {
				location.href = "' . str_replace('&amp;','&',$this->CreateLink($id, 'defaultadmin', $returnid, '', array('active_tab' => 'items'), '', true))  . '&' . $id . 'gbookid="+$(this).val();
			});
		});
	</script>
');
}
else
{
	$smarty->assign('gbookselect', '');
	$smarty->assign('gbookselectjs', '');
	$entries = $gbooks[0]['entries'];
}

// pagination
$params['gbpage'] = empty($params['gbpage']) ? 1 : $params['gbpage'];
$entries_per_page = 40;
$pages = ceil($entries / $entries_per_page);
$start = (($params['gbpage'] - 1) * $entries_per_page) + 1;

$pagelinks = array();
for ($i = 1; $i <= $pages; $i++) {
	$pagelinks[$i] = $this->CreateLink($id, 'defaultadmin', $returnid, '', array ('gbookid' => $gbook_id, 'gbpage' => $i, 'active_tab' => 'items'), '', true);
}
$smarty->assign_by_ref('pagelinks', $pagelinks);
$smarty->assign('currentpage', $params['gbpage']);


$items = Gbook_utils::GetEntries($gbook_id, $start, $entries_per_page, false);
foreach ( $items as $key=>$item )
{
	$spamrate = Gbook_utils::b8_exec('Classify', $item->title . ' ' . $item->rawmessage);
	$items[$key]->spamrate = Gbook_utils::format_rating($spamrate);
}
$smarty->assign_by_ref('items', $items);


$smarty->assign('id', $this->Lang('id'));
$smarty->assign('name', lang('name'));
$smarty->assign('title', lang('title'));
$smarty->assign('content', lang('content'));
//$smarty->assign('ip', lang('ip_addr'));
$smarty->assign('spamrate', $this->Lang('spamrate'));
$smarty->assign('active', lang('active'));
$smarty->assign('create_date', $this->Lang('created'));
$smarty->assign('modified_date', $this->Lang('modified'));
$smarty->assign('expire_date', $this->Lang('expired'));
$smarty->assign('approved_date', $this->Lang('approved'));


$smarty->assign('itemcount', count($items));

$smarty->assign('activefalselink', $this->CreateLink($id, 'edititem', $returnid,
				    $themeObject->DisplayImage('icons/system/true.gif', lang('active'),'','','systemicon'),
				    array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'switchactive')));
$smarty->assign('activetruelink', $this->CreateLink($id, 'edititem', $returnid,
				    $themeObject->DisplayImage('icons/system/false.gif', lang('inactive'),'','','systemicon'),
				    array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'switchactive')));
$smarty->assign('editicon', $themeObject->DisplayImage ('icons/system/edit.gif', lang ('edit'), '', '', 'systemicon'));
$smarty->assign('editurl', $this->CreateLink($id, 'edititem', $returnid,
				    lang ('edit'),
				    array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'edit'), '', true));
$smarty->assign('deletelink', $this->CreateLink($id, 'edititem', $returnid,
					  $themeObject->DisplayImage('icons/system/delete.gif', lang ('delete'), '', '', 'systemicon'),
					  array ('gbookid' => $gbook_id, 'entryid' => 'QQ', 'mode'=>'delete'), $this->Lang ('areyousure')));
/*
$smarty->assign('multiselect', $this->CreateInputCheckbox($id, 'multiselect[QQ]', 1));

$smarty->assign('formstart', $this->CreateFormStart ($id, 'multiaction',$returnid,'post','', false, '', array('gbookid' => $gbook_id)));
$smarty->assign('formend', $this->CreateFormEnd());

$multiactionlist = array(lang('delete') => 'delete', lang('active') => 'active', lang('inactive') => 'inactive');
$smarty->assign('prompt_multiaction', $this->Lang('withselected'));
$smarty->assign('multiaction', $this->CreateInputDropdown($id, 'multiaction', $multiactionlist, -1) . ' ' . $this->CreateInputSubmit($id, 'multiactionsubmit', lang('apply'), '', '', $this->Lang('areyousuremulti')) );

$link = $this->CreateLink($id, 'edititem', 0, $themeObject->DisplayImage('icons/system/newobject.gif', $this->Lang('additem'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'edititem', $returnid, $this->Lang("additem"), array("mode"=>"add"), '', false, false, 'class="pageoptions"');
$smarty->assign('addlink', $link);
*/

// Display the populated template
echo $this->ProcessTemplate('adminitems.tpl');

?>