<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if( !$gCms ) exit();

if ( !$this->CheckPermission('Gbook: Use') )
{
	echo $this->ShowErrors(lang('needpermissionto', 'Gbook: Use'));
	return;
}

if ( isset($params['cancel']) )
{
	$params = array('active_tab' => 'items');
	$this->Redirect($id, 'defaultadmin', '', $params);
}

if( !isset($params['mode']) || !isset($params['gbookid']) )
{
	$params = array('errors' => lang('missingparams'), 'active_tab' => 'items');
	$this->Redirect($id, 'defaultadmin', '', $params);
	return;
}

switch ($params['mode'])
{
	case 'delete':
		$deleted = Gbook_utils::DeleteEntry($params['entryid']);
		$params = $deleted ? array('tab_message'=> 'itemdeleted', 'active_tab' => 'items') : array('errors' => lang('failure'), 'active_tab' => 'items');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'edit':
		if( !isset($params['entryid']) )
		{
			$params = array('gbookid' => $params['gbookid'], 'active_tab' => 'entries', 'errors' => lang('missingparams'));
			$this->Redirect($id, 'defaultadmin', '', $params);
			return;
		}

		if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset($params['submit']) )
		{
			$edited = Gbook_utils::EditEntry($params['entryid'], $params['gbookid'], $params['name'], $params['email'], $params['title'], $params['message'], $params['notify'], $params['active']);
			$params = array('gbookid' => $params['gbookid'], 'active_tab' => 'items');
			if ( $edited )
			{
				$params['tab_message'] = 'itemupdated';
			}
			else
			{
				$params['errors'] = lang('failure');
			}
			$this->Redirect($id, 'defaultadmin', '', $params);
		}
		$smarty->assign('title', $this->Lang('edititem'));
		$item = Gbook_utils::GetEntry($params['entryid']);
		break;

		
	case 'switchactive':
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET active = active^1 WHERE entry_id = ?";
		$db->Execute($query, array($params['entryid']));

		$item = Gbook_utils::GetEntry($params['entryid']);
		$this->SendEvent('Gbook_entry_edited', $item);
				
		//Update search index
		$search = cms_utils::get_module('Search');
		if ( $search != false && $item->active == 1 )
		{
			$search->AddWords($this->GetName(), $params['entryid'], 'entry', $item->title . ' ' . $item->rawmessage);
		}
		elseif ( $search != false )
		{
			$search->DeleteWords($this->GetName(), $params['entryid'], 'entry');
		}

		$params = array('gbookid' => $params['gbookid'], 'active_tab' => 'entries');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;

	
	case 'saveasham':
		$item = Gbook_utils::GetEntry($params['entryid']);
		Gbook_utils::b8_exec('SaveAsHam', $item->title . ' ' . $item->rawmessage);
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET 
								approved = ?,
								approved_date = NOW(),
								approved_by = ?,
								active = ?
							WHERE entry_id = ?";
		$db->Execute($query, array(1, get_userid(), 1, $params['entryid']));

		$this->SendEvent('Gbook_entry_edited', $item);
				
		//Update search index
		$search = cms_utils::get_module('Search');
		if ( $search != false )
		{
			$search->AddWords($this->GetName(), $params['entryid'], 'entry', $item->title . ' ' . $item->rawmessage);
		}

		$params = array('gbookid' => $params['gbookid'], 'active_tab' => 'entries');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'saveasspam':
		$item = Gbook_utils::GetEntry($params['entryid']);
		Gbook_utils::b8_exec('SaveAsSpam', $item->title . ' ' . $item->rawmessage);
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET 
								approved = ?,
								approved_date = NOW(),
								approved_by = ?,
								active = ?
							WHERE entry_id = ?";
		$db->Execute($query, array(2, get_userid(), 0, $params['entryid']));

		$this->SendEvent('Gbook_entry_edited', $item);
				
		//Update search index
		$search = cms_utils::get_module('Search');
		if ( $search != false )
		{
			$search->DeleteWords($this->GetName(), $params['entryid'], 'entry');
		}

		$params = array('gbookid' => $params['gbookid'], 'active_tab' => 'entries');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'deletefromham':
		$item = Gbook_utils::GetEntry($params['entryid']);
		Gbook_utils::b8_exec('DeleteFromHam', $item->title . ' ' . $item->rawmessage);
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET 
								approved = ?,
								approved_date = NOW(),
								approved_by = ?
							WHERE entry_id = ?";
		$db->Execute($query, array(0, get_userid(), $params['entryid']));
		$params = array('gbookid' => $params['gbookid'], 'active_tab' => 'entries');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'deletefromspam':
		$item = Gbook_utils::GetEntry($params['entryid']);
		Gbook_utils::b8_exec('DeleteFromSpam', $item->title . ' ' . $item->rawmessage);
		$query = "UPDATE " . cms_db_prefix() . "module_gbook_entries SET 
								approved = ?,
								approved_date = NOW(),
								approved_by = ?
							WHERE entry_id = ?";
		$db->Execute($query, array(0, get_userid(), $params['entryid']));
		$params = array('gbookid' => $params['gbookid'], 'active_tab' => 'entries');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;



}

if ( !empty($item) )
{
	$smarty->assign('gbook_name_label', $this->Lang('name'));
	$smarty->assign('gbook_name_input', $this->CreateInputText($id, 'name', html_entity_decode($item->name,ENT_QUOTES), 40, 255));

	$smarty->assign('gbook_email_label', $this->Lang('email'));
	$smarty->assign('gbook_email_input', $this->CreateInputText($id, 'email', html_entity_decode($item->email,ENT_QUOTES), 40, 255));

	$smarty->assign('gbook_title_label', $this->Lang('title'));
	$smarty->assign('gbook_title_input', $this->CreateInputText($id, 'title', html_entity_decode($item->title,ENT_QUOTES), 40, 255));

	$smarty->assign('gbook_message_label', $this->Lang('message'));
	$smarty->assign('gbook_message_input', $this->CreateTextArea(false, $id, html_entity_decode($item->rawmessage,ENT_QUOTES), 'message', '', $id . 'message'));

	$spamrate = Gbook_utils::b8_exec('Classify', $item->title . ' ' . $item->rawmessage);
	$smarty->assign('spamrate', $this->Lang('spamrate') . ': ' . Gbook_utils::format_rating($spamrate));
	
	if ( $item->approved == 1 )
	{
		// marked as HAM
		$smarty->assign('approvelink', $this->CreateLink($id, 'edititem', $returnid,
				    '<img src="../modules/Gbook/images/nospam.gif" class="systemicon" alt="' . $this->Lang('deletefromham') . '"> ' . $this->Lang('deletefromham'),
				    array ('gbookid' => $params['gbookid'], 'entryid' => $item->entry_id, 'mode'=>'deletefromham')));
	}
	elseif ( $item->approved == 2 )
	{
		// marked as SPAM
		$smarty->assign('approvelink', $this->CreateLink($id, 'edititem', $returnid,
				    '<img src="../modules/Gbook/images/nospam.gif" class="systemicon" alt="' . $this->Lang('deletefromspam') . '"> ' . $this->Lang('deletefromspam'),
				    array ('gbookid' => $params['gbookid'], 'entryid' => $item->entry_id, 'mode'=>'deletefromspam')));
	}
	else	
	{
		// not approved
		$smarty->assign('approvelink', 
						$this->CreateLink($id, 'edititem', $returnid,
				    '<img src="../modules/Gbook/images/check.png" class="systemicon" alt="' . $this->Lang('saveasham') . '"> ' . $this->Lang('saveasham'),
				    array ('gbookid' => $params['gbookid'], 'entryid' => $item->entry_id, 'mode'=>'saveasham'))
						. ' &nbsp; ' .
						$this->CreateLink($id, 'edititem', $returnid,
				    '<img src="../modules/Gbook/images/nospam.gif" class="systemicon" alt="' . $this->Lang('saveasspam') . '"> ' . $this->Lang('saveasspam'),
				    array ('gbookid' => $params['gbookid'], 'entryid' => $item->entry_id, 'mode'=>'saveasspam'))
					);
	}

	$smarty->assign('submit',$this->CreateInputSubmit ($id, 'submit', lang('submit')));
	//$smarty->assign('apply',$params['mode'] == 'add' ? '' : $this->CreateInputSubmit($id, 'applybutton', $this->Lang('apply')));
	$smarty->assign('cancel',$this->CreateInputSubmit ($id, 'cancel', lang('cancel')));

	$params = array('mode' => 'edit', 'gbookid' => $params['gbookid'], 'entryid' => $item->entry_id, 'notify' => $item->notify, 'active' => $item->active);
	$smarty->assign('formstart', $this->CreateFormStart ($id, 'edititem', $returnid, 'post', '', false, '', $params));
	$smarty->assign('formend',$this->CreateFormEnd());

	echo $this->ProcessTemplate('edititem.tpl');
}


?>