<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

if ( !$this->CheckPermission('Gbook: Use') )
{
	echo $this->ShowErrors(lang('needpermissionto', 'Gbook: Use'));
	return;
}

$themeObject =& $gCms->variables['admintheme'];

$gbooks = Gbook_utils::GetGbooks('', false);
$smarty->assign_by_ref('gbooks', $gbooks);


/*
 * The tab headers
 */
echo $this->StartTabHeaders();
$active_tab = empty($params['active_tab']) ? '' : $params['active_tab'];


echo $this->SetTabHeader('items',$this->Lang('entries'), ($active_tab == 'items')?true:false);



if ( $this->CheckPermission('Gbook: Modify') )
{
	echo $this->SetTabHeader('gbooks',$this->Lang('gbooks'), ($active_tab == 'gbooks')?true:false);
	
	echo $this->SetTabHeader('smileys',$this->Lang('smileys'), ($active_tab == 'smileys')?true:false);
}


if ( $this->CheckPermission('Modify Templates') )
{
	//echo $this->SetTabHeader('fielddefs',$this->Lang('fielddefinitions'), ($active_tab == 'fielddefs')?true:false);

	echo $this->SetTabHeader('templates',lang('templates'), ($active_tab == 'templates')?true:false);
}


if ($this->CheckPermission('Modify Site Preferences'))
{
	echo $this->SetTabHeader('options',lang('options'), ($active_tab == 'options')?true:false);
}
echo $this->EndTabHeaders();


/*
 * The content of the tabs
 */
echo $this->StartTabContent();

echo $this->StartTab('items', $params);
include(dirname(__FILE__).'/function.admin_itemstab.php');
echo $this->EndTab();

if ( $this->CheckPermission('Gbook: Modify') )
{
	echo $this->StartTab('gbooks', $params);
	include(dirname(__FILE__).'/function.admin_gbookstab.php');
	echo $this->EndTab();
	
	echo $this->StartTab('smileys', $params);
	include(dirname(__FILE__).'/function.admin_smileystab.php');
	echo $this->EndTab();
}

if( $this->CheckPermission('Modify Templates') )
{
	//echo $this->StartTab('fielddefs', $params);
	//include(dirname(__FILE__).'/function.admin_fielddefstab.php');
	//echo $this->EndTab();

	echo $this->StartTab('templates', $params);
	include(dirname(__FILE__).'/function.admin_templatestab.php');
	echo $this->EndTab();
}

if ($this->CheckPermission('Modify Site Preferences'))
{
	echo $this->StartTab('options', $params);
	include(dirname(__FILE__).'/function.admin_optionstab.php');
	echo $this->EndTab();
}

echo $this->EndTabContent();


?>