{* display a list of checkins matching some criteria *}
{* NOTE:  This sample template uses FEU fiends entitled avatar, and full_name.  You will need to change this template to match the name of your FEU properties *}

<h3>Recent Checkins</h3>

{if isset($pagination) && $pagination->get_page_count() > 1}{strip}
  {assign var='cur_page' value=$pagination->get_current_page()}
  {if $cur_page > 1}
    <a href="{$pagination->get_firstpage_url()}" title="{$CGSocialApp->Lang('prompt_firstpage')}">&lt;&lt;</a>&nbsp;
    <a href="{$pagination->get_prevpage_url()}" title="{$CGSocialApp->Lang('prompt_prevpage')}">&lt;</a>&nbsp;
  {/if}
  {$CGSocialApp->Lang('prompt_page')}&nbsp;{$cur_page}&nbsp;{$CGSocialApp->Lang('of')}&nbsp;{$pagination->get_page_count()}
  {if $cur_page < $pagination->get_page_count()}
     &nbsp;<a href="{$pagination->get_nextpage_url()}">&gt;</a>
     &nbsp;<a href="{$pagination->get_lastpage_url()}">&gt;&gt;</a>
  {/if}
{/strip}{/if}

{strip}{uploads_url assign='uploads_url'}
<div class="cgsa_checkin_list">
{if isset($checkins)}
  {foreach from=$checkins item='cgsa_entry'}
    <div class="cgsa_checkin_summaryentry" style="margin-bottom: 1em;">
      {* get the owner info, and create a url *}
      {* you could specify a returnid here to use a different detail page *}
      {assign var='uinfo' value=$userinfo[$cgsa_entry->owner]}
      {module_action_link module=CGUserDirectory action=detail page=home uid=$cgsa_entry->owner urlonly=1 assign='userhref'}

      {* create a link with the  user name, and an optional avatar (note the hardcoded property name.  
         If the image is a different property you will need to change it here *}
      {capture assign='user_imglink'}{strip}
        <a href="{$userhref}" title="{$mod->Lang('viewuserdetails')}">    
        {if isset($uinfo.props.avatar) && $uinfo.props.avatar != ''}
          {CGSmartImage class="cgsa_avatar" src1=$uploads_url src2=feusers src3=$uinfo.props.avatar max_width=100 max_height=100}
        {else}
          {CGSmartImage class="cgsa_avatar" src1=$uploads_url src2='missing_avatar.jpg' max_width=100 max_height=100}
        {/if}
        </a>
      {/strip}{/capture}

      {capture assign='usr_link'}<a href="{$usrhref}">{$uinfo.username}</a>{/capture}

      {* get a link to the location detail view *}
      {* you could specify a returnid here to use a different detail page *}
      {cd_getcompany id=$cgsa_entry->location assign='loc'}
      {module_action_link module='CompanyDirectory' action=details companyid=$cgsa_entry->location page=home text=$loc->company_name assign='loclink' urlonly=1}

      {* get a link to the checkin detail view (so we can view images, and respond to this thing *}
      {* you could specify a returnid here to use a different detail page *}
      {module_action_link module='CGSocialApp' action=detail checkin=$cgsa_entry->id urlonly=1 assign='detail_url'}

      {* put it all together, and display it *}
      <div class="row-fluid">
        <div class="span2">{$user_imglink}</div>
        <div class="span10">
          <div class="row-fluid cgsa_who">
            {$CGSocialApp->Lang('who')}: <a href="{$userhref}">{if isset($uinfo.props.full_name) && $uinfo.props.full_name != ''}{$uinfo.props.full_name}{else}{$uinfo.username}{/if}</a>
          </div>
          <div class="row-fluid cgsa_where">{$CGSocialApp->Lang('where')}: <a href="{$loclink}">{$loc->company_name}</a></div>
          {if $cgsa_entry->activity != ''}
            {cgsa_getactivity activity=$cgsa_entry->activity assign='act'}
            {if $act != ''}
              {module_action_link module='CGSocialApp' action='view_activity' activity=$cgsa_entry->activity urlonly=1 assign='acturl'}
            <div class="row-fluid cgsa_what">{$CGSocialApp->Lang('what')}: <a href="{$acturl}">{$act->name}</a></div>
            {/if}
          {/if}
          <div class="row-fluid cgsa_date">{$CGSocialApp->Lang('when')}: {$cgsa_entry->created|date_format:'%x %X'}</div>
          {if $cgsa_entry->msg != ''}
            <div class="row-fluid cgsa_msg">{$CGSocialApp->Lang('message')}: {$cgsa_entry->msg}</div>
          {/if}
          <div class="row-fluid"><a class="cgsa_detail_link" href="{$detail_url}" title="{$CGSocialApp->Lang('title_more')}">{$CGSocialApp->Lang('more')}...</a></div>
        </div>{* .span8 *}
      </div>{* .row-fluid *}
    </div>{* .cgsa-summary-entry *}
  {/foreach}
{else}
  <div class="well">{$CGSocialApp->Lang('msg_checkins_nomatches')}</div>
{/if}
</div>{/strip}