<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_utils
{
  protected function __construct() {}

  public static function return_error($msg)
  {
    $name = cge_utils::get_module('CGSocialApp')->GetName();
    audit('',$name,$msg);

    $data = array('_status'=>'ERROR','_message'=>$msg);
    self::return_success($data);
  }


  public static function return_success($data)
  {
    $code = 200;
    $res = array();
    if( is_array($data) ) {
      // its an array
      if( isset($data['_status']) )
	$res = $data;
      else
	$res['data'] = $data;
    }
    else if( is_object($data) ) {
      // its an object
      $res['data'] = $data;
    }
    else if( $data != '' ) {
      $res['data'] = $data;
    }
    if( !isset($res['_status']) ) {
      $res['_status'] = 'OK';
    }

    $handlers = ob_list_handlers(); 
    for ($cnt = 0; $cnt < sizeof($handlers); $cnt++) { ob_end_clean(); }
    header("HTTP/1.0 $code OK");
    header("Status: $code OK");
    $tmp = json_encode($res);
    echo $tmp;
    exit();
  }
  

  public static function is_get_request()
  {
    if( strtoupper($_SERVER['REQUEST_METHOD']) == 'GET' ) 
      return TRUE;
    return FALSE;
  }


  public static function is_post_request()
  {
    if( strtoupper($_SERVER['REQUEST_METHOD']) == 'POST' ) 
      return TRUE;
    return FALSE;
  }

  
  public static function is_request_secure()
  {
    if( !isset($_SERVER['HTTPS']) ) return FALSE;
    if( $_SERVER['HTTPS'] == '' ) return FALSE;
    if( strtoupper($_SERVER['HTTPS']) == 'OFF' ) return FALSE;
    return TRUE;
  }


  public static function &validate_apikey($key)
  {
    $res = null;
    $obj = cgsa_apikey::load_by_apikey($key);
    if( !is_object($obj) ) return $res;
    if( $obj->expired() ) return $res;
    return $obj;
  }


  public static function get_unique_filename($key)
  {
    $config = cmsms()->GetConfig();
    $suffix = '';
    $mod = cms_utils::get_module('CGSocialApp');
    $rootdir = cms_join_path($config['uploads_path'],'_'.$mod->GetName());
    $filelimit = 10000;

    // now generate a unique filename
    $fn = 'f'.md5($key.$suffix);
    while( (int)$suffix < 100 ) {
      $tmp = cms_join_path($rootdir,$fn);
      $files = glob($tmp.'*');
      if( !is_array($files) || count($files) == 0 ) return $fn;
      $suffix = (int)$suffix + 1;
      $fn = 'f'.md5($key.$suffix);
    }
    die('problem');
  }


  public static function get_checkin_approval_password($location_id)
  {
    $mod = cms_utils::get_module('CGSocialApp');
    if( ($pwfield = $mod->GetPreference('cd_approve_pwfield',-1)) == -1 ) return;

    // get the company directory module
    $cdmod = cms_utils::get_module('CompanyDirectory');

    // is this company in one of the categories we're concerned about?
    $tmp = $mod->GetPreference('cd_categories_approvedcheckins');
    if( !$tmp ) return;
    $tmp = unserialize($tmp);
    if( !$tmp ) return;
    $tmp = array_keys($tmp);

    // get the categories for this company.
    $cats = $cdmod->GetCategoriesForCompany($location_id);
    if( !is_array($cats) || count($cats) == 0 ) return;

    $fnd = 0;
    foreach( $cats as $key => $cat ) {
      if( in_array($key,$tmp) ) {
	$fnd = 1;
	break;
      }
    }
    if( !$fnd ) return;

    // get the field definitions for this company.
    $fielddefs = $cdmod->GetFieldDefsForCompany($id,false,false);
    if( !is_array($fielddefs) || count($fielddefs) == 0 ) return;

    // get the password.
    foreach( $fielddefs as $k => $onedef ) {
      if( $onedef['id'] == $pwfield ) {
	return trim($onedef['data']);
      }
    }

    // password field not found.
    return;
  }


  public static function is_checkin_approval_required($location_id)
  {
    $mod = cms_utils::get_module('CGSocialApp');
    $cdmod = cms_utils::get_module('CompanyDirectory');

    $tmp = $mod->GetPreference('cd_categories_approvedcheckins');
    if( !$tmp ) return FALSE;
    $tmp = unserialize($tmp);
    if( !$tmp ) return FALSE;
    $tmp = array_keys($tmp);
    
    $cats = $cdmod->GetCategoriesForCompany($location_id);
    if( !is_array($cats) || count($cats) == 0 ) return FALSE;
    
    foreach( $cats as $key => $cat ) {
      if( in_array($key,$tmp) && $cat->value == 1 ) {
	return TRUE;
      }
    }
    return FALSE;
  }


  public static function check_user_to_location($location_id,$uid,$pw = '')
  {
    $mod = cms_utils::get_module('CGSocialApp');
    $userfield = $mod->GetPreference('cd_approve_userfield',-1);
    $pwfield = $mod->GetPreference('cd_approve_pwfield',-1);
    if( $userfield == -1 && $pwfield == -1 ) return FALSE; // no password or userfield specified... can't approve shit.

    // get the company directory module
    $cdmod = cms_utils::get_module('CompanyDirectory');

    // get the field definitions for this company.
    $fielddefs = $cdmod->GetFieldDefsForCompany($id,false,false);
    if( !is_array($fielddefs) || count($fielddefs) == 0 ) return;

    if( $pwfield > 0 ) {
      // find and validate the passwod...
      if( $pw == '' ) return FALSE; // no password supplied.
      $fnd = 0;
      foreach( $fielddefs as $k => $onedef ) {
	if( $onedef['id'] != $pwfield ) continue;
	
	if( md5($onwdef['value']) == $pw ) {
	  $fnd = 1;
	}
	break;
      }
      if( !$fnd ) return FALSE; // password field either not found, or did not match.
    }

    if( $userfield > 0 ) {
      // validate username/uid
      foreach( $fielddefs as $k => $onedef ) {
	if( $onedef['id'] != $userfield ) continue;
	
	// found the field.
	$data = $onedef['value'];
	if( !$data ) break;
	$data = explode(',',$data);
	if( !is_array($data) || count($data) == 0 ) return FALSE;
	
	// note: expensive... all usernames/uid should go into one large OR query
	foreach( $data as $one ) {
	  $one = trim($one);
	  if( is_int($one) && $one == $uid ) {
	    // found matching user via uid
	    return TRUE;
	  }
	  
	  $query = new feu_user_query(1);
	  $query->add_and_opt(feu_user_query_opt::MATCH_USERNAME,$one);
	  $rs = $query->execute();
	  if( $rs->get_found_rows() ) {
	    // found matching user via username
	    return TRUE;
	  }
	}
	break;
      }
    }

    return FALSE;
  }


  /**
   * A smarty plugin to create a dropdown for selecting an activity.
   *
   */
  public static function smarty_selactivity($params,$smarty)
  {
	$prefix = '';
	$id = '';
	$name = 'cgsa_selactivity';
	$class = 'cgsa_selactivity';
	$selected = '';
	$any = '';

	if( isset($params['prefix']) ) $prefix = trim($params['prefix']);
	if( isset($params['id']) ) $id = trim($params['id']);
	if( isset($params['class']) ) $class = trim($params['class']);
	if( isset($params['name']) ) $name = trim($params['name']);
	if( isset($params['selected']) ) $selected = trim($params['selected']);
	if( isset($params['any']) ) {
	  $tmp = $params['any'];
	  if( (int)$tmp != 0 )
	    $any = cms_utils::get_module(MOD_CGSOCIALAPP)->Lang('any');
	  else 
	    $any = $tmp;
	}

	// get the hierarchy as a flat list.
	$items = cgsa_activity::load_all_as_array();
	if( !is_array($items) || count($items) == 0 ) return;
	$tmp = array();
	foreach( $items as $row ) {
	  $t2 = explode('.',$row['hierarchy']);
	  $depth = count($t2);
	  $tmp[$row['id']] = str_repeat('&nbsp&nbsp;',$depth-1).$row['name'];
	}
	$items = $tmp;

	// build the output.
	$out = '<select name="'.$prefix.$name.'"';
	if( $class ) $out .= ' class="'.$class.'"';
	if( $id ) $out .= ' id="'.$id.'"';
	$out .= '>';
	if( $any != '' ) $out .= '<option value="">'.$any.'</option>';
	foreach( $items as $id => $label ) {
	  $out .= '<option value="'.$id.'"';
	  if( $id == $selected ) $out .= ' selected="selected"';
	  $out .= '>'.$label.'</option>';
	}
	$out .= '</select>';

	if( isset($params['assign']) ) {
	  $smarty->assign($params['assign'],$out);
	  return;
	}
	return $out;
  }

  public static function smarty_getactivity($params,$smarty)
  {
    $aid = '';
    $ob = null;
    if( isset($params['aid']) ) $aid = (int)$params['aid'];
    if( isset($params['activity']) ) $aid = (int)$params['activity'];
    
    if( $aid > 0 ) {
      $ob = cgsa_activity::load_by_id($aid);
    }

    if( isset($params['assign']) ) {
      $smarty->assign($params['assign'],$ob);
      return;
    }

    return $ob;
  }

  public static function smarty_get_favorites($params,$smarty)
  {
    $feu = cms_utils::get_module('FrontEndUsers');
    if( !is_object($feu) ) return;
    
    $uid = $feu->LoggedInId();
    if( $uid < 1 ) return; // not logged in.

    $out = cgsa_favorites::list_for_user($uid);
    if( isset($params['assign']) ) {
      $smarty->assign($params['assign'],$out);
      return;
    }
    return $out;
  }

  public static function smarty_get_friends($params,$smarty)
  {
    $feu = cms_utils::get_module('FrontEndUsers');
    if( !is_object($feu) ) return;
    
    $uid = $feu->LoggedInId();
    if( $uid < 1 ) return; // not logged in.

    $out = cgsa_friends::get_friends($uid);
    if( isset($params['assign']) ) {
      $smarty->assign($params['assign'],$out);
      return;
    }
    return $out;
  }

  public static function get_leaderboard_filepath()
  {
    $config = cmsms()->GetConfig();
    $mod = cms_utils::get_module('CGSocialApp');
    $dir = cms_join_path($config['uploads_path'],'_'.$mod->GetName(),'leaderboards');
    return $dir;
  }

  public static function get_leaderboard_fileurl()
  {
    $config = cmsms()->GetConfig();
    $mod = cms_utils::get_module('CGSocialApp');
    $url = $config['uploads_url'].'/_'.$mod->GetName().'/leaderboards';
    return $url;
  }

  public static function get_badge_filepath_by_badge_id($id)
  {
    if( $id < 1 ) return;
    $config = cmsms()->GetConfig();
    $mod = cms_utils::get_module('CGSocialApp');
    $dir = cms_join_path($config['uploads_path'],'_'.$mod->GetName(),'badges','b'.$id);
    return $dir;
  }

  public static function get_badge_filepath(cgsa_badge $badge)
  {
    if( $badge->id < 1 ) throw new CmsException('Cannot create a filepath for a badge with no id');
    return self::get_badge_filepath_by_badge_id($badge->id);
  }

  public static function get_badge_fileurl(cgsa_badge $badge)
  {
    if( $badge->id < 1 ) throw new CmsException('Cannot create a filepath for a badge with no id');
    $config = cmsms()->GetConfig();
    $mod = cms_utils::get_module('CGSocialApp');
    $url = $config['uploads_url'].'/_'.$mod->GetName().'/badges/b'.$badge->id;
    return $url;
  }

  public static function delete_image($dir,$name)
  {
    if( $dir == '' || $name == '' ) return FALSE;
    if( !is_dir($dir) ) return FALSE;

    $files = glob(cms_join_path($dir,'*'.$name));
    if( !is_array($files) || count($files) == 0 ) return FALSE;

    foreach( $files as $one ) {
      @unlink($one);
    }
    return TRUE;
  }

  public static function smarty_togglefavorite_link($params,$smarty)
  {
    $mod = cms_utils::get_module('CGSocialApp');
    $favtext = $mod->Lang('prompt_addtofavs');
    $unfavtext = $mod->Lang('prompt_removefav');
    $class = '';
    $classtrue = '';
    $classfalse = '';
    $mid = 'cntnt01';
    $id = '';
    $urlonly = 0;
    $jsfriendly = 0;
    $noredirect = 0;
    $returnid = cms_utils::get_current_pageid();
    $redirectcontent = 0;
    $feu = cms_utils::get_module('FrontEndUsers');
    if( !is_object($feu) ) return;
    $uid = $feu->LoggedInId();
    if($uid < 1) return;

    if( !isset($params['location']) ) return;
    $location = (int)$params['location'];
    if( $location < 1 ) return;

    foreach( $params as $key => $value ) {
      switch( $key ) {
      case 'favtext':
      case 'unfavtext':
      case 'class':
      case 'classtrue':
      case 'classfalse':
      case 'id':
	$$key = trim($value);
	break;

      case 'returnid':
	$$key = (int)$value;
	breka;

      case 'urlonly':
      case 'jsfriendly':
      case 'noredirect':
      case 'redirectcontent':
	$$key = cms_to_bool($value);
	break;
      }
    }

    $parms = array('location'=>$location);
    $parms['noredirect'] = $noredirect;
    if( !$redirectcontent ) $parms['dest'] = base64_encode(cge_url::current_url());
    $url = $mod->create_url($mid,'togglefavorite',$returnid,$parms);
    if( $jsfriendly ) $url = str_replace('&amp;','&',$url).'&showtemplate=false';

    $out = null;
    if( $urlonly ) {
      $out = $url;
    }
    else {
      $out = '<a href="'.$url.'"';
      if( $id ) $out .= " id=\"{$id}\"";
      $txt = '';
      if( cgsa_favorites::check($uid,$location) ) {
	$txt .= $unfavtext;
	if( $classtrue ) $class=$classtrue;
      } else {
	$txt .= $favtext;
	if( $classfalse ) $class=$classfalse;
      }
      if( $class ) $out .= " class=\"{$class}\"";
      $out .= '>'.$txt;
      $out .= '</a>';
    }

    if( isset($params['assign']) ) {
      $smarty->assign(trim($params['assign']),$out);
      return;
    }
    return $out;
  }

  public static function smarty_friendreq_link($params,$smarty)
  {
    $mod = cms_utils::get_module('CGSocialApp');
    $reqtext = $mod->Lang('prompt_sendfriendreq');
    $rmreqtext = $mod->Lang('prompt_removefriendreq');
    $rmfriendtext = $mod->Lang('prompt_removefriend');
    $class = '';
    $mid = 'cntnt01';
    $id = '1';
    $urlonly = 0;
    $jsfriendly = 0;
    $redirectcontent = 0;
    $noredirect = 0;
    $action = 'friendreq';
    $returnid = cms_utils::get_current_pageid();
    $text = $reqtext;

    $feu = cms_utils::get_module('FrontEndUsers');
    if( !is_object($feu) ) return;
    $uid = $feu->LoggedInId();
    if($uid < 1) return;

    if( !isset($params['user']) ) return;
    $fuid = (int)$params['user'];
    if( $fuid < 1 ) return;

    foreach( $params as $key => $value ) {
      switch( $key ) {
      case 'reqtext':
      case 'rmreqtext':
      case 'class':
      case 'id':
	$$key = trim($value);
	break;

      case 'returnid':
	$$key = (int)$value;
	breka;

      case 'urlonly':
      case 'jsfriendly':
      case 'noredirect':
      case 'redirectcontent':
	$$key = cms_to_bool($value);
	break;
      }
    }

    if( $uid == $fuid ) return;

    if( cgsa_friends::is_friend($uid,$fuid) ) {
      // he's already a friend, we can remove him
      $text = $rmfriendtext;
      $action = 'rmfriend';
    }
    else if( cgsa_friends::is_requested($uid,$fuid) ) {
      // friend request exists.
      $text = $rmreqtext;
      $action = 'rmfriendreq';
    }

    $parms = array('user'=>$fuid);
    $parms['noredirect'] = $noredirect;
    if( !$redirectcontent ) $parms['dest'] = base64_encode(cge_url::current_url());
    if( isset($params['template']) ) $parms['template'] = trim($params['template']);
    $url = $mod->create_url($mid,$action,$returnid,$parms);
    if( $jsfriendly ) $url = str_replace('&amp;','&',$url).'&showtemplate=false';

    $out = null;
    if( $urlonly ) {
      $out = $url;
    }
    else {
      $out = '<a href="'.$url.'"';
      if( $id ) $out .= " id=\"{$id}\"";
      if( $class ) $out .= " class=\"{$class}\"";
      $out .= ">".$text."</a>";
    }

    if( isset($params['assign']) ) {
      $smarty->assign(trim($params['assign']),$out);
      return;
    }
    return $out;
  }

  public static function get_events()
  {
    return array('OnCheckin','OnUpdateCheckin','PreDeleteCheckin','PostDeleteCheckin',
		 'OnBadgeAwarded','OnBadgeRevoked','OnFriendRequest','OnFriendApproved',
		 'OnFriendRejected','OnFriendRemoved');
  }

  public static function send_event($event,$params = array())
  {
    $mod = cms_utils::get_module(MOD_CGSOCIALAPP);
    $mod->SendEvent($event,$params);

    if( in_array($event,self::get_events()) ) $res = $mod->DoEvent($mod->GetName(),$event,$params);
  }

  /**
   * Create a link that allows users to approve, or deny friend relationships.
   *
   * This function creates a link (or a URL) that when requested will either approve, or deny a friendship relationship, and then
   * redirect the user back to the URL from which the request initiated.
   *
   * Parameters:
   *   user       (required integer) - The user to which we are approving (or denying) the friend relationship
   *   noredirect (boolean) - Do not redirect after performing the action. (useful for ajax requests)
   *   redirectcontent (boolean) - Do not redirect to the originating URL, use the returnid and redirect to the content page.
   *   returnid   (integer) - Use an alternate page id for processing the request.
   *   state      (integer) - Positive value to approve a friend request, 0 or negative value to deny a friend request.
   *   approvetext (string) - Text to use in the link that approves a friend request.
   *   denytext   (string)  - Text to use in the link that denies a friend request.
   *   id         (string)  - id tag for the generated link
   *   class      (string)  - class attribute for the generated link
   *   urlonly    (boolean) - Do not generate a link, just generate a URL.
   *   jsfriendly (boolean) - Generate a URL suitable for javascript, or ajax.
   *
   * @return string
   */
  public static function create_approvefriendreq_url($params)
  {
    $mod = cms_utils::get_module(MOD_CGSOCIALAPP);
    $urlonly = 0;
    $state = 1;
    $mid = 'cntnt01';
    $class = '';
    $id = '';
    $returnid = cms_utils::get_current_pageid();
    $approvetext = $mod->Lang('prompt_approve_friendreq');
    $denytext = $mod->Lang('prompt_deny_friendreq');
    $noredirect = 0;
    $jsfriendly = 0;
    $redirectcontent = 0;
    $user = '';

    foreach( $params as $key => $value ) {
      switch( $key ) {
      case 'noredirect':
      case 'redirectcontent':
      case 'returnid':
      case 'state':
      case 'user':
      case 'jsfriendly':
      case 'urlonly':
	$$key = (int)$value;
	break;

      case 'approvetext':
      case 'denytext':
      case 'id':
      case 'class':
	$$key = trim($value);
	break;
      }
    }

    if( $user < 1 ) return;
    $parms = array('user'=>$user);
    $parms['noredirect'] = $noredirect;
    if( !$redirectcontent ) $parms['dest'] = base64_encode(cge_url::current_url());
    $url = $mod->create_url($mid,'approvefriendreq',$returnid,$parms);
    if( $jsfriendly ) $url = str_replace('&amp;','&',$url).'&showtemplate=false';

    $text = $approvetext;
    if( $state < 1 ) $text = $denytext;

    $out = null;
    if( $urlonly ) {
      $out = $url;
    }
    else {
      $out = '<a href="'.$url.'"';
      if( $id ) $out .= ' id="'.$id.'"';
      if( $class ) $out .= ' class="'.$class.'"';
      $out .= '>'.$text.'</a>';
    }

    if( isset($params['assign']) ) {
      $smarty->assign(trim($params['assign']),$out);
      return;
    }
    return $out;
  }
} // end of class

#
# EOF
#
?>