<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_social 
{
  private function __construct() {}

  /**
   * List known, and available social networks
   *
   * @return hash of Module Name, and printable name.
   */
  public static function get_network_list()
  {
    $modules = ModuleOperations::get_instance()->get_modules_with_capability('cg_messaging_client');
    if( !is_array($modules) || count($modules) == 0 ) return;

    $out = array();
    foreach( $modules as $one ) {
      $mod = cms_utils::get_module($one);
      if( !is_object($mod) ) continue;

      if( method_exists($one,'get_user_key') && method_exists($one,'set_user_key') &&
	  method_exists($one,'get_transport_name')) {
	if( !isset($out[$mod->GetName()]) ) $out[$mod->GetName()] = $mod->get_transport_name();
      }
    }
    if( count($out) ) return $out;
  }

  public static function find_network_module($str)
  {
    if( !$str ) return;
    $list = self::get_network_list();
    if( !is_array($list) || count($list) == 0 ) return;

    foreach( $list as $mod => $lbl ) {
      if( $str == $mod ) return $mod;
      if( $lbl == $str ) return $mod;

      $tmp = str_replace('_',' ',$str);
      if( $tmp == $lbl ) return $mod;

      $tmp = str_replace('-',' ',$str);
      if( $tmp == $lbl ) return $mod;
    }
  }

} // end of class

#
# EOF
#
?>