<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgsa_log_entry
{
  static private $_keys = array('uid','when','item','item_id','description','notes');
  private $_data = array();

  public function __construct()
  {
    $this->_data['when'] = time();
  }

  public function __set($k,$v)
  {
    switch( $k ) {
    case 'uid':
    case 'when':
    case 'item_id':
      if( (int)$v == 0 ) {
	throw new Exception('Attempt1 to store invalid value for '.$k.' ('.$v.') into cgsa_log_entry object');
      }
      $this->_data[$k] = (int)$v;
      break;
      
    case 'item':
      if( trim($v) == '' ) {
	throw new Exception('Attempt2 to store invalid value for '.$k.' ('.$v.') into cgsa_log_entry object');
      }
      $this->_data[$k] = trim($v);
      break;
      
    case 'description':
      $this->_data[$k] = trim($v);
      break;
      
    case 'notes':
      $this->_data[$k] = $v;
      break;
      
    default:
      throw new Exception('Attempt3 to store invalid value for '.$k.' ('.$v.') into cgsa_log_entry object');
    }
  }

  public function __get($k)
  {
    if( !in_array($k,self::$_keys) ) {
      throw new Exception('Attempt to retrieve invalid key '.$key.' from cgsa_log_entry object');
    }

    if( isset($this->_data[$k]) ) return $this->_data[$k];
  }

  public function __isset($k)
  {
    if( !in_array($k,self::$_keys) ) {
      throw new Exception('Attempt to retrieve invalid key '.$key.' from cgsa_log_entry object');
    }

    return (isset($this->_data[$k]))?TRUE:FALSE;
  }

}

class cgsa_log
{
  private function __construct() {}

  public static function addEntry(cgsa_log_entry $entry)
  {
    $db = cmsms()->GetDb();
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_LOG.' (when,item,description,notes) VALUES (?,?,?,?)';
    $dbr = $db->Execute($query,
			array($entry->when,$entry->item,$entry->description,$entry->notes));
  }

  public static function add($item,$description,$uid = null,$item_id = null,$notes = null)
  {
    debug_to_log("cgsa_log::add('$item','$description',$uid,$item_id,'$notes')");
    $entry = new cgsa_log_entry;
    $entry->item = $item;
    $entry->description = $description;
    $entry->item_id = $item_id;
    $entry->uid = $uid;
    $entry->notes = $notes;

    return self::addEntry($entry);
  }
}

#
# EOF
#
?>