<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

  // internal.
final class cgsa_leaderboard_tasks 
{
  public static function update_leaderboard_scores(cgjobmgr_task& $task)
  {
    // get all leaderboards
    // for each leaderboard
    //   count (processed) checkins that match it.
    //     (one series of funky advanced queries)
    //     return UID and score
    //   delete members for this leaderboard
    //   foreach uid
    //     insert scores
  }

  // @todo: rename this function
  public static function update_one_leaderboard(cgjobmgr_task& $task)
  {
    audit('','CGSocialApp','update_one_leaderboard');

    // find checkins that are not processed
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_CHECKINS.'
              WHERE COALESCE(processed,0) = 0 AND approved = 1 LIMIT 50';
    $dbr = $db->GetArray($query);
    if( !is_array($dbr) || count($dbr) == 0 ) {
      return cgjobmgr_task::STATUS_COMPLETE;
    }

    foreach( $dbr as $row ) {
      $checkin = cgsa_checkin::load_from_array($row);

      // if there are tagged users 
      $tagged = $checkin->get_tagged_users();
      if( is_array($tagged) && count($tagged) ) {
	// notify user that he was tagged.
	cgsa_checkin_utils::notify_tagged_users($checkin);
      }

      $res = cgsa_leaderboard::find_matching($checkin);
      if( is_array($res) ) {
	// we have one or more matching leaderboard.
	foreach( $res as $leaderboard ) {
	  // add a score for this item.
	  $leaderboard->adjust_score($checkin->owner);
	  audit($checkin->owner,'CGSocialApp','Adjusted score for leaderboard '.$leaderboard->id);
	}
      }
      $checkin->processed = 1;
      $checkin->save();
    }

    return cgjobmgr_task::STATUS_INCOMPLETE;
  }

  public static function update_badges_for_leaderboard(cgjobmgr_task& $task)
  {
    audit('','CGSocialApp','update_badges_for_leaderboard');

    $offset = $task->get_persistent_data('leaderboard_offset',0);
    $db = cmsms()->GetDb();

    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_LEADERBOARD;
    $dbr = $db->SelectLimit($query,20,$offset);

    $nrecords = $dbr->RecordCount();
    while( $dbr && !$dbr->EOF ) {
      $leaderboard = cgsa_leaderboard::load_from_data($dbr->fields);
      if( !is_object($leaderboard) ) {
	// should audit this..
	$dbr->MoveNext();
	continue;
      }

      $badges = $leaderboard->get_badges();
      if( !is_array($badges) || count($badges) == 0 ) {
	$dbr->MoveNext();
	continue;
      }

      foreach( $badges as $one_badge ) {
	$max_score = $one_badge->max_score;
	if( $max_score < 1 ) $max_score = 1000000;

	// delete badge members who no longer meet the criteria
        $query = 'SELECT BU.uid FROM '.CGSOCIAL_TABLE_BADGES_USERS.' BU
                  LEFT JOIN '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.' LM
                  ON BU.uid = LM.uid 
                  AND BU.leaderboard_id = LM.board_id 
                  AND BU.badge_id = ?
                  WHERE LM.score NOT BETWEEN ? AND ?';
	$uids = $db->GetCol($query,array($one_badge->id,$one_badge->min_score,$max_score));
	if( is_array($uids) && count($uids) ) {
	  foreach( $uids as $one_uid ) {
	    cgsa_badge_utils::remove_badge_member($one_badge,$one_uid);
	  }
	}

	if( $one_badge->is_unique ) {
	  if( $one_badge->count_members() != 0 ) {
	    continue;
	  }
	}

	// get users who's score matches
	$query = 'SELECT LM.uid FROM '.CGSOCIAL_TABLE_LEADERBOARD_MEMBERS.' LM
                  WHERE LM.board_id = ? AND LM.score BETWEEN ? AND ?';
	$uids1 = $db->GetCol($query,array($leaderboard->id,(int)$one_badge->min_score,
					 $max_score));
	if( !is_array($uids1) || count($uids1) == 0 ) {
	  continue;
	}
        
	// check if any of these users have this badge already
	$query = 'SELECT BU.uid FROM '.CGSOCIAL_TABLE_BADGES_USERS.' BU
                  WHERE BU.leaderboard_id = ? AND BU.badge_id = ? AND BU.uid IN ('.implode(',',$uids1).')';
	$uids2 = $db->GetCol($query,array((int)$leaderboard->id,(int)$one_badge->id));

	if( !is_array($uids2) || count($uids2) == 0 ) {
	  $new_badge_uids = $uids1;
	}
	else {
	  $new_badge_uids = array_diff($uids1,$uids2);
	}

	if( !is_array($new_badge_uids) || count($new_badge_uids) == 0 ) {
	  continue;
	}

	foreach( $new_badge_uids as $newmember ) {
	  cgsa_badge_utils::add_badge_member($one_badge,$newmember);
	  audit($newmember,'CGSocialApp','Added badge '.$one_badge->name);
	}
      }
      $dbr->MoveNext();
    }
    if( $nrecords < 20 ) {
      // task is complete
      $task->set_persistent_data('leaderboard_offset',0);
      return cgjobmgr_task::STATUS_COMPLETE;
    }
    else {
      $task->set_persistent_data('leaderboard_offset',$offset+$nrecords);
      return cgjobmgr_task::STATUS_INCOMPLETE;
    }
  }

} // end of class

#
# EOF
#
?>
