<?php

abstract class cgsa_friend_manipulator
{
  abstract public function get_friends($uid,$limit = 100000,$offset = 0);

  abstract public function is_friend($uid,$fuid);

  /**
   * Test if there is a friend request from one user to another.
   *
   * @param string The user identifier of the from user.
   * @param string The user identifier of the to user.
   * @return boolean
   */
  public function is_requested($uid,$fuid)
  {
    $list = $this->get_friendrequests($fuid);
    if( is_array($list) && count($list) ) {
      if( in_array($uid,$list) ) return TRUE;
    }
    return FALSE;
  }

  abstract public function add_friend($uid,$fuid);

  abstract public function del_friend($uid,$fuid);

  abstract public function get_notfriends($uid);

  abstract public function add_notfriend($uid,$fuid);

  abstract public function del_notfriend($uid,$fuid);

  abstract public function get_friendrequests($uid,$limit = 1000,$offset = 0);

  abstract public function add_friendrequest($fuid,$uid);

  abstract public function del_friendrequest($fuid,$uid);

  abstract public function delete_all($uid);
} // end of class

#
# EOF
#
?>