<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_favorites
{
  private function __construct() {}

  public static function list_for_user($uid,$limit = 100000,$offset = 0)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT location FROM '.CGSOCIAL_TABLE_FAVORITES.' WHERE fuid = ?';
    $dbr = $db->SelectLimit($query,(int)$limit,(int)$offset,array((int)$uid));
    if( $dbr ) {
      $out = array();
      while( !$dbr->EOF ) {
	$out[] = $dbr->fields['location'];
	$dbr->MoveNext();
      }
      return $out;
    }
  }

  public static function check($uid,$location)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_FAVORITES.' WHERE fuid = ? AND location = ?';
    $dbr = $db->GetRow($query,array((int)$uid,(int)$location));
    if( is_array($dbr) && count($dbr) ) return TRUE;
    return FALSE;
  }

  public static function add($uid,$location)
  {
    $db = cmsms()->GetDb();
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_FAVORITES.' (fuid,location) VALUES (?,?)';
    $dbr = $db->Execute($query,array((int)$uid,(int)$location));
  }

  public static function delete($uid,$location)
  {
    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FAVORITES.' WHERE fuid = ? AND location = ?';
    $dbr = $db->Execute($query,array((int)$uid,(int)$location));
  }

  public static function delete_all($uid)
  {
    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FAVORITES.' WHERE fuid = ?';
    $dbr = $db->Execute($query,array((int)$uid));
  }

  public static function delete_for_location($location)
  {
    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FAVORITES.' WHERE location = ?';
    $dbr = $db->Execute($query,array((int)$location));
  }

  public static function get_mostpopular($parms)
  {
    $userlist  = null;
    $locations = null;
    $limit     = 100000;
    $offset    = 0;
    if( isset($params['userlist']) && is_array($parms['userlist']) && count($parms['userlist']) ) $userlist = $parms['userlist'];
    if( isset($params['locations']) && is_array($parms['locations']) && count($parms['locations']) ) $locations = $parms['locations'];
    if( isset($params['limit']) ) $limit = (int)$params['limit'];
    if( isset($params['offset']) ) $offset = (int)$params['offset'];
    $limit = max(1,min(100000,$limit));
    $offset = max(0,$offset);
    
    $db = cmsms()->GetDb();
    $query = 'SELECT location,count(fuid) AS cnt FROM '.CGSOCIAL_TABLE_FAVORITES;

    $where = array();
    if( is_array($userlist) && count($userlist) > 0 ) {
      $tmp = array();
      for( $i = 0; $i < count($userlist); $i++ ) {
	$n = (int)$userlist[$i];
	if( $n < 1 ) continue;
	if( in_array($n,$tmp) ) continue;
	$tmp[] = $n;
      }
      if( is_array($tmp) && count($tmp) > 0 ) {
	$where[] = 'fuid IN ('.implode(',',$tmp).')';
      }
    }

    if( is_array($locations) && count($locations) ) {
      $where[] = 'location IN ('.implode(',',$locations).')';
    }

    if( count($where) ) {
      $query .= ' WHERE '.implode(' AND '.$where);
    }


    $query .= ' GROUP BY location ORDER BY cnt DESC';

    $out = null;
    $res = $db->Select($query,$limit,$offset);
    if( $res ) {
      $out = array();
      while( !$res->EOF ) {
	$row = $res->fields;
	$out[$row['location']] = $row['cnt'];
	$res->MoveNext();
      }
    }
    return $out;
  }
} // end of class

#
# EOF
#
?>