<?php

class cgsa_simple_friend_manipulator extends cgsa_friend_manipulator
{
  /**
   * Retrieve a list of the users friends
   *
   * @param string The user identifier
   * @param integer The limit to the number of friends (not implemented)
   * @param integer The offset (not implemented)
   * @return array of uids or null
   */
  public function get_friends($uid,$limit = 100000,$offset = 0)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT fuid FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND reln = 1';
    $dbr = $db->SelectLimit($query,$limit,$offset,array($uid));
    if( $dbr ) {
      $out = array();
      while( !$dbr->EOF ) {
	$out[] = $dbr->fields['fuid'];
	$dbr->MoveNext();
      }
      return $out;
    }
  }

  /**
   * Test if the user and fuid are friends.
   *
   * @param string The user id to add to
   * @param string The friends user id.
   * @return bool
   */
  public function is_friend($uid,$fuid)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT fuid FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln = 1';
    $tmp = $db->GetOne($query,array($uid,$fuid));
    if( $tmp ) return TRUE;
    return FALSE;
  }

  /**
   * Add fuid as a friend to uid
   * This is a database function only.  No events are sent.
   * This function only effects one side of the friend relationship
   *
   * @param string The user id to add to
   * @param string The friends user id.
   * @return null
   */
  public function add_friend($uid,$fuid)
  {
    $db = cmsms()->GetDb();

    // delete from notfriends and requests...
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln != 1';
    $db->Execute($query,array($uid,$fuid));

    // make sure not already a friend
    $query = 'SELECT uid FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln = 1';
    $r1 = $db->GetOne($query,array($uid,$fuid));
    if( $r1 ) return; // nothing to do.

    $query = 'INSERT INTO '.CGSOCIAL_TABLE_FRIENDSHIPS.' (uid,fuid,reln) VALUES (?,?,?)';
    $dbr = $db->Execute($query,array($uid,$fuid,1);
  }

  /**
   * Delete a friend relationship
   * This is a database function only, no events are triggered
   * This method only deletes one side of the friend relationship, not both
   *
   * @param string The userid
   * @param string The friends user id
   * @return null
   */
  public function del_friend($uid,$fuid)
  {
    $db = cmsms()->GetDb();

    // delete from notfriends
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln = ?';
    $db->Execute($query,array($uid,$fuid,1));
  }

  /**
   * Get a list of the uids that we have denied from being friends
   *
   * @param string The userid
   * @return array of user ids
   */
  public function get_notfriends($uid)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT fuid FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND reln = -1';
    $dbr = $db->SelectLimit($query,$limit,$offset,array($uid));
    if( $dbr ) {
      $out = array();
      while( !$dbr->EOF ) {
	$out[] = $dbr->fields['fuid'];
	$dbr->MoveNext();
      }
      return $out;
    }
  }

  /**
   * Add a user to our list of notfriends
   * This method only effects one side of the friendship relation, and does not explicitly remove a friend from the friendslist
   * It is possible using this method to have a uid in the friends list and not friends list.  Developers must use caution.
   * This method does the database work only, no events are sent.
   *
   * @param string The user id
   * @param string The friends user id
   * @return null
   */
  public function add_notfriend($uid,$fuid)
  {
    $db = cmsms()->GetDb();

    // delete from friends or friend requests.
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln != ?';
    $db->Execute($query,array($uid,$fuid,-1));

    // make sure not already a notfriend
    $query = 'SELECT uid FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln = -1';
    $r1 = $db->GetOne($query,array($uid,$fuid));
    if( $r1 ) return; // nothing to do.

    $query = 'INSERT INTO '.CGSOCIAL_TABLE_FRIENDSHIPS.' (uid,fuid,reln) VALUES (?,?,?)';
    $dbr = $db->Execute($query,array($uid,$fuid,-1);
  }


  /**
   * Remove a user from our list of notfriends
   * This method only effects one side of the friendship relation. 
   * This method does the database work only, no events are sent.
   *
   * @param string The user id
   * @param string The friends user id
   * @return null
   */
  public function del_notfriend($uid,$fuid)
  {
    $db = cmsms()->GetDb();

    // delete from notfriends
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln = ?';
    $db->Execute($query,array($uid,$fuid,-1));
  }


  public function get_friendrequests($uid,$limit = 1000,$offset = 0)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT fuid FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND reln = -2';
    $dbr = $db->SelectLimit($query,$limit,$offset,array($uid));
    if( $dbr ) {
      $out = array();
      while( !$dbr->EOF ) {
	$out[] = $dbr->fields['fuid'];
	$dbr->MoveNext();
      }
      return $out;
    }
  }

  /**
   * Create a friend request to the user identified by fuid from the user identified by uid
   * This function does the database work only, notifications are not sent.
   * 
   * @param string The potential friends user id
   * @param string The current users uid
   * @return null
   */
  public function add_friendrequest($fuid,$uid)
  {
    $db = cmsms()->GetDb();

    // make sure not already in the db somehow.
    $query = 'SELECT uid FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ?';
    $r1 = $db->GetOne($query,array($uid,$fuid));
    if( $r1 ) return; // nothing to do.

    $query = 'INSERT INTO '.CGSOCIAL_TABLE_FRIENDSHIPS.' (uid,fuid,reln) VALUES (?,?,?)';
    $dbr = $db->Execute($query,array($uid,$fuid,-2);
  }


  /**
   * Delete a friend request to the user identified by fuid from the user identified by uid
   * This function does the database work only, notifications are not sent.
   * 
   * @param string the potential friends user id
   * @param string The current users id
   * @return null
   */
  public function del_friendrequest($fuid,$uid)
  {
    $db = cmsms()->GetDb();

    // delete from notfriends
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ? AND reln = ?';
    $db->Execute($query,array($uid,$fuid,-2));
  }

  public function delete_all($uid)
  {
    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_FRIENDSHIPS.' WHERE uid = ? AND fuid = ?';
    $db->Execute($query,array($uid,$fuid));
  }
} // end of class

?>
