<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_checkin_utils 
{
  private function __construct() {}

  public static function notify_tagged_users(cgsa_checkin $checkin)
  {
    $notifier = cms_utils::get_module('CGNotifier');
    $cgsa = cms_utils::get_module('CGSocialApp');
    $users = $checkin->get_tagged_users();
    $priority = $cgsa->GetPreference('feu_tagged_priority');
    if( $notifier && count($users) > 0 && $priority > 0 ) {
      foreach( $users as $uid ) {
	$msg = new notification_message();
	$msg->module = $cgsa->GetName();
	if( $badge->notify_to == 'user' ) {
	  $msg->to = $uid;
	}
	$msg->subject = $cgsa->GetPreference('feu_tagged_subject');
	$msg->priority = $cgsa->SetPreference('feu_tagged_priority');
     
	$smarty = cms_utils::get_smarty();
	$smarty->assign('checkin',$checkin);
	$location = cd_utils::get_company($checkin->location);
	$smarty->assign('location',$location);

	$feu = cms_utils::get_module('FrontEndUsers');
	$smarty->assign('uid',$uid);
	$smarty->assign('username',$feu->GetUserName($uid));
	$smarty->assign('email',$feu->GetEmail($uid));
	
	$msg->body = $cgsa->ProcessTemplateFromDatabase('feu_tagged_tpl');
	$notifier->notify($msg);
      }

      audit($checkin->id,$cgsa->GetName(),'Notifications sent for checkin');
    }
  }
} // end of class

#
# EOF
#
?>