<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgsa_checkin_query implements ArrayAccess
{
  private static $_keys = array('location','activity','activityparent','timelimit','owner','owners','limit','offset','sortby','sortorder','approved');
  private static $_sortings = array('id','owner','location','activity','activityparent','created');
  private $_data = array();

  public function __construct($params = array())
  {
    $this->_data['sortby'] = 'created';
    $this->_data['sortorder'] = 'DESC';
    $this->_data['offset'] = 0;
    $this->_data['limit'] = 500;

    foreach( $params as $key => $value ) {
      $this[$key] = $value;
    }
  }

  public function offsetGet($key)
  {
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to retrieve invalid value from cgsa_checkin_query');
    }
    if( isset($this->_data[$key]) ) return $this->_data[$key];
  }

  public function offsetSet($key,$value)
  {
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to set invalid key into cgsa_checkin_query: '.$key);
    }

    switch( $key ) {
    case 'approved':
      $value = cge_utils::to_bool($value);
      if( $value ) 
	$value = 1;
      else
	$value = 0;
      $this->_data[$key] = $value;
      break;

    case 'location':
      // accepts a single positive integer, or a comma separated list of positive integers, or even an array of integers
      if( is_int($value) ) {
	$value = array($value);
      }
      else if( is_string($value) ) {
	$value = explode(',',$value);
      }
      if( is_array($value) && count($value) ) {
	$tmp = array();
	foreach( $value as $one ) {
	  $one = (int)$one;
	  if( $one > 0 ) $tmp[] = $one;
	}
	if( count($tmp) ) $this->_data[$key] = $tmp;
      }
      break;

    case 'activity':
    case 'activityparent':
      $value = (int)$value;
      $value = max(1,$value);
      $this->_data[$key] = $value;
      break;

    case 'timelimit':
      // positive value is absolute time from epoch
      // negative value is relative to now.
      $value = (int)$value;
      if( $value < 0 ) $value = time() - ($value * -1);
      $this->_data[$key] = $value;
      break;

    case 'limit':
      $value = (int)$value;
      $value = max(1,$value);
      $value = min(10000,$value);
      $this->_data[$key] = $value;
      break;

    case 'offset':
      $value = (int)$value;
      $value = max(0,$value);
      $this->_data[$key] = $value;
      break;

    case 'sortby':
      if( !in_array($value,self::$_sortings) ) {
	throw new Exception('Attempt to set invalid sorting into cgsa_checkin_query: '.$value);
      }
      $this->_data[$key] = $value;
      break;

    case 'sortorder':
      switch( strtoupper($value) ) {
      case 'ASC':
      case 'DESC':
	$value = strtoupper($value);
	$this->_data[$key] = $value;
	break;

      default:
	throw new Exception('Attempt to set invalid sort order into cgsa_checkin_query');
      }
      break;

    case 'owner':
      if( isset($this->_data['owners']) ) unset($this->_data['owners']);
      $this->_data[$key] = $value;
      break;

    case 'owners':
      if( is_array($value) && count($value) ) {
	if( isset($this->_data['owner']) ) unset($this->_data['owner']);
	$this->_data[$key] = $value;
      }
      break;
    }
  }

  public function offsetExists($key)
  {
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to retrieve invalid value from cgsa_checkin_query');
    }
    if( isset($this->_data[$key]) ) return TRUE;
    return FALSE;
  }

  public function offsetUnset($key)
  {
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to set invalid key into cgsa_checkin_query');
    }
    if( isset($this->_data[$key]) ) unset($this->_data[$key]);
  }

  public function get_params()
  {
    return $this->_data;
  }

  public function &execute()
  {
    $rs = new cgsa_checkin_resultset($this);
    return $rs;
  }
} // end of class

#
# EOF
#
?>