<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_checkin_pagination 
{
  private $_id = 'cgsa_';
  private $_action = 'default';
  private $_returnid;
  private $_query;
  private $_rs;
  private $_extraparms;
  private $_inline;
  private $_npages;

  public function __construct(cgsa_checkin_query $query, cgsa_checkin_resultset $rs)
  {
    $this->_query = $query;
    $this->_rs = $rs;
    $this->_returnid = cmsms()->get_variable('content_id');
  }

  public function set_action($action) 
  {
    if( $action ) $this->_action = $action;
  }

  public function set_extraparams($params)
  {
    if( !is_array($params) ) return;

    if( !is_array($this->_extraparms) ) $this->_extraparms = array();
    foreach( $params as $key => $value ) {
      if( is_numeric($key) ) continue;
      if( is_object($value) || is_array($value) ) continue;
      $this->_extraparms[$key] = $value;
    }
  }

  public function reset_extraparams()
  {
    $this->_extraparms = null;
  }

  public function set_inline($flag = TRUE)
  {
    $this->_inline = $flag;
  }

  public function get_page_count()
  {
    if( is_null($this->_npages) ) {
      $nitems = $this->_rs->get_found_rows();
      $limit = $this->_query['limit'];
      
      $npages = (int)($nitems / $limit);
      if( $nitems % $limit ) $npages++;

      $this->_npages = $npages;
    }
    return $this->_npages;
  }

  public function get_current_page()
  {
    $o = (int)$this->_query['offset'];
    $page = (int)($o / $this->_query['limit']) + 1;
    return $page;
  }

  public function get_pagelimit()
  {
    return $this->_query['limit'];
  }

  public function get_firstpage_url()
  {
    return $this->get_page_url(1);
  }

  public function get_prevpage_url()
  {
    return $this->get_page_url($this->get_current_page()-1);
  }


  public function get_nextpage_url()
  {
    return $this->get_page_url($this->get_current_page()+1);
  }


  public function get_lastpage_url()
  {
    return $this->get_page_url($this->get_page_count());
  }

  public function get_page_url($pagenum)
  {
    $pagenum = (int)$pagenum;
    $pagenum = max(1,$pagenum);
    $pagenum = min($pagenum,$this->get_page_count());
    $parms = $this->_query->get_params();
    $parms['offset'] = ($pagenum - 1) * $this->_query['limit'];

    $mod = cms_utils::get_module('CGSocialApp');
    $url = $mod->create_url($this->_id,$this->_action,$this->_returnid,$parms,$this->_inline);
    return $url;
  }

  public function get_page_link($pagenum,$text)
  {
    $pagenum = (int)$pagenum;
    $pagenum = max(1,$pagenum);
    $pagenum = min($pagenum,$this->get_page_count());
    $parms = $this->_query->get_params();
    if( is_array($this->_extraparms) ) {
      $parms = array_merge($this->_extraparms,$parms);
    }
    $parms['offset'] = ($pagenum - 1) * $this->_query['limit'];
    
    $mod = cms_utils::get_module('CGSocialApp');
    $link = $mod->CreateLink($this->_id,$this->_action,$this->_returnid,$text,$parms,'',false,$this->_inline);
    return $link;
  }

} // end of class

#
# EOF
#
?>