<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgsa_badge_utils 
{
  private function __construct() {}

  public static function get_member_badges($uid)
  {
    $uid = (int)$uid;
    if( $uid <= 0 ) return;

    $db = cmsms()->GetDb();
    $query = 'SELECT DISTINCT badge_id FROM '.CGSOCIAL_TABLE_BADGES_USERS.' WHERE uid = ?';
    $tmp = $db->GetCol($query,array($uid));
    return $tmp;
  }

  public static function remove_badge_member(cgsa_badge& $badge,$uid)
  {
    $badge->remove_member($uid);

    // send out a notification.
    $notifier = cms_utils::get_module('CGNotifier');
    $cgsa = cms_utils::get_module('CGSocialApp');
    if( $notifier && $badge->notify_priority > 0 ) {
      $msg = new notification_message();
      $msg->module = $cgsa->GetName();
      if( $badge->notify_to == 'user' ) $msg->to = $uid;
      $msg->subject = $badge->notify_subject;
      $msg->priority = $badge->notify_priority;
      
      $smarty = cms_utils::get_smarty();
      $feu = cms_utils::get_module('FrontEndUsers');
      $smarty->assign('action','revoked');
      $smarty->assign('badge',$badge);
      $smarty->assign('uid',$uid);
      $smarty->assign('username',$feu->GetUserName($uid));
      $smarty->assign('email',$feu->GetEmail($uid));
      $msg->body = $notifier->ProcessTemplateFromData($badge->notify_tpl);

      $res = $notifier->notify($msg);
      if( !$res ) {
	audit('',$cgsa->GetName(),'Notification for badge '.$badge->name.' leaderboard ('.$badge->leaderboard_id.') failed');
      }
      else {
	audit('',$cgsa->GetName(),'Notification sent for badge '.$badge->name.' leaderboard ('.$badge->leaderboard_id.') failed');
      }
    }

    // send out the event.
    $parms = array('badge'=>$badge,'uid'=>$uid);
    cgsa_utils::send_event('OnBadgeRevoked',$parms);
  }

  public static function add_badge_member(cgsa_badge& $badge,$uid)
  {
    // add the user to the database
    $badge->add_member($uid);
    
    // send out a notification.
    $notifier = cms_utils::get_module('CGNotifier');
    $cgsa = cms_utils::get_module('CGSocialApp');
    if( $notifier && $badge->notify_priority > 0 ) {

      $msg = new notification_message();
      $msg->module = $cgsa->GetName();
      if( $badge->notify_to == 'user' ) $msg->to = $uid;
      $msg->subject = $badge->notify_subject;
      $msg->priority = $badge->notify_priority;
      
      $smarty = cms_utils::get_smarty();
      $feu = cms_utils::get_module('FrontEndUsers');
      $smarty->assign('action','granted');
      $smarty->assign('badge',$badge);
      $smarty->assign('uid',$uid);
      $smarty->assign('username',$feu->GetUserName($uid));
      $smarty->assign('email',$feu->GetEmail($uid));
      $msg->body = $notifier->ProcessTemplateFromData($badge->notify_tpl);

      $res = $notifier->notify($msg);
      if( !$res ) {
	audit('',$cgsa->GetName(),'Notification for badge '.$badge->name.' leaderboard ('.$badge->leaderboard_id.') failed');
      }
      else {
	audit('',$cgsa->GetName(),'Notification sent for badge '.$badge->name.' leaderboard ('.$badge->leaderboard_id.') failed');
      }
    }

    // send out the event.
    $parms = array('badge'=>$badge,'uid'=>$uid);
    cgsa_utils::send_event('OnBadgeAwarded',$parms);
  }

} // end of class
#
# EOF
#
?>