<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgsa_apikey implements ArrayAccess
{
  private static $_keys = array('id','apikey','appname','email','active','created','expires','modified');
  private $_data = array();


  public function __construct()
  {
    $this->_data['active'] = 1;
  }


  public function offsetSet($key,$value)
  {
    if( !in_array($key,self::$_keys) ) return;
    if( $key == 'id' ) return; // can't set the id this way.
    $this->_data[$key] = $value;
  }


  public function offsetExists($key)
  {
    if( !in_array($key,self::$_keys) ) return FALSE;
    return TRUE;
  }


  public function offsetGet($key)
  {
    if( in_array($key,self::$_keys) )
      {
	if( isset($this->_data[$key]) )
	  {
	    return $this->_data[$key];
	  }
      }
  }


  public function offsetUnset($key)
  {
    throw new Exception('Cannot unset a member of an apikey object');
  }


  private static function audit($msg)
  {
    $mod = cms_utils::get_module('CGSocialApp');
    audit('','App',$msg);
  }


  public function generate_api_key()
  {
    $this->validate(TRUE,TRUE);
    if( isset($this->_data['apikey']) && $this->_data['apikey'] != '' ) return $this->_data['apikey'];

    $db = cmsms()->GetDb();
    $query = 'SELECT apikey FROM '.CGSOCIAL_TABLE_APIKEYS;
    $keys = $db->GetCol($query);

    $count = '';
    $master = $this->_data['appname'].$this->_data['email'];
    while( $count < 100 )
      {
	$key = substr(str_shuffle(md5($master.$count)),0,8);
	if( !is_array($keys) ) return $key;
	if( !in_array($key,$keys) ) return $key;

	if( $count == '' ) $count = 1;
	$count++;
      }

    throw new Exception('No valid API key could be calculated');
  }


  public function validate($no_metadata = FALSE,$no_database = FALSE)
  {
    foreach( self::$_keys as $key )
      {
	switch( $key )
	  {
// 	  case 'id':
// 	    if( $no_metadata ) break;
// 	    if( !isset($this->_data[$key]) || ($this->_data[$key] != '' && !is_numeric($this->_data[$key])) )
// 	      {
// 		throw new Exception('Invalid data: id is '.$this->_data[$key]);
// 	      }
// 	    break;

	  case 'apikey':
	    if( $no_metadata ) break;

	  case 'appname':
	    if( !isset($this->_data[$key]) || $this->_data[$key] == '' )
	      {
		throw new Exception('Invalid data: '.$key.' is empty');
	      }
	    break;
	    
	  case 'email':
	    if( !isset($this->_data[$key]) || !is_email($this->_data[$key]) )
	      {
		throw new Exception('Invalid data: '.$key.' is invalid');
	      }
	    break;

	  case 'active':
	    $tmp = cge_utils::to_bool($this->_data[$key],TRUE);
	    if( is_null($tmp) )
	      {
		throw new Exception('Invalid data: '.$key.' is invalid');
	      }
	    break;

	  case 'expires':
	    if( !isset($this->_data[$key]) || $this->_data[$key] == '' || !is_numeric($this->_data[$key]) )
	      {
		throw new Exception('Invalid data in apikey: '.$key.' is invalid');
	      }
	  }
      }

    // database validation.
    if( $no_database ) return;

    $tmp = null;
    $db = cmsms()->GetDb();
    if( isset($this->_data['id']) && $this->_data['id'] != '' )
      {
	$query = 'SELECT id FROM '.CGSOCIAL_TABLE_APIKEYS.' WHERE (apikey = ? OR appname = ?) AND id != ?';
	$tmp = $db->GetOne($query,array($this->_data['apikey'],$this->_data['appname'],$this->_data['id']));
      }
    else
      {
	$query = 'SELECT id FROM '.CGSOCIAL_TABLE_APIKEYS.' WHERE apikey = ? OR appname = ?';
	$tmp = $db->GetOne($query,array($this->_data['apikey'],$this->_data['appname']));
      }
    if( $tmp )
      {
	throw new Exception('An item with the same name or key already exists');
      }
  }


  public function expired()
  {
    if( !isset($this->_data['expires']) ) return TRUE;
    if( $this->_data['expires'] == '' ) return TRUE;
    if( $this->_data['expires'] < time() ) return TRUE;
    return FALSE;
  }


  public function check_permission($perm)
  {
    if( !cgsa_apikey_perms::is_perm($perm) ) return FALSE;
    if( !is_array($this->_data['perms']) ) return FALSE;
    if( !in_array($perm,$this->_data['perms']) ) return FALSE;
    return TRUE;
  }

  public function set_permission($perm)
  {
    if( !$perm ) return;
    if( !cgsa_apikey_perms::is_perm($perm) ) return;
    if( !is_array($this->_data['perms']) ) $this->_data['perms'] = array();
    if( !in_array($perm,$this->_data['perms']) ) 
      $this->_data['perms'][] = $perm;
  }

  public function remove_permission($perm)
  {
    if( !$perm ) return;
    if( !cgsa_apikey_perms::is_perm($perm) ) return;
    if( !is_array($this->_data['perms']) ) return;
    if( !in_array($perm,$this->_data['perms']) ) return;
    $tmp = array();
    for( $i = 0; $i < count($this->_data['perms']); $i++ )
      {
	if( $this->_data['perms'][$i] == $perm ) continue;
	$tmp[] = $this->_data['perms'][$i];
      }
    $this->_data['perms'] = $tmp;
  }

  public function save()
  {
    $this->_data['apikey'] = $this->generate_api_key();
    $this->validate();

    $db = cmsms()->GetDb();
    $dbr = null;
    if( isset($this->_data['id']) && $this->_data['id'] )
      {
	// update
	$query = 'UPDATE '.CGSOCIAL_TABLE_APIKEYS.' 
                  SET apikey = ?, appname = ?, email = ?, active = ?,
                  expires = ?, perms = ?, modified = NOW() WHERE id = ?';
	$dbr = $db->Execute($query,array($this->_data['apikey'],$this->_data['appname'],$this->_data['email'],
					 $this->_data['active'],$this->_data['expires'], serialize($this->_data['perms']),
					 (int)$this->_data['id']));

	self::audit('Updated app '.$this->_data['appname'].'('.$this->_data['apikey'].')');
      }
    else
      {
	// insert.
	$query = 'INSERT '.CGSOCIAL_TABLE_APIKEYS." (apikey,appname,email,active,expires,perms,created,modified)
                  VALUES (?,?,?,?,?,?,?,?)";
	$dbr = $db->Execute($query,array($this->_data['apikey'],$this->_data['appname'],$this->_data['email'],
					 $this->_data['active'],$this->_data['expires'],serialize($this->_data['perms']),
					 time(),time()));
	$this->_data['id'] = $db->Insert_ID();
	$this->_data['created'] = $this->_data['modified'] = time();

	self::audit('Added app '.$this->_data['appname'].'('.$this->_data['apikey'].')');
      }
  }


  private static function &load_from_row($row)
  {
    if( !is_array($row) ) return;

    $obj = new cgsa_apikey;
    foreach( self::$_keys as $key )
      {
	if( isset($row[$key]) )
	  {
	    $obj->_data[$key] = $row[$key];
	  }
      }
    if( isset($row['perms']) && $row['perms'] )
      {
	$obj->_data['perms'] = unserialize($row['perms']);
      }

    $obj->validate(FALSE,TRUE);
    return $obj;
  }


  public static function load_by_id($id)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_APIKEYS.' WHERE id = ?';
    $tmp = $db->GetRow($query,array((int)$id));
    if( is_array($tmp) )
      {
	return self::load_from_row($tmp);
      }
  }


  public static function load_by_apikey($apikey)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_APIKEYS.' WHERE apikey = ?';
    $tmp = $db->GetRow($query,array($apikey));
    if( is_array($tmp) )
      {
	return self::load_from_row($tmp);
      }
  }


  public static function load_by_criteria($params,$as_objects = FALSE)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGSOCIAL_TABLE_APIKEYS;
    $where = array();
    $limit = -1;
    $offset = -1;
    if( is_array($params) )
      {
	foreach( $params as $key => $value )
	  {
	    $key = strtolower($key);
	    switch( $key )
	      {
	      case 'apikey':
	      case 'appname':
	      case 'email':
		if( is_array($value) )
		  {
		    for( $i = 0; $i < count($value); $i++ )
		      {
			$value[$i] = $db->qstr($value[$i]);
		      }
		    $where[] = "$key IN (".implode(',',$value).')';
		  }
		else
		  {
		    $where[] = "$key = ".$db->qstr($value);
		  }
		break;

	      case 'created':
	      case 'modified':
	      case 'expires':
		// date field
		if( is_array($value) )
		  {
		    if( count($value) == 2 )
		      {
			for( $i = 0; $i < count($value); $i++ )
			  {
			    if( !is_numeric($value[$i]) )
			      {
				$value[$i] = $db->UnixTimeStamp($value[$i]);
			      }
			  }
			$where[] = "$key BETWEEN {$value[0]} AND {$value[1]}";
		      }
		    // not 2, we don't care.
		  }
		else
		  {
		    if( !is_numeric($value) ) $value = $db->UnixTimeStamp($value);
		    if( $value[0] == '-' )
		      {
			$value = abs($value);
			$where[] = "$key <= ".$db->qstr($value);
		      }
		    else
		      {
			$where[] = "$key >= ".$db->qstr($value);
		      }
		  }
		break;

	      case 'order':
		if( in_array($key,self::$_keys) )
		  {
		    $order = $value;
		  }
		break;

	      case 'orderby':
		$value = strtolower($value);
		switch( $value )
		  {
		  case 'asc':
		  case 'desc':
		    $orderby = $value;
		    break;
		  }
		break;

	      case 'limit':
		$limit = abs((int)$limit);
		break;

	      case 'offset':
		$offset = abs((int)$limit);
		break;
	      }
	  }
      }

    // assemble query.
    if( count($where) )
      {
	$query .= ' WHERE '.implode(' AND ',$where);
      }
    if( isset($order) && $order )
      {
	$query .= ' ORDER BY '.$order;
	if( isset($orderby) && $orderby )
	  {
	    $query .= ' '.$orderby;
	  }
      }

    $res = null;
    $tmp = $db->SelectLimit( $query, $limit, $offset );
    if( !$tmp ) return $res;
    $dbr = $tmp->GetArray();
    $tmp->Close();

    if( !$as_objects )
      {
	// just return the array as rows.
	return $dbr;
      }

    $res = array();
    for( $i = 0; $i < count($dbr); $i++ )
      {
	$res[] = self::load_from_row($dbr[$i]);
      }
    return $res;
  }

  
  static public function delete_by_id($id)
  {
    $id = (int)$id;
    $db = cmsms()->GetDb();

    $query = 'DELETE FROM '.CGSOCIAL_TABLE_APIKEYS.' WHERE id = ?';
    $dbr = $db->Execute($query,array($id));

    self::audit('Deleted App '.$id);
  }
} // end of class

#
# EOF
#
?>