<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgsa_activity
{
  private static $_keys = array('id','name','parent_id','item_order','hierarchy','icon','image','description','children');
  private static $_cached_activities;
  private $_ro;
  private $_data;

  public function __construct()
  {
    $this->_data = array();
    $this->_data['parent_id'] = -1;
  }

  public function __get($key)
  {
    if( $key == 'file_location' ) {
      $config = cmsms()->GetConfig();
      $mod = cms_utils::get_module(MOD_CGSOCIALAPP);
      $loc = $config['uploads_url'].'/_'.$mod->GetName().'/activities/'.$this->id;
      return $loc;
    }

    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to retrieve invalid key '.$key.' from cgsa_activity object');
    }
    if( isset($this->_data[$key]) ) {
      return $this->_data[$key];
    }
  }
   
  public function __set($key,$value)
  {
    if( $this->_ro ) {
      throw new Exception('Attempt to adjust a cgsa_activity object in readonly mode.');
    }
    if( !in_array($key,self::$_keys) ) {
      throw new Exception('Attempt to store invalid valid into cgsa_activity object');
    }
    $this->_data[$key] = $value;
  }


  public function __isset($key)
  {
    if( !in_array($key,self::$_keys) ) return FALSE;
    if( isset($this->_data[$key]) ) return TRUE;
    return FALSE;
  }


  public function set_readonly($flag = TRUE)
  {
    $this->_ro = $flag;
  }


  public function validate()
  {
    if( $this->name == '' || $this->parent_id < -1 ) return FALSE;
    return TRUE;
  }


  public function save()
  {
    if( !$this->validate() ) return FALSE;

    if( !isset($this->_data['id']) || $this->_data['id'] < 1 ) {
      return $this->_insert();
    }
    return $this->_update();
  }

  protected function _insert()
  {
    if( $this->_ro ) {
      throw new Exception('Attempt to save a cgsa_activity object in readonly mode.');
    }

    $tmp = serialize($this->_data);

    // check if an item of the same name exists with the same parent
    $db = cmsms()->GetDb();
    $query = 'SELECT id FROM '.CGSOCIAL_TABLE_ACTIVITIES.' WHERE name = ?';
    $tmp2 = $db->GetOne($query,array($this->name));
    if( $tmp2 ) {
      throw new Exception('An activity with the same name already exists with this parent');
    }

    // get the appropriate item order (if unset)
    if( !isset($this->item_order) ) {
      $query = 'SELECT MAX(item_order) FROM '.CGSOCIAL_TABLE_ACTIVITIES.' WHERE parent_id = ?';
      $item_order = $db->GetOne($query,array($this->parent_id));
      if( !$item_order ) $item_order = 0;
      $this->item_order = $item_order+1;
    }

    // set the hierarchy.
    $query = 'INSERT INTO '.CGSOCIAL_TABLE_ACTIVITIES.' (name,parent_id,item_order,data)
       VALUES(?,?,?,?)';
    $dbr = $db->Execute($query,array($this->name,$this->parent_id,$this->item_order,$tmp));
    if( !$dbr ) {
      throw new Exception('Problem inserting activity record into database '.$db->sql.' -- '.$db->ErrorMsg());
    }
    $this->id = $db->Insert_ID();
    self::_update_hierarchy_positions();
  }

  protected function _update()
  {
    if( $this->_ro ) {
      throw new Exception('Attempt to save a cgsa_activity object in readonly mode.');
    }

    $tmp = serialize($this->_data);
    $db = cmsms()->GetDb();

    $query = 'SELECT id FROM '.CGSOCIAL_TABLE_ACTIVITIES.' WHERE name = ? AND id != ?';
    $tmp2 = $db->GetOne($query,array($this->name,$this->id));
    if( $tmp2 ) {
      throw new Exception('An activity with the same name already exists with this parent');
    }

    $query = 'UPDATE '.CGSOCIAL_TABLE_ACTIVITIES.' 
              SET name = ?, parent_id = ?, item_order = ?, data = ?
              WHERE id = ?';
    $dbr = $db->Execute($query,array($this->name,$this->parent_id,$this->item_order,$tmp,$this->id));
    if( !$dbr ) {
      throw new Exception('Problem inserting hierarchy record into database');
    }
    self::_update_hierarchy_positions();
  }

  public static function &load_by_id($id)
  {
    $tmp = self::load_all_as_array();
    $row = null;
    for( $i = 0; $i < count($tmp); $i++ ) {
      if( self::$_cached_activities[$i]['id'] == $id ) {
	$row = self::$_cached_activities[$i];
	break;
      }
    }

    if( !is_array($row) ) return;

    $obj = self::_from_array($row);
    return $obj;
  }


  public static function load_by_name($name)
  {
    $tmp = self::load_all_as_array();
    for( $i = 0; $i < count($tmp); $i++ ) {
      if( self::$_cached_activities[$i]['name'] == $name ) {
	$row = self::$_cached_activities[$i];
	break;
      }
    }

    if( !is_array($row) ) return;

    $obj = self::_from_array($row);
    return $obj;
  }

  public static function load_all_as_tree($parent_id = -1,$as_objects = TRUE)
  {
    $data = '';
    if( $as_objects ) {
      $data = self::load_all($parent_id);
    }
    else {
      $data = self::load_all_as_array($parent_id);
    }
    if( !count($data) ) return;

    for( $n = 0; $n < count($data); $n++ ) {
      if( is_object($data[$n]) ) $id = $data[$n]->id; else $id = $data[$n]['id'];
      $tmp = self::load_all_as_tree($id,$as_objects);
      if( is_array($tmp) && count($tmp) ) {
	if( $as_objects ) {
	  $data[$n]->children = $tmp;
	}
	else {
	  $data[$n]['children'] = $tmp;
	}
      }
    }
    return $data;
  }


  public static function load_all($parent_id = '')
  {
    $tmp = self::load_all_as_array($parent_id);
    if( !is_array($tmp) ) return;

    $res = array();
    for( $i = 0; $i < count($tmp); $i++ ) {
      $res[] = self::_from_array($tmp[$i]);
    }
    return $res;
  }

  public static function load_all_as_array($parent_id = '')
  {
    if( !is_array(self::$_cached_activities) ) {
      // get them all and cache em... as an array.
      $query = 'SELECT * FROM '.CGSOCIAL_TABLE_ACTIVITIES.' ORDER BY hierarchy';
      $db = cmsms()->GetDb();
      $config = cmsms()->GetConfig();
      $mod = cms_utils::get_module(MOD_CGSOCIALAPP);
      
      $tmp = $db->GetArray($query);
      if( is_array($tmp) && count($tmp) ) {
	for( $i = 0; $i < count($tmp); $i++ ) {
	  $row =& $tmp[$i];
	  $data = unserialize($row['data']);
	  if( is_array($data) ) {
	    if( isset($data['icon']) ) $row['icon'] = $data['icon'];
	    if( isset($data['image']) ) $row['image'] = $data['image'];
	    $row['description'] = $data['description'];

	    if( isset($row['image']) && $row['image'] != '' ) {
	      // add image_url field...
	      $row['image_url'] = $config['uploads_url'].'/'.$mod->GetName().'/actvities/'.$row['id'].'/'.$row['image'];
	    }
	  }
	  unset($row['data']);
	}
      }

      self::$_cached_activities = $tmp;
    }

    $res = self::$_cached_activities;
    if( $parent_id != '' ) {
      $parent_id = (int)$parent_id;
      $res = array();
	
      for( $i = 0; $i < count(self::$_cached_activities); $i++ ) {
	if( self::$_cached_activities[$i]['parent_id'] == $parent_id || $parent_id === '' ) {
	  $res[] = self::$_cached_activities[$i];
	}
      }
    }

    return $res;
  }

  public static function load_all_as_dropdown($allow_none = TRUE)
  {
    $mod = cms_utils::get_module(MOD_CGSOCIALAPP);
    $data = cgsa_activity::load_all_as_array();
    $list = array();
    if( $allow_none && count($data) ) $dropdown[-1] = $mod->Lang('none');
    for( $i = 0; $i < count($data); $i++ ) {
      $depth = count(explode('.',$data[$i]['hierarchy']));
      $dropdown[$data[$i]['id']] = str_repeat('&nbsp;',$depth-1).$data[$i]['name'];
    }
    return $dropdown;
  }

  private static function &_from_array($row)
  {
    $obj = new cgsa_activity;
    if( isset($row['data']) ) {
      $obj->_data = unserialize($row['data']);
    }
    $obj->_data['id'] = $row['id'];
    $obj->_data['name'] = $row['name'];
    $obj->_data['parent_id'] = $row['parent_id'];
    $obj->_data['item_order'] = $row['item_order'];
    $obj->_data['hierarchy'] = $row['hierarchy'];
    $obj->_data['description'] = $row['description'];
    if( isset($row['image']) ) $obj->_data['image'] = $row['image'];
    return $obj;
  }

  private static function _update_hierarchy_positions()
  {
    $db = cmsms()->GetDb();
    $query = 'UPDATE '.CGSOCIAL_TABLE_ACTIVITIES.' SET hierarchy = ? WHERE id = ?';

    $activities = self::load_all_as_array();

    // nullify all hierarchies
    for( $i = 0; $i < count($activities); $i++ ) {
      $activities[$i]['hierarchy'] = '';
    }

    // for each activity ...
    for( $i = 0; $i < count($activities); $i++ ) {
      $hierarchy = '';
      $row = $activities[$i];
      $cpi = $row['id'];

      while( $cpi > -1 ) {
	// build the hierarchy back up to the top.
	// get row with id if 'cpi'
	$row2 = '';
	for( $j = 0; $j < count($activities); $j++ ) {
	  if( $activities[$j]['id'] != $cpi ) continue;
	  $row2 = $activities[$j];
	  break;
	}
	if( $row2 ) {
	  $hierarchy = str_pad($row2['item_order'], 5, '0', STR_PAD_LEFT).'.'.$hierarchy;
	  $cpi = $row2['parent_id'];
	}
	else {
	  $cpi = 0;
	}
      }

      $hierarchy = rtrim($hierarchy,'.');
      $activities[$i]['hierarchy'] = $hierarchy;
      $db->Execute($query,array($hierarchy,$activities[$i]['id']));
    }
  }

  public function delete_files()
  {
    if( $this->_ro ) {
      throw new Exception('Attempt to adjust a cgsa_activity object in readonly mode.');
    }

    if( $this->id < 1 ) return;
    if( $this->image == '' ) return;

    $config = cmsms()->GetConfig();
    $mod = cms_utils::get_module('CGSocialApp');
    $destdir = cms_join_path($config['uploads_path'],'_'.$mod->GetName(),'activities',$this->id);

    $tmp = array('preview_'.$this->image,'thumb_'.$this->image,$this->image);
    foreach( $tmp as $one ) {
      $fn = cms_join_path($destdir,$one);
      @unlink($fn);
    }
    $this->image = '';
  }


  public function delete()
  {
    if( $this->_ro ) {
      throw new Exception('Attempt to adjust a cgsa_activity object in readonly mode.');
    }

    if( $this->id == '' )
      throw new Exception('Attempt to Delete an invalid activity');
    $db = cmsms()->GetDb();

    $this->delete_files();

    // update any direct children to have -1 as a parent id.
    $query = 'UPDATE '.CGSOCIAL_TABLE_ACTIVITIES.' SET parent_id = ? WHERE parent_id = ?';
    $dbr = $db->Execute($query,array(-1,$this->id));

    // delete the activity record itself (referential integrity to other tables may be broken)
    $query = 'DELETE FROM '.CGSOCIAL_TABLE_ACTIVITIES.' WHERE id = ?';
    $dbr = $db->Execute($query,array($this->id));

    $this->_update_hierarchy_positions();

    // todo: send a message/event
  }

  public static function bulk_update($list)
  {
    if( !is_array($list) || count($list) == 0 ) return;

    // build the query from the first element
    $rec = $list[0];
    $tmp1 = array();
    $query = 'UPDATE '.CGSOCIAL_TABLE_ACTIVITIES;
    if( isset($rec['parent_id']) ) {
      $tmp1[] = 'parent_id = ?';
      $tmp2[] = 'parent_id';
    }
    if( isset($rec['name']) ) {
      $tmp1[] = 'name = ?';
      $tmp2[] = 'name';
    }
    if( isset($rec['item_order']) ) {
      $tmp1[] = 'item_order = ?';
      $tmp2[] = 'item_order';
    }
    
    if( !count($tmp1) ) return;

    // in a loop, build and execute the queries.
    $db = cmsms()->GetDb();
    $query .= ' SET '.implode(',',$tmp1).' WHERE id = ?';
    foreach( $list as $rec ) {
      $parms = array();
      foreach( $tmp2 as $fld ) $parms[] = $rec[$fld];
      $parms[] = $rec['id'];

      // ready to execute.
      $dbr = $db->Execute($query,$parms);
    }

    self::_update_hierarchy_positions();
  }
} // end of class

#
# EOF
#
?>
