<h3>What Does This Do?</h3>
<p>This module is a social application framework built on top of CMSMS.  It is designed to allow mobile developers to build small to medium scale specialized social applications and websites.  it can be used for allowing mobile users to add or edit location information, manage friendships, and create time related information related to a location.</p>
<p>This module provides a RESTFUL API to allow sending and receiving social data, and for displaying some of that data on the CMSMS powered website.</p>
<p>This module does not have much functionality of its own, it is designed to primarly work in conjunction with a custom developed mobile application (which you are free to create).</p>
<h3>Features:</h3>
<ul>
 <li>One Install - Many APPS
   <ul>
     <li>Unique API Keys, with expiry</li>
     <li>Advanced Security.</li>
     <li>Atomic permissions model.</li>
   </ul>
 </li>
 <li>Users API
   <p>The Users API allows querying, registering, logging in, logging out, and modifying of a user account.  It uses the FrontEndUsers module for authentication.  This is the primary mechanism for authenticating to the system (other than the API key).  Only authenticated users can create locations, add checkings, edit friend relationships etc.</p>
   <ul>
     <li>Register a new user <em>(REGISTER)</em></li>
     <li>Login an existing user <em>(LOGIN)</em></li>
     <li>PING the server (keep login session alive) <em>(PING)</em></li>
     <li>Logout from the system <em>(LOGOUT)</em></li>
     <li>Retrieve user information (current user) <em>(GETINFO)</em></li>
     <li>Retrieve user additional properties (current user) <em>(PROPERTIES)</em></li>
     <li>Set user information or properties (current user) <em>(SETPROPS)</em></li>
     <li>Retrieve user history (current user) <em>(HISTORY)</em></li>
     <li>List Users (with basic filtering) <em>(LIST)</em></li>
     <li><span style="color: red;">TODO:</span> Delete current user <em>(DELETE)</em></li>
   </ul>
 </li>
 <li>Locations API
     <p>The locations mechanism uses the CompanyDirectory module to manage and store data.  Locations added via the RESTFUL api can be listed using the normal mechanisms in CompanyDirectory. Some of the basic features are:</p>
  <ul>
     <li>Feature: Rate Limiting</li>
     <li>Feature: Photo Uploads</li>
     <li>Feature: Optional Approval</li>
     <li>Retrieve hierarchy list <em>(HIERARCHY API Function)</em></li>
     <li>Retrieve category list <em>(CATEGORIES API Function)</em></li>
     <li>List locations (with filtering) <em>(LIST API Function)</em></li>
     <li>Get information about a specific location <em>(GET API Function)</em></li>
     <li>Add a location <em>(ADD API Function)</em></li>
     <li>Edit information about a location <em>(EDIT API Function)</em></li>
     <li>Attach a photo to a location <em>(PHOTOUPLOAD API Function)</em></li>
     <li>Remove a photo from a location <em>(PHOTODELETE API Function)</em></li>     
     <li><span style="color: red;">TODO:</span> Delete a location <em>(DELETE)</em></li>
  </ul>
 </li>
 <li>Checkins API
  <p>The Checkins mechanism allows a logged in user to say that they were AT a specific location at a specific time.</p>
  <ul>
     <li>Feature: Activity capabilities.</li>
     <li>Feature: Optional Approval</li>
     <li>Feature: Enhanced security</li>
     <li>Feature: Rate Limiting and Spam protection</li>
     <li>Add a checkin <em>(ADD API Function)</em></li>
     <li>Retrieve a single checkin <em>(GET API Function)</em></li>
     <li>Delete a single checkin <em>(DEL API Function)</em></li>
     <li>Approve a draft checkin <em>(APPROVE API Function)</em></li>
     <li>Edit a single checkin <em>(EDIT API Function)</em></li>
     <li>Find checkins for a certain location (with pagination and time limiting) <em>(BYLOCATION API Function)</em></li>
     <li>Find checkins from friends (with pagination and time limiting) <em>(FRIENDS API Function)</em></li>
     <li>Find checkins by activity (with pagination and time limiting) <em>(GET API Function)</em></li>
  </ul>
 </li>
 <li>Favorites API
     <p>The favorites API adds the ability for logged in users to manage a list of &quot;favorite&quot; locations.  The following functions are supported:</p>
     <ul>
     <li>List all favorite location ids</li>
     <li>Add a location to the favorites list.</li>
     <li>Delete a location to the favorites list.</li>
     <li>Test if a location is a favorite.</li>
     </ul>
 </li>
 <li>Friends API
  <p>The friends mechanism adds the social part to the API.  Users can manage a friends list, approve and deny friend requests, and see what their friends are doing with the application.</p>
  <ul>
     <li>List Friends (for the current user) <em>(LIST API Function)</em></li>
     <li>Remove a current friend from the list (for the current user) <em>(DEL API Function)</em></li>
     <li>Suggest Friends (for the current user) <em>(SUGGEST API Function)</em></li>
     <li>View a list of friendship requests (for the current user) <em>(REQUESTLIST API Function)</em></li>
     <li>Send a friend request to another user <em>(REQUEST API Function)</em></li>
     <li>Approve a friend request from another user <em>(APPROVE API Function)</em></li>
     <li>Deny a friend request from another user <em>(DENY API Function)</em></li>
  </ul>
 </li>
 <li>Leaderboard / Badges
   <p>The Leaderboard / Badges functionality allows rewarding users for using your application.</p>
   <ul>
   <li>Create numerous leaderboards based on numerous criterium, including location and activity.</li>
   <li>Scores for each leaderboard are calculated regularly from unprocessed checkins, using the CGJobmgr</li>
   <li>Create numerous badges on any leaderboard.</li>
   <li>Badges can be unique (only one member can posess the badge at any one time), or non unique allowing numerous members.</li>
   <li>Badges are based on score from a leaderboard, and can have a minimum, and optionally a maximum score.</li>
   </ul>
 </li>
 <li>Notifications and Events:
   <p>This module is capabile of sending notifications (using the CGNotifier and other supporting modules) to publish when badges are awarded.  Notifications can be sent via SMS <em>(CGSMS)</em>, Twitter <em>(CGTwitter)</em>, Email <em>(Built into CGNotifier)</em> and Facebook <em>(CGFBApp)</em></p>
   <p>The module sends events logical places in the code allowing other modules or user defined tags to perform more functionality.</p>
 </li>
</ul>
<h3>How do I use it:</h3>
<p><strong>Note:</strong> This module is for advanced users only.  In order to properly use this module you will probably have to create (or have created) A mobile client that interacts with this modules RESTFUL API. A Sample PHP command line client application is included for testing purposes. The reference document for the RESTFUL API can be found in a PDF file in the docs directory.</p>
<p>After installation and configuration of this module, the FrontEndUsers module, The CompanyDirectory module, and any other dependants there are a few steps to follow:</p>
<ul>
  <li>Create an API key</li>
  <li>Modify the client.php and insert the API key created above into the appropriate section of the code.</li>
  <li>Create at least one user in FEU</li>
  <li>Create at least one public location in CompanyDirectory, for testing</li>
  <li>Launch the php client application.</li>
</ul>
<br/>
<h4>Displaying data on the website frontend</h4>
  <ul>
  <li><strong style="color: green;">Displaying checkins:</strong>
    <p>The default action of the module will display checkins.  The display of checkin data can be altered by passing parameters such as location,activity,timelimit,owner,limit,offset,sortby and sortorder to the tag.  The default behavior is to display a list of the most recent checkins.</p>
    <p>The default checkin list template will provide links to a user detail view, a location detail view, and where possible an activity detail view.</p>
    <p>i.e: <code>{cms_module module=CGSocialApp}</code></p>
    <p><strong>Tip:</strong> it is a good idea to modify the apropriate CompanyDirectory detail view template to display a list of checkins for the location.  i.e: <code>{cms_module module=CGSocialApp location=$entry->id}</code></p>
    <p><strong>Tip:</strong> it is a good idea to modify the FrontEndUsers view user <em>(or a CGUserDirectory detail template)</em> template to display a list of checkins for the user.  i.e: <code>{cms_module module=CGSocialApp owner=$userinfo.id}</code></p>
  </li>
  
  <li><strong style="color: green;">Displaying activities:</strong>
    <p>The list_activities action can be used to display a hierarchical list of activities in summary form.  And from there a detail view can be displayed of a single activity.</p>
    <p>i.e: <code>{cms_module module=CGSocialApp action=list_activities}</code></p>
  </li>

  <li><strong style="color: green;">Displaying a single activity:</strong>
  <p>The view_activity action can be used to display a detail view of a single activity. The default activity view will also display a list of recent checkins for that activity.</p>
    <p>i.e: <code>{cms_module module=CGSocialApp action=view_activity activity=##}</code></p>
  </li>
  </ul>
<h4>Friend Management:</h4>
  <p>It is possible to allow users to manage create friend requsts, and approve or deny incoming friend requests using the various smarty plugins and actions of this module:</p>
  <ul>
    <li><span style="color: green;">Create <em>(or remove)</em> a Friend Request or Friendship:</span>
		   <p><code>{cgsa_friendreq_link}</code> Requires the user to be logged in to FEU, but will display a link to initiate, or remove a friend request link to a particular user.  As well, if the targetted user is already a friend, a link will be generated allowing the friend relationship to be removed.  This tag can be added to the CGUSerDirectory detail view template, or to the FrontEndUsers view user template.</p>
      <p>If the selected user is not a friend, the link will, when clicked upon will generate a form <em>(action=friendreq)</em>.  The form asks the user to confirm the sending of the friend request.  Once confirmed <em>(or cancelled)</em> the user is redirected back to the originating URL.</p>
      <p>i.e: <code>{cgsa_friendreq_link user=$user.id}</code></p>
    </li>
    <li><span style="color: green;">Display a list of pending Requests:</span>
      <p><code>{cms_module module=CGSocialApp action=friendreqlist}</code> is an action that will display a list of all of the pending friend requests and allow approving, or denying them.  This plugin will display nothing if the user is not loggedin to FrontEndUsers.  This plugin can be called from the bottom of the FrontEndUsers change settings form,</p>
    </li>
  </ul>
<h4>Favorites Management:</h4>
   <p>This module allows users to maintain a list of favorite locations.  Users can view their favorites in a list, and can interact with favorite locations in various ways.</p>
  <ul>
    <li><span style="color: green;">Adding or removing a Favorite</span>
      <p><code>{cgsa_toggle_favoritelink location=$location_id}</code> will display a link allowing the user to either add the selected location as a favorite, or remove it.  It is best called from within the CompanyDirectory detail template, but may also be called from within the summary template.</p>
    </li>
    <li><span style="color: green;">Viewing All Favorites</span>
      <p>It is possible to display a summery view of all locations that are in a users favorites list.  The favorites list is simply a list of integer location identifiers, and retrieving a favorites list requres that the user be logged in to FEU.  Therefore the code below works best when displayed on a protected page (or surrounded by customcontent logic).</p>
      <pre>{cgsa_get_favorites assign='myfavs'}
{assign var='myfavs' value=','|implode:$myfavs}
{CompanyDirectory idlist=$myfavs}</pre>
      </pre>
    </li>
  </ul>
<h3>Smarty Functions</h3>
<ul>
  <li>{cgsa_getactivity activity=## [assign=##]}
    <p>Retrieve the information for a specific activity</p>
    <p>Options:</p>
    <ul>
       <li><strong>activity <em>(required)</em></strong> - The integer activity id.  Note, aid is an alias for the activity argument.</li>
       <li>assign <em>(optional)</em> - Assign the output to the named smarty variable.</li>
    </ul>
       <p>Example: <code>{cgsa_getactivity activity=1 assign=tmp}&lt;pre&gt;{$tmp|@print_r}&lt;pre&gt;</code></p>
  </li>

  <li>{cgsa_selactivity [prefix=string] name=string [id=string] [selected=int] [none=int] [assign=string]}
    <p>Provide a dropdown list to select an activity.</p>
    <p>Options:</p>
      <ul>
       <li><strong>name <em>(required)</em></strong> - A name for the select element.</li>
       <li>prefix <em>(optional)</em> - A prefix for the name of the select element. The prefix is usually used when building forms inside of a module action template.</li>
       <li>id <em>(optional)</em> - An id for the select element.</li>
       <li>class <em>(optional)</em> - A class attribute for the select element.</li>
       <li>selected <em>(optional)</em> - The integer id of the activity to be selected by default.</li>
       <li>assign <em>(optional)</em> - Assign the output to the named smarty variable.</li>
      </ul>
    <p>Example: <code>{cgsa_seleactivity name=sel_activity}</code></p>
  </li>

  <li>{cgsa_get_favorites [assign=string}
    <p>Return a list of favorite location ids. <em>(if any.)</em></p>
    <p>Options:</p>
    <ul>
       <li>assign <em>(optional)</em> - Assign the output to the named smarty variable.</li>
    </ul>
    <p>Example: <code>{cgsa_get_favorites assign=tmp}{debug_display($tmp)}</code></p>
  </li>

  <li>{cgsa_get_friends [assign=string}
    <p>Return a list of friend user ids. <em>(if any.)</em></p>
    <p>Options:</p>
    <ul>
       <li>assign <em>(optional)</em> - Assign the output to the named smarty variable.</li>
    </ul>
    <p>Example: <code>{cgsa_get_friends assign=tmp}{debug_display($tmp)}</code></p>
  </li>

  <li>{cgsa_togglefavorite_link}
    <p>Create a link to an action that will toggle the selected location as a favorite. This plugin requires the user to be logged in to FEU (if the user is not no output will be displayed).  And allows the currently logged in user to toggle a location as a favorite or not.</p>
    <p>Under normal conditions the link created by this plugin will perform the action of selecting this item as a favorite (or unselecting it) and return to the url of the page tht the plugin was called from.</p>
    <p>Options:</p>
    <ul>
       <li><strong>location  <em>(required integer)</em></strong> - The numeric ID of the location.</li>
       <li>favtext <em>(optional string)</em> - Specify different text for the link if the item is currently not a favorite, and will be added to the favorites list.</li>
       <li>unfavtext <em>(optional string)</em> - Specify different text for the link if the item is currently not a favorite and will be removed from the favorites list.</li>
       <li>class <em>(optional string)</em> - Specify a class attribute for the link tag.</li>
       <li>id <em>(optional string)</em> - Specify a id attribute for the link tag.</li>
       <li>returnid <em>(optional integer)</em> - Specify a different returnid for the destination action and to return to.</li>
       <li>urlonly <em>(optional integer)</em> - Do not generate a link, only a URL.</li>
       <li>jsfriendly <em>(optional integer)</em> - Generate a URL that is suitable for use in javascript (ajax)</li>
       <li>noredirect <em>(optional integer)</em> - Do not redirect to the original URL.</li>
       <li>redirectcontent <em>(optional integer) - Do not redirect to the originating URL, use the returnid and redirect to the content page.</li>
       <li>assign <em>(optional string)</em> - Assign the output to the named smarty variable.</li>
    </ul>
    <p>Example: {cgsa_togglefavorite_link location=$location_id}</p>
  </li>

  <li>{cgsa_friendreq_link}
     <p>Create a link to a function that will instantiate a friend request.  This plugin will create a link to an action that provides a form.  Once selected the form will create a friend request.  If a friend request has already been sent to the user the link will allow removing the friend request.  This plugin requires the user to be logged in to the FrontEndUsers module.  If the user is not loggedin, no output will be returned.</p>
    <p>The link created by this plugin sends the user to the &quot;friendreq&quot; action which displays a form allowing the user to confirm the friendship request.  Under normal usage if the form is submitted or cancelled the user will be redirected back to the URL where the link is displayed.</p>
    <p>Options:</p>
    <ul>
       <li><strong>user <em>(required integer)</strong> - The userid that we want to send a frend request to.</li>
       <li>reqtext <em>(optional string) - Use alternate text for the link when creating a friend request.</li>
       <li>rmreqtext <em>(optional string) - Use alternate text for the link when removing an existing friend request.</li>
       <li>class <em>(optional string)</em> - Specify a class attribute for the link tag.</li>
       <li>id <em>(optional string)</em> - Specify a id attribute for the link tag.</li>
       <li>returnid <em>(optional integer)</em> - Specify a different returnid on which to display the friendreq action, and return to.</li>
       <li>urlonly <em>(optional integer)</em> - Do not generate a link, only a URL.</li>
       <li>jsfriendly <em>(optional integer)</em> - Generate a URL that is suitable for use in javascript (ajax)</li>
       <li>noredirect <em>(optional integer)</em> - Do not redirect to the original URL.</li>
       <li>redirectcontent <em>(optional integer) - Do not redirect to the originating URL, use the returnid and redirect to the content page.</li>
       <li>template <em>(optional string></em> - Specify the name of a non standard &quot;Friend Request Template&quot; to use when creating the friend request form.</li>
       <li>assign <em>(optional string)</em> - Assign the output to the named smarty variable.</li>
    </ul>
    <p>Example: {cgsa_friendreq_link user=$some_userid}</p>
  </li>
</ul>

<h3>Requirements</h3>
<ul>
  <li>FEU - Login more than once must be enabled.</li>
  <li>Pretty URLS (mod_rewrite or internal) must be configured.</li>
  <li>The mobile client must have cookies capabilities.</li>
  <li>The CGJobMgr module is required for the badge functionalities. We recommend that leaderboards be updated more frequently than badges.  But no more than 3 or 4 times per hour.  Ideal intervals are approximately 20 minutes to update leaderboards, and 30 minutes for updating badges.</li>
  <li>The default (sample) templates take advantage of the {module_action_link} plugin from the CGSimpleSmarty library.</li>
  <li>The CGFavs module is required for favorites management.</li>
  <li>Numerous fields may be required in the CompanyDirectory and/or FEU modules to allow certain functionality.  i.e: An Album field is required in the CompanyDirectory module to allow the PHOTOUPLOAD action to work.</p>
  <li>The sample PHP client relies on the curl php extensions.</li>
  <li>For Notifications to work the CGNotifier module, and other supporting modules like (CGTweet, and CGSMS) are needed, and must be properly configured. Addtionally, the user must have created a notifications profile.</li>
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit calguy\'s
module homepage at <a href="http://calguy1000.com">calguy1000.com</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>