<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

//
// initialize
//


//
// handle form data
//
if( isset($params['submit_settings']) ) {
  $this->SetPreference('friendlyname',trim($params['friendlyname']));
  $this->SetPreference('locationrequired',(int)$params['locationrequired']);
  if( isset($params['checkinratelimiting']) ) {
    $this->SetPreference('checkinratelimiting',implode(',',$params['checkinratelimiting']));
  }
  $this->SetPreference('checkinratelimiting_bylocation',trim($params['checkinratelimiting_bylocation']));
  $this->SetPreference('checkinratelimiting_bytime',trim($params['checkinratelimiting_bytime']));
  if( isset($params['cd_categories_approvedcheckins']) ) {
    $this->SetPreference('cd_categories_approvedcheckins',serialize($params['cd_categories_approvedcheckins']));
  }
  else {
    $this->SetPreference('cd_categories_approvedcheckins','');
  }
  $this->SetPreference('cd_approve_pwfield',(int)$params['cd_approve_pwfield']);
  $this->SetPreference('cd_approve_userfield',(int)$params['cd_approve_userfield']);
}

//
// give verything to smarty
//
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_settings'));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('friendlyname',$this->GetPreference('friendlyname'));

$smarty->assign('locationrequired',$this->GetPreference('locationrequired',0));
$smarty->assign('checkinratelimiting',explode(',',$this->GetPreference('checkinratelimiting')));
$smarty->assign('checkinratelimiting_options',
		array('bylocation'=>$this->Lang('checkinratelimiting_bylocation'),
		      'bytime'=>$this->Lang('checkinratelimiting_bytime')));
$smarty->assign('checkinratelimiting_bylocation',$this->GetPreference('checkinratelimiting_bylocation',1));
$smarty->assign('checkinratelimiting_bytime',$this->GetPreference('checkinratelimiting_bytime',10));

// CompanyDirectory Categories
$tmp = cd_utils::get_categories(TRUE,TRUE);
if( is_array($tmp) && count($tmp) ) {
  $smarty->assign('cd_categories',$tmp);
 }

$tmp = $this->GetPreference('cd_categories_approvedcheckins');
if( $tmp ) $tmp = unserialize($tmp); else $tmp = array();
$smarty->assign('cd_categories_approvedcheckins',$tmp);

// CompanyDirectory fielddefs
$tmp = cd_utils::get_fielddefs(FALSE,FALSE);
if( is_array($tmp) && count($tmp) ) {
  $tmp2 = array();
  $tmp2[-1] = $this->Lang('none');
  for( $i = 0; $i < count($tmp); $i++ ) {
    if( $tmp[$i]['type'] != 'textbox' ) continue;
    if( $tmp[$i]['public'] ) continue;
    $tmp2[$tmp[$i]['id']] = $tmp[$i]['name'];
  }
  if( count($tmp2) ) {
    $smarty->assign('cd_fielddefs',$tmp2);
    $smarty->assign('cd_approve_pwfield',$this->GetPreference('cd_approve_pwfield',-1));
    $smarty->assign('cd_approve_userfield',$this->GetPreference('cd_approve_userfield',-1));
  }
}

echo $this->ProcessTemplate('admin_settings_tab.tpl');

#
# EOF
#
?>