<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$checkin = null;
$company = null;
$activity = null;
$feu = null;
$user = null;
$uid = null;

try {
  if( !isset($params['checkin']) ) throw new CMSException('Missing parameter checkin to OnCheckin Event');
  $checkin = $params['checkin'];
  if( !is_object($checkin) ) throw new CMSException('Invalid parameter checkin to OnCheckin Event');
  $feu = cms_utils::get_module('FrontEndUsers');
  $uid = $feu->LoggedInId();
  if( $uid < 1 ) throw new CMSException('OnCheckin event called, but a user is not logged in');
  if( $checkin->owner != $uid ) throw new CMSException('OnCheckin event called, but checkin owner does not match logged in user id');
  $user = $feu->GetUserInfo($uid);
  if( !is_array($user) || $user[0] == FALSE ) throw new CmsException('Could not find user with uid $uid in FrontEndUsers');
  $user = $user[1];
  unset($user['password']);

  $company = null;
  $activity = null;
  $company = cd_utils::get_company($checkin->location);
  if( $checkin->activity ) $activity = cgsa_activity::load_by_id($checkin->activity);
}
catch( Exception $e ) {
  audit('',$this->GetName(),'Problem in OnCheckin: '.$e->GetMessage());
  return;
}

$smarty = cmsms()->GetSmarty();
$smarty->assign('checkin_username',$user['username']);
$smarty->assign('checkin_user',$user);
$smarty->assign('checkin',$checkin);
if( $company ) $smarty->assign('location',$company);
if( $activity ) $smarty->assign('activity',$activity);

if( $this->GetPreference('oncheckin_sendemail') ) {

  // get the users friends.
  $friends = cgsa_friends::get_friends($uid);
  if( is_array($friends) && count($friends) ) {
    // ready to send some mails.
    $mailer = cms_utils::get_module('CMSMailer');

    foreach( $friends as $fuid ) {
      $email = $feu->GetEmail($fuid);
      if( !$email ) continue;
      $smarty->assign('username',$email); // for now.
      debug_to_log('send checkin email to '.$email);
      $subject = $this->ProcessTemplateFromData($this->GetPreference('oncheckin_mailsubject'));
      $body = $this->ProcessTemplateFromData($this->GetPreference('oncheckin_mailbody'));
      $mailer->IsHTML($this->GetPreference('oncheckin_mailhtml'));
      $mailer->SetSubject($subject);
      $mailer->SetBody($body);
      $mailer->AddAddress($email);
      if( $this->GetPreference('oncheckin_mailbulkhdrs') ) {
	$mailer->AddCustomHeader('Importance: low');
	$mailer->AddCustomHeader('precedence: bulk');
      }
      $mailer->send();
      $mailer->reset();
    }
  }
}

if( $this->GetPreference('oncheckin_sendnotif') ) {
  $notifier = cms_utils::get_module('CGNotifier');
  if( !is_object($notifier) ) {
    audit('',$this->GetName().'Notification sending is enabled, but could not get the CGNotifier module');
  }
  else {
    // send a notification
    $msg = new notification_message();
    $msg->module = $this->GetName();
    $msg->priority = $this->GetPreference('oncheckin_notifpriority');
    $msg->to = $checkin->owner;
    $msg->ischeckin = TRUE;
    $msg->subject = $this->ProcessTemplateFromData($this->GetPreference('oncheckin_notifsubject'));
    $msg->body = $this->ProcessTemplateFromData($this->GetPreference('oncheckin_notifbody'));
    if( !$notifier->notify($msg) ) {
      audit('',$this->GetName(),'Sending notification to user id '.$msg->to.' failed');
    }
  }
}

#
# EOF
#
?>