<?php

function users_process_commands($cmd,$opts)
{
  switch( $cmd )
    {
    case 'LOGIN':
      return user_login($opts);

    case 'ID':
      return user_id($opts);
      
    case 'REGISTER':
      return user_register($opts);

    case 'PING':
      return user_ping($opts);

    case 'PROPS':
      return user_getproperties($opts);

    case 'INFO':
      return user_getinfo($opts);

    case 'SETPROP':
      return user_setprops($opts);

    case 'LIST':
      return user_list($opts);

    case 'LOGOUT':
      return user_logout($opts);

    case 'BADGES':
      return user_badges($opts);
    }
}

function user_register($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: register username password\n
EOT;
    return TRUE;
  }

  if( count($opts) != 2 )
    {
      set_errormsg('register: insufficient arguments');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','REGISTER');
  $req->addParam('u',$opts[0]);
  $req->addParam('p',$opts[1]);
  $req->addParam('v',md5(_apikey().$opts[0].$opts[1]));
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  echo "OK\n"; // woot, done.
  return TRUE;
}


function user_login($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: login username password\n
EOT;
    return TRUE;
  }

  if( count($opts) != 2 )
    {
      set_errormsg('login: insufficient arguments');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LOGIN');
  $req->addParam('u',$opts[0]);
  $req->addParam('p',$opts[1]);
  $req->addParam('v',md5(_apikey().$opts[0].$opts[1]));
  $res = $req->execute();
  
  print_r($res);
  $tmp = json_decode($res);
  print_r($tmp);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  if( isset($tmp->data) )
    {
      set_appdata('uid',$tmp->data);
      echo "OK\n"; // woot, done.
    }
  return TRUE;
}

function user_logout($opts)
{
  if( count($opts) && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: logout
uses currently logged in uid.\n
EOT;
    return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LOGOUT');
  $req->addParam('uid',$uid);
  $req->addParam('v',md5(_apikey().$uid));
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  set_appdata('uid',-1);
  echo "OK\n"; // woot, done.
  return TRUE;
}

function user_id($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: id
returns currently logged in uid.\n
EOT;
    return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    echo "NOT LOGGED IN\n";
  else
    echo "UID is ".$uid."\n";
  return TRUE;
}

function user_ping($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: ping
a ping to the server to retain logged in status.\n
EOT;
    return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','PING');
  $req->addParam('uid',$uid);
  $req->addParam('v',md5(_apikey().$uid));
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  echo "OK\n"; // woot, done.
  return TRUE;
}


function user_getproperties($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: props
return the properties for the currently logged in user.\n
EOT;
    return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','PROPERTIES');
  $req->addParam('uid',$uid);
  $req->addParam('v',md5(_apikey().$uid));
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  print_r($tmp)."\n";
  return TRUE;
}


function user_getinfo($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: props
get the information for the currently logged in user.\n
EOT;
    return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','GETINFO');
  $req->addParam('uid',$uid);
  $req->addParam('v',md5(_apikey().$uid));
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  print_r($tmp)."\n";
  return TRUE;
}

function user_setprops($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: setprop propname=value ...
set one or more user properties.\n
EOT;
    return TRUE;
  }

  // usage: uid key=value key=value
  if( count($opts) < 1 )
    {
      set_errormsg('register: insufficient arguments');
      return FALSE;
    }
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 )
    {
      set_errormsg('Not logged in... nothing to do');
      return FALSE;
    }

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','SETPROPS');
  $req->addParam('uid',$uid);
  $req->addParam('v',md5(_apikey().$uid));
  foreach( $opts as $one )
    {
      list($k,$v) = explode('=',$one,2);
      if( !$k ) continue;
      $req->addParam($k,$v);
    }
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  print_r($tmp)."\n";
  return TRUE;
}

function user_list($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: list [prop=pattern [limit [offset]]]
list users, allows specifying a filter.\n
EOT;
    return TRUE;
  }

  // usage: [prop=pattern] [limit] [offset]
  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('Not logged in... nothing to do');
    return FALSE;
  }

  $parms = array();
  foreach( $opts as $arg ) {
    list($key,$val) = explode('=',$arg,2);
    $key = trim($key);
    $val = trim($val);

    $parms[$key] = $val;
  }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LIST');
  $req->addParam('uid',$uid);
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      switch( $key ) {
      case 'n':
      case 'o':
      case 'userpattern':
      case 'idlist':
      case 'property':
      case 'proppattern':
      case 'full':
	$req->addParam($key,$value);
	break;
      }
    }
  }
  $res = $req->execute();
  
  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }
  print_r($tmp)."\n";
  return TRUE;
}

function user_badges($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: badges [uid]
get the information for the currently logged in user, or the specified user.\n
EOT;
    return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( count($opts) == 1 ) {
    $uid = (int)$opts[0];
  }
  if( $uid <= 0 ) {
    set_errormsg('Not logged in, and no uid specified... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setMethod('GET');
  $req->setTarget(BASE_URL.'/users');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','BADGES');
  $req->addParam('uid',$uid);
  $req->addParam('v',md5(_apikey().$uid));
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' )
    {
      $msg = $tmp->_status;
      if( isset($tmp->_message) )
	{
	  $msg .= ': '.$tmp->_message;
	}
      set_errormsg($msg);
      return FALSE;
    }
  print_r($tmp)."\n";
  return TRUE;
}

?>