<?php

function favorites_process_commands($cmd,$opts)
{
  switch( $cmd ) {
  case 'ADD':
    return favorites_add($opts);

  case 'LIST':
    return favorites_list($opts);

  case 'DEL':
  case 'DELETE':
    return favorites_delete($opts);

  case 'ISFAVORITE':
    return favorites_isfavorite($opts);
  }
}

function favorites_list($opts)
{
  if( count($opts) > 0 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: list
EOT;
  return TRUE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('locations_add: Not logged in... nothing to do');
    return FALSE;
  }

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/favorites');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LIST');
  $req->addParam('owner',(int)$uid);
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

function favorites_add($opts)
{
  if( count($opts) > 0 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: add location
  integer location id.
EOT;
  return TRUE;
  }

  if( count($opts) != 1 ) {
    set_errormsg('locations_add: insufficient arguments');
    return FALSE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('locations_add: Not logged in... nothing to do');
    return FALSE;
  }

  $parms['location'] = (int)$opts[0];
  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/favorites');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','ADD');
  $req->addParam('owner',(int)$uid);
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      $req->addParam($key,$value);
    }
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

function favorites_delete($opts)
{
  if( count($opts) > 0 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: del location
  integer location id.
EOT;
  return TRUE;
  }

  if( count($opts) != 1 ) {
    set_errormsg('locations_add: insufficient arguments');
    return FALSE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('locations_add: Not logged in... nothing to do');
    return FALSE;
  }

  $parms['location'] = (int)$opts[0];

  $req = new cms_http_request();
  $req->setMethod('POST');
  $req->setTarget(BASE_URL.'/favorites');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','DELETE');
  $req->addParam('owner',(int)$uid);
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      $req->addParam($key,$value);
    }
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

function favorites_isfavorite($opts)
{
  if( count($opts) > 0 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: isfavorite location
  integer location id.
EOT;
  return TRUE;
  }

  if( count($opts) != 1 ) {
    set_errormsg('locations_add: insufficient arguments');
    return FALSE;
  }

  $uid = get_appdata('uid',-1);
  if( $uid <= 0 ) {
    set_errormsg('locations_add: Not logged in... nothing to do');
    return FALSE;
  }

  $parms['location'] = (int)$opts[0];

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/favorites');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','ISFAVORITE');
  $req->addParam('owner',(int)$uid);
  if( count($parms) ) {
    foreach( $parms as $key => $value ) {
      $req->addParam($key,$value);
    }
  }
  $res = $req->execute();

  $tmp = json_decode($res);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); echo "\n"; // woot done.
  return TRUE;
}

?>