<?php

//
// required classes
//
require_once(dirname(__FILE__).'/class.cms_http_request.php');  

//
// functions
//
function cls()
{
  $clearscreen = chr(27)."[H".chr(27)."[2J";
  print $clearscreen;
}

function startswith($haystack,$needle)
{
  if( substr($haystack,0,strlen($needle)) == $needle ) return TRUE;
  return FALSE;
}

function _apikey()
{
  global $_apikey;
  return $_apikey;
}

function set_appdata($k,$v)
{
  global $_appdata;
  if( !is_array($_appdata) ) $_appdata = array();
  $_appdata[$k] = $v;
}

function get_appdata($k,$dflt = '')
{
  global $_appdata;
  if( !is_array($_appdata) ) return $dflt;
  if( !isset($_appdata[$k]) ) return $dflt;
  return $_appdata[$k];
}

function set_errormsg($str)
{
  global $_errmsg;
  $_errmsg = $str;
}

function get_errormsg($clear = true)
{
  global $_errmsg;
  $tmp = $_errmsg;
  if( $clear )  $_errmsg = '';
  return $tmp;
}

function help($opt = '')
{
  if( !$opt )
    {
      echo 'here we should output global help'."\n";
    }
  else
    {
      echo "DEBUG: help for ".$opt."\n";
    }
}

function available_commands($as_string = TRUE)
{
  global $_scope;
  global $_global_commands;

  $tmp = $_scope[count($_scope)-1];
  if( !is_array($tmp) )
    {
      $tmp = explode(',',$tmp);
    }
  $tmp = array_merge($tmp,explode(',',$_global_commands));
  if( $as_string )
    {
      $tmp = implode(',',$tmp);
    }
  return $tmp;
}

function get_level()
{
  global $_prompt;
  $prompt = $_prompt[count($_prompt)-1];
  return $prompt;
}


function process_level_command($cmd,$opts)
{
}

function read_command()
{
  global $_scope;
  global $_filehandle;
  $line = '';

  $n = count($_scope);
  $prompt = get_level().': ';

  while( $line == '' )
    {
      if( $_filehandle ) {
	$line = trim(fgets($_filehandle));
	echo $line."\n";
	if( feof($_filehandle) ) $line = 'QUIT';
      }
      else {
	$line = readline($prompt); readline_add_history($line);
      }

      if( $line == '' ) continue;
      // got input split it into command and arguments.
      $tmp = parse_opts($line);
      $tmp[0] = strtoupper($tmp[0]);
      if( $tmp[0] == '?' )
	{
	  echo "Available Commands: ".available_commands()."\n";
	  $line = '';
	}
      else if( !in_array($tmp[0],available_commands(FALSE)) )
	{
	  echo "Command not in scope (".available_commands().")\n";
	  $line = '';
	}
      else
	{
	  return $tmp;
	}
    }
}

// takes an array of arguments, and re-parses them including a delimiter allowed to group arguments
function parse_opts($str)
{
  $specialchars = array('\'','"');
  $delim = ' ';

  $outa = array();
  $prevchar = '';
  $tstr = '';
  $instr = FALSE;
  
  for( $i = 0; $i < strlen($str); $i++ )
    {
      $char = $str[$i];
      if( in_array($char,$specialchars) )
	{
	  if( $prevchar != '\\' ) 
	    $instr = !$instr;
	  else
	    $tstr .= $char;
	}
      else if( $char == $delim && $instr == FALSE )
	{
	  $outa[] = $tstr;
	  $tstr = '';
	}
      else if ( $char != '\\' || ($char == '\\' && $prevchar == '\\') )
	{
	  $tstr .= $char;
	}
      $prevchar = $char;
    }
  if( $tstr != '' ) $outa[] = $tstr;
  return $outa;
}


function command_process_commands($cmd,$opts)
{
  global $_scope;
  global $_prompt;

  $res = '';
  switch( $cmd )
    {
    case 'STATUS':
      die('todo: status');
      break;

    case 'CHECKINS':
      // goto checkins scope
      require_once(dirname(__FILE__).'/client_checkins.php');
      $_scope[] = 'UP,ADD,EDIT,GET,DEL,BYLOCATION,QUIT,CLS,MYLOCATION,BYFRIENDS';
      $_prompt[] = 'CHECKINS';
      return TRUE;
     
    case 'USERS':
      require_once(dirname(__FILE__).'/client_user.php');
      $_scope[] = 'UP,REGISTER,LOGIN,ID,LIST,LOGOUT,PING,PROPS,INFO,QUIT,SETPROP,STATUS,CLS,BADGES';
      $_prompt[] = 'USERS';
      return TRUE;

    case 'SOCIAL':
      require_once(dirname(__FILE__).'/client_social.php');
      $_scope[] = 'UP,LIST,GETKEY,SETKEY';
      $_prompt[] = 'SOCIAL';
      return TRUE;

    case 'FRIENDS':
      require_once(dirname(__FILE__).'/client_friends.php');
      $_scope[] = 'UP,QUIT,CLS,LIST,DEL,REQUEST,APPROVE,REQUESTLIST,DENY';
      $_prompt[] = 'FRIENDS';
      return TRUE;

    case 'ACTIVITIES':
      require_once(dirname(__FILE__).'/client_activities.php');
      $_scope[] = 'UP,LIST,GET,QUIT,CLS';
      $_prompt[] = 'ACTIVITIES';
      return TRUE;
      
    case 'LEADERBOARDS':
      require_once(dirname(__FILE__).'/client_leaderboards.php');
      $_scope[] = 'UP,LIST,GET,BADGES,LEADERS,QUIT,CLS';
      $_prompt[] = 'LEADERBOARDS';
      return TRUE;
      
    case 'BADGES':
      require_once(dirname(__FILE__).'/client_badges.php');
      $_scope[] = 'UP,LIST,GET,MEMBERS,QUIT,CLS';
      $_prompt[] = 'BADGES';
      return TRUE;
      
    case 'FAVORITES':
      require_once(dirname(__FILE__).'/client_favorites.php');
      $_scope[] = 'UP,LIST,ADD,DELETE,ISFAVORITE,QUIT,CLS';
      $_prompt[] = 'FAVORITES';
      return TRUE;

    case 'LOCATIONS':
      require_once(dirname(__FILE__).'/client_locations.php');
      $_scope[] = 'UP,LIST,CATEGORIES,HIERARCHY,GET,QUIT,CLS,ADD,EDIT,PHOTOUPLOAD,PHOTODELETE,MOSTCHECKINS,MOSTFAVORITES';
      $_prompt[] = 'LOCATIONS';
      return TRUE;

    case 'LOGIN':
      // login the user
      require_once(dirname(__FILE__).'/client_user.php');
      $res = user_login($opts);
      break;

    case 'LOGOUT':
      // login the user
      require_once(dirname(__FILE__).'/client_user.php');
      $res = user_logout($opts);
      break;

    case 'CHECKIN':
      require_once(dirname(__FILE__).'/client_checkins.php');
      $res = checkins_add($opts);
      break;

    case 'MYCHECKINS':
      require_once(dirname(__FILE__).'/client_checkins.php');
      $res = checkins_mycheckins($opts);
      break;

    case 'UP':
      if( count($_scope) > 1 )
	{
	  array_pop($_scope);
	  array_pop($_prompt);
	}
      $res = TRUE;
      break;

    case 'QUIT':
      echo "EXITING\n";
      exit();
      break;

    case 'CLS':
      cls();
      $res = TRUE;
      break;
    }

  return $res;
}

//
// start sessiom
//
session_name('cgtest');
session_start();

//
// initialize variables
//
$app_done = FALSE;
$_global_commands = 'USERS,LEADERBOARDS,BADGES,LOCATIONS,FAVORITES,ACTIVITIES,CHECKINS,LOGIN,LOGOUT,QUIT,CLS,CHECKIN,MYCHECKINS,FRIENDS,SOCIAL';
$_commands = 'STATUS';
$_prompt = array('COMMAND');
$_scope[] = $_commands;
$_errmsg = '';
$_appdata = null;
$_filehandle = null;

//
// handle CLI arguments
//


// 
// handle file arguments
//
$configfile = dirname(__FILE__).'/config.php';
$script = null;
if( $argc > 1 ) {
  $args = $argv;
  while( count($args) ) {
    $arg = array_shift($args);
    switch( $arg ) {
    case '-f':
      $configfile = array_shift($args);
      break;

    default:
      $script = $arg;
      break;
    }
  }
}

if( !is_readable($configfile) ) {
  die("$confgfile not found");
}
$config = array();
include_once($configfile);
if( !isset($config['baseURL']) || $config['baseURL'] == '' ) {
  die('baseURL is undefined in the config.php file');
}
if( !isset($config['apikey']) || $config['apikey'] == '' ) {
  die('apikey is undefined in the config.php file');
}

// here we do our basic config stuff.
define('BASE_URL',$config['baseURL']);
$_apikey = $config['apikey']; // ugly, I know
define('APIKEY',$config['apikey']);

if( $scriptfile ) {
  if( !file_exists($scriptfile) ) {
    die("file $filename not found\n");
  }
  $_filehandle = fopen($scriptfile,'r');
  if( !$_filehandle ) {
    die("could not open $filename\n");
  }
}
else {
  cls();
  echo "CGSocialApp CLI Test Client\n";
  echo "-- Loaded config file $configfile\n\n";
}

while( ($_filehandle && !feof($_filehandle)) || !$app_done )
{
  // get a command.
  $res = null;
  $opts = read_command();
  if( $opts ) $command = array_shift($opts);

  $level = strtolower(get_level());
  $fn = $level.'_process_commands';
  if( function_exists($fn) )
    {
      // the function exists..
      $res = $fn($command,$opts);
      if( is_null($res) )
	{
	  if( get_level() != 'COMMAND' )
	    {
	      $res = command_process_commands($command,$opts);
	      if( is_null($res) )
		{
		  set_errormsg('Invalid command2 '.$command);
		}
	    }
	}
    }
  else
    {
      set_errormsg('Invalid command '.$command);
    }

  if( !$res )
    {
      echo get_errormsg()."\n";
    }
}
?>
