<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !isset($params['checkin']) ) return;

//
// initialization
//
$the_template = $this->GetPreference('current_view_checkin_template');
if( isset($params['template']) ) {
  $the_template = trim($params['template']);
  unset($params['template']);
}
if( !$the_template ) return;
$the_template = 'view_checkin'.$the_template;
$message = '';
$error = '';
$checkin_id = (int)$params['checkin'];
$checkin = null;
if( $checkin_id < 1 ) {
  $error = $this->Lang('error_checkinnotfound');
}
else {
  $checkin = cgsa_checkin::load_by_id($checkin_id);
  if( !is_object($checkin) ) {
    $error = $this->Lang('error_checkinnotfound');
  }
}


$cache_id = '|cgs'.md5(serialize($params));
$compile_id = '';

if( !$smarty->isCached($this->GetDatabaseResource($the_template),$cache_id,$compile_id) ) {
  $smarty->assign('returnid',$returnid);
  $smarty->assign('mod',$this);
  $smarty->assign($this->GetName(),$this);
  $smarty->assign('actionid',$id);
  $smarty->assign('checkin_id',$checkin_id);
  if( is_object($checkin) ) {
    $feu = cms_utils::get_module(MOD_FRONTENDUSERS);
    $uinfo = $feu->GetUserInfo($checkin->owner);
    if( !is_array($uinfo) || $uinfo[0] == FALSE ) {
      $error = $this->Lang('error_usernotfound');
    }
    else {
      $uinfo = $uinfo[1];
      if( isset($uinfo['fprops']) && count($uinfo['fprops']) ) {
	$uinfo['props'] = array();
	foreach( $uinfo['fprops'] as $prop ) {
	  if( isset($prop['url']) ) {
	    $uinfo['props'][$prop['title']] = $prop['url'];
	  }
	  else {
	    $uinfo['props'][$prop['title']] = $prop['data'];
	  }
	}
	unset($uinfo['fprops']);
      }
      $smarty->assign('uinfo',$uinfo);
      $smarty->assign('checkin',$checkin);
      $smarty->assign('uploads_url',$config['uploads_url']);
      $smarty->assign('files_url',$config['uploads_url'].'/_'.$this->GetName());
    }
  }

  $smarty->assign('message',$message);
  $smarty->assign('error',$error);
}

echo $smarty->fetch($this->GetDatabaseResource($the_template),$cache_id,$compile_id);

#
# EOF
#
?>