<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2013 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$the_template = $this->GetPreference('current_list_checkins_template');
if( isset($params['template']) ) {
  $the_template = trim($params['template']);
  unset($params['template']);
}
if( !$the_template ) return;
$the_template = 'list_checkins'.$the_template;

$cache_id = '|cgs'.md5(serialize($params));
$compile_id = '';

if( !$smarty->isCached($this->GetDatabaseResource($the_template),$cache_id,$compile_id) ) {
  unset($params['action']);
  unset($params['module']);
  unset($params['returnid']);

  try {
    $the_query = new cgsa_checkin_query($params);
    $rs = $the_query->execute();

    $n = $rs->RecordCount();
    if( $n ) {
      $feu = cms_utils::get_module('FrontEndUsers');

      $smarty->assign('checkincount',$n);
      $items = array();
      $owners = array();
      $locations = array();
      $activities = array();
      while( !$rs->EOF ) {
	$ob = $rs->get_checkin();
	$items[] = $ob;
	if( !in_array($ob->owner,$owners) ) $owners[] = $ob->owner;
	if( !in_array($ob->location,$locations) ) $locations[] = $ob->location;
	if( $ob->activity && !in_array($ob->activity,$activities) ) $activities[] = $ob->activity;
	$rs->MoveNext();
      }
      $smarty->assign('checkins',$items);

      // get info for these locations
      // this will preload the data efficiently for use in templates
      $lfilter = new cd_company_filter();
      $lfilter['idlist'] = $locations;
      $lquery = new cd_company_query($lfilter);
      $out = $lquery->get_results('cd_',$returnid,$returnid);
      $smarty->assign('locations',$out);

      // get info for these users
      // this will preload the data efficiently for use in templates
      $uquery = new feu_user_query();
      $uquery->set_deep();
      $uquery->set_webready();
      $uquery->add_and_opt(feu_user_query_opt::MATCH_USERLIST,$owners);
      $out = array();
      $rs2 = $uquery->execute();
      while( !$rs2->EOF ) {
	$one = $rs2->fields;
	if( isset($one['fprops']) && count($one['fprops']) ) {
	  $one['props'] = array();
	  foreach( $one['fprops'] as $prop ) {
	    if( isset($prop['url']) ) {
	      $one['props'][$prop['title']] = $prop['url'];
	    }
	    else {
	      $one['props'][$prop['title']] = $prop['data'];
	    }
	  }
	  unset($one['fprops']);
	}
	$out[$one['id']] = $one;
	$rs2->MoveNext();
      }
      $smarty->assign('userinfo',$out);

      // activities
      cgsa_activity::load_all_as_array(); // may be expensive
      $out = array();
      if( count($activities) ) {
	foreach( $activities as $one ) {
	  $out[$one] = cgsa_activity::load_by_id($one);
	}
      }
      $smarty->assign('activities',$out);

      $pagination = $rs->get_pagination();
      $smarty->assign('pagination',$pagination);
    }
  }
  catch( Exception $e ) {
    echo '<!-- '.$this->GetName().' ERROR: '.$e->Getmessage().' -->';
    return;
  }
}

echo $smarty->fetch($this->GetDatabaseResource($the_template),$cache_id,$compile_id);

#
# EOF
#
?>