<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !isset($params['badge']) ) return;

$the_template = $this->GetPreference('current_badgedetail_template');
if( isset($params['template']) ) {
  $the_template = trim($params['template']);
  unset($params['template']);
}
if( !$the_template ) return;
$the_template = 'badgedetail'.$the_template;
$badge_id = (int)$params['badge'];

$cache_id = '|cgs'.md5(serialize($params));
$compile_id = '';


if( !$smarty->isCached($this->GetDatabaseResource($the_template),$cache_id,$compile_id) ) {
  try {
    if( $badge_id < 1 ) throw new Exception($this->Lang('error_badgenotfound'));
    $badge = cgsa_badge::load_by_id($badge_id);
    if( !is_object($badge) ) throw new Exception($this->Lang('error_badgenotfound'));
    $leaderboard = cgsa_leaderboard::load_by_id($badge->leaderboard_id);
    if( !is_object($leaderboard) ) throw new Exception($this->Lang('error_leaderboardnotfound'));

    if( $badge->image != '' ) {
      $dir = cgsa_utils::get_badge_fileurl($badge);
      $badge->image = $dir.'/'.$badge->image;
    }
    $smarty->assign('badge',$badge);
    $smarty->assign('leaderboard',$leaderboard);

    $feu = cms_utils::get_module(MOD_FRONTENDUSERS);
    $uid = $feu->LoggedInId();
    if( $uid > 0 ) {
      $smarty->assign('have_badge',$badge->is_member($uid));
      $friends = cgsa_friends::get_friends($uid);
      if( is_array($friends) && count($friends) ) {
	// get the list of friends that have this badge, at least the first 15 of them.
	$badgefriends = $badge->list_members(25,0,$friends);
	$smarty->assign('badgefriends',$badgefriends);
      }
    }
  }
  catch( Exception $e ) {
    echo $e->GetMessage();
  }
}

echo $smarty->fetch($this->GetDatabaseResource($the_template),$cache_id,$compile_id);

#
# EOF
#
?>