<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$apikey = '';
$op = '';
$output = null;

//
// setup
//
if( isset($_REQUEST['op'] ) ) $op = strtoupper(trim($_REQUEST['op']));
if( isset($_REQUEST['apikey']) ) $apikey = trim($_REQUEST['apikey']);

// dependency check.
$feu = cms_utils::get_module(MOD_FRONTENDUSERS);
if( !$feu ) cgsa_utils::return_error('FrontEndUsers module not found');

// validation check
if( $apikey == '' ) cgsa_utils::return_error('No Authentication Information');
if( $op == '' ) cgsa_utils::return_error('Operation not specified');

// validate the apikey.
$access_info = cgsa_utils::validate_apikey($apikey);
if( !is_object($access_info) ) cgsa_utils::return_error('Invalid authentication information');

// 
// handle the request
//
switch( $op ) {
 case 'REGISTER': // POST REQUEST 
   // adds a new user to the system
   // todo: check if user has access
   // returns 200 for success. 400 for error... 500 for internal error.
   // parameters:  u = username (most follow FEU rules), p = password (must follow FEU rules), v = md5 hash of apikey, username, password
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_REGISTER) )
     cgsa_utils::return_error('Insufficient Permissions');
   $gid = $this->GetPreference('feu_usergroup',-1);
   if( $gid <= 0 ) cgsa_utils::return_error('Internal module configuration error');
   if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
   //if( !cgsa_utils::is_request_secure() ) cgsa_utils::return_error('Insecure request');
   if( !isset($_REQUEST['u']) || !isset($_REQUEST['p']) || !isset($_REQUEST['v']) )
     cgsa_utils::return_error('Insufficient data');
   $v = trim($_REQUEST['v']);
   $u = trim($_REQUEST['u']);
   $p = trim($_REQUEST['p']);
   if( md5($apikey.$u.$p) != $v ) cgsa_utils::return_error('Data validation error');
   $e= strtotime('+5 years');
   $res = $feu->AddUser($u,$p,$e);
   if( !is_array($res) ) cgsa_utils::return_error('Problem attempting to create user');
   if( $res[0] == FALSE ) cgsa_utils::return_error($res[1]);
   $uid = (int)$res[1];
   $res = $feu->AssignUserToGroup( $uid, $gid );
   if( !$res ) {
     // delete the user?
     $feu->DeleteUserFull( $uid );
     cgsa_utils::return_error('Problem adding user to group');
   }
   // TODO: user created.. tie him to this app 
   audit($uid,$this->GetName(),'User '.$u.' created');
   break;

 case 'LOGIN':  // POST REQUEST
   // log user into system
   // accepts: u = username, p = password, v = md5 hash of apikey, username, password.
   // returns 200 for success... 400 for data error, 500 for internal error
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_LOGIN) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_post_request() ) return_error('Invalid request method');
   if( !isset($_REQUEST['u']) || !isset($_REQUEST['p']) || !isset($_REQUEST['v']) )
     cgsa_utils::return_error('Insufficient data');
   $v = trim($_REQUEST['v']);
   $u = trim($_REQUEST['u']);
   $p = trim($_REQUEST['p']);
   if( md5($apikey.$u.$p) != $v ) cgsa_utils::return_error('Data validation error');
   $res = $feu->Login($u,$p);
   if( !is_array($res) ) cgsa_utils::return_error('Problem with user credentials');
   if( $res[0] == FALSE ) cgsa_utils::return_error($res[1]);
   // now we need a unique method of identifying this user... and generating a session.
   $output = $res[0];
   break;

 case 'PING':    // GET REQUEST
   // mark the user as still active
   // accepts: uid = uid, v = md5 hash of apikey+uid
   // returns 200 for success... 400 for data error, 500 for internal error.
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_LOGIN) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_get_request() ) return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) || !isset($_REQUEST['v']) ) cgsa_utils::return_error('Insufficient data');
   $uid = trim($_REQUEST['uid']);
   $v = trim($_REQUEST['v']);
   if( md5($apikey.$uid) != $v ) cgsa_utils::return_error('Data validation error');
   $tmp = $feu->LoggedInId();
   if( $tmp != $uid ) cgsa_utils::return_error("User validation error:: got: '$tmp' expected: '$uid' (session ".session_id().')');
   break;

 case 'LOGOUT':  // POST REQUEST
   // log user out of session.
   // accepts: uid = userid, v = md5 hash of apikey, uid
   // requires valid session id. (can't logout arbitrary user).
   // returns 200 on success... 400 for error.
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_LOGIN) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_post_request() ) return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) || !isset($_REQUEST['v']) ) cgsa_utils::return_error('Insufficient data');
   $uid = trim($_REQUEST['uid']);
   $v = trim($_REQUEST['v']);
   if( md5($apikey.$uid) != $v ) cgsa_utils::return_error('Data validation error');
   $tuid = $feu->LoggedInId();
   if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
   $feu->Logout($uid);
   break;

 case 'GETINFO': // GET REQUEST
   // get user information
   // accepts: uid = uid , v = md5 hash of apikey+uid
   // returns 200 for success... 400 for data error, 500 for internal error
   // returns array of user info.
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_get_request() ) return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) || !isset($_REQUEST['v']) )
     cgsa_utils::return_error('Insufficient data');
   $uid = trim($_REQUEST['uid']);
   $v = trim($_REQUEST['v']);
   if( md5($apikey.$uid) != $v ) cgsa_utils::return_error('Data validation error');
   // security check.. can only retrieve your own info.
   if( $feu->LoggedInId() != $uid ) cgsa_utils::return_error('User validation error');
   $user = $feu->GetUserInfo($uid);
   if( !is_array($user) && $user[0] == TRUE ) {
     cgsa_utils::return_error('User Info not found');
   }
   else {
     $output = $user[1];
     if( isset($output['password']) ) unset($output['password']);
     $defns = $feu->GetPropertyDefns();
     $output['props'] = $feu->GetUserProperties($uid);
     for( $i = 0; $i < count($output); $i++ ) {
       $name = $output[$i]['title'];
       if( $defns[$name]['type'] == 6 ) { // image
	 // get the full url to this image.
	 $config = cmsms()->GetConfig();
	 $output[$i]['url'] = $config['uploads_url'].'/feusers/'.$output[$i]['data'];
       }
     }
   }
   break;

 case 'SETPROPS': // POST REQUEST
   // set user info
   // accepts uid, v and other optional params
   // ::password::
   // ::repeatepassword::
   // property=value -- specifies properties (according to user group)
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_WRITE) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) || !isset($_REQUEST['v']) ) cgsa_utils::return_error('Insufficient data');
   $uid = trim($_REQUEST['uid']);
   $v = trim($_REQUEST['v']);
   if( md5($apikey.$uid) != $v ) cgsa_utils::return_error('Data validation error');
   // security check.. can only modify your own info.
   if( $feu->LoggedInId() != $uid ) cgsa_utils::return_error('User validation error');
   $have_modified = FALSE;
   // handle set user password.
   if( isset($_REQUEST['::password::']) && isset($_REQUEST['::repeatpassword::']) ) {
     if( $_REQUEST['::password::'] != $_REQUEST['::repeatpassword::'] ) {
       cgsa_utils::return_error('Passwords do not match');
     }
     else if( !$feu->IsValidPassword($_REQUEST['::password::']) ) {
       cgsa_utils::return_error('Invalid Password');
     }
     else {
       $res = $feu->SetUserPassword($uid,$_REQUEST['::password::']);
       if( $res[0] == FALSE ) cgsa_utils::return_error($res[1]);
       $have_modified = TRUE;
     }
   }
   $cur_info = $feu->GetUserPropertyRelations($uid);
   $input = array();
   $count = 0;
   foreach($cur_info as $one ) {
     $key = $one['name'];
     if( !isset($_REQUEST[$key]) ) continue;

     $res = $feu->SetUserPropertyFull($key,trim($_REQUEST[$key]),$uid);
     if( !$res ) cgsa_utils::return_error('Problem setting property '.$key);
     $count++;
   }
   if( $count == 0 && !$have_modified ) cgsa_utils::return_error('Nothing to do');
   break;
    
 case 'PROPERTIES': // GET 
   // retrieve list of user properties
   // accepts: uid, v = md5 hash of apikey+uid
   // returns array of user properties
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_get_request() ) return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) || !isset($_REQUEST['v']) ) cgsa_utils::return_error('Insufficient data');
   $uid = trim($_REQUEST['uid']);
   $v = trim($_REQUEST['v']);
   if( md5($apikey.$uid) != $v ) cgsa_utils::return_error('Data validation error');
   // security check.. can only modify your own info.
   if( $feu->LoggedInId() != $uid ) cgsa_utils::return_error('User validation error');
   // get the users groups
   $uproperties = $feu->GetUserPropertyRelations($uid);
   $props = array();
   $defns = $feu->GetPropertyDefns();
   for( $b = 0; $b < count($uproperties); $b++ ) {
     $name = $uproperties[$b]['name'];
     if( !isset($defns[$name]) ) continue; // why would this happen?
     $props[$name] = $defns[$name];
   }
   $output = $props;
   // get the properties for those group
   // as a union.
   break;

 case 'BADGES': // GET
   // retrieve user badge id's (if any).
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) ) cgsa_utils::return_error('Insufficient data');
   $list = cgsa_badge_utils::get_member_badges((int)$_REQUEST['uid']);
   if( is_array($list) && count($list) ) {
     $output = $list;
   }
   break;

 case 'HISTORY': // GET
   // retrieve user history
   // accepts: uid, v = md5 hash of apikey+uid, [n = number of entries] [stime = start timestamp]
   // requires valid session id (can't get data on arbitrary user)
   //
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) ) cgsa_utils::return_error('Insufficient data');
   break;

 case 'LIST': // GET
   // retrieve user list.
   // accepts: uid, [userpattern,property,proppattern,n,o];
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) ) cgsa_utils::return_error('Insufficient data');
   $n = 50;
   $o = 0;

   $userpattern = '';
   $property = '';
   $proppattern = '';
   if( isset($_REQUEST['n']) ) $n = max(0,min(10000,(int)$_REQUEST['n']));
   if( isset($_REQUEST['o']) ) $o = max(0,min(100000,(int)$_REQUEST['o']));
   $query = new feu_user_query($n);
   $query->set_deep();
   if( isset($_REQUEST['userpattern']) ) $query->add_and_opt(feu_user_query_opt::MATCH_USERNAME_RE,trim($_REQUEST['userpattern']));
   if( isset($_REQUEST['property']) && isset($_REQUEST['proppattern']) ) {
     $query->add_and_opt(feu_user_query_opt::MATCH_PROPERTY_RE,
			 trim($_REQUEST['property']),
			 trim($_REQUEST['proppattern']));;
   }
   if( isset($_REQUEST['idlist']) ) $query->add_and_opt(feu_user_query_opt::MATCH_USERLIST,$_REQUEST['idlist']);
   $query->set_result_type(feu_user_query::RESULT_TYPE_LIST);
   if( isset($_REQUEST['full']) && $_REQUEST['full'] ) $query->set_result_type(feu_user_query::RESULT_TYPE_FULL);
   
   $rs = $query->execute();
   $output = array();
   while( !$rs->EOF ) {
     $output[] = $rs->fields;
     $rs->MoveNext();
   }
   break;

 default:
   if( cgsa_utils::is_post_request() ) return_error('Invalid Operation');
   break;
 }

cgsa_utils::return_success($output);

#
# EOF
#
?>